/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BasePortalReleaseJob;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class PortalReleaseJob
extends BasePortalReleaseJob {
    private String _portalReleaseRef;

    public PortalReleaseJob(String jobName, Job.BuildProfile buildProfile, String portalBranchName, String testSuiteName) {
        super(jobName, buildProfile, portalBranchName, testSuiteName);
    }

    public void setPortalReleaseRef(String portalReleaseRef) {
        this._portalReleaseRef = portalReleaseRef;
    }

    @Override
    protected Set<String> getRawBatchNames() {
        Set<String> batchNames = super.getRawBatchNames();
        batchNames.addAll(this._getOptionalBatchNames());
        return batchNames;
    }

    private Set<String> _getOptionalBatchNames() {
        if (this._portalReleaseRef == null) {
            return Collections.emptySet();
        }
        TreeSet<String> batchNames = new TreeSet<String>();
        Properties jobProperties = this.getJobProperties();
        batchNames.addAll(this.getSetFromString(JenkinsResultsParserUtil.getProperty(jobProperties, "test.batch.names.optional", false, this._portalReleaseRef)));
        Job.BuildProfile buildProfile = this.getBuildProfile();
        batchNames.addAll(this.getSetFromString(JenkinsResultsParserUtil.getProperty(jobProperties, "test.batch.names.optional", false, this._portalReleaseRef, buildProfile.toString())));
        return batchNames;
    }
}

