/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalFixpackRelease;
import com.liferay.jenkins.results.parser.PortalHotfixRelease;
import com.liferay.jenkins.results.parser.PortalHotfixReleaseBuild;
import com.liferay.jenkins.results.parser.PortalRelease;
import com.liferay.jenkins.results.parser.PortalTopLevelBuild;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PortalHotfixReleasePortalTopLevelBuild
extends PortalTopLevelBuild
implements PortalHotfixReleaseBuild {
    private static final Pattern _hotfixZipURLPattern = Pattern.compile("https?://.*(?<majorVersion>\\d)(?<minorVersion>\\d)(?<fixVersion>\\d{2})\\.(lpkg|zip)");
    private static final Pattern _patcherPortalVersion62Pattern = Pattern.compile("(?<majorVersion>\\d)\\.(?<minorVersion>\\d)\\.(?<fixVersion>\\d{2})( SP(?<servicePackVersion>\\d+))?");
    private static final Pattern _patcherPortalVersionDXPPattern = Pattern.compile("fix-pack-(?<fixpackType>de|dxp)-(?<fixpackVersion>\\d+)-(?<majorVersion>\\d)(?<minorVersion>\\d)(?<fixVersion>\\d{2})");
    private PortalFixpackRelease _portalFixpackRelease;
    private PortalHotfixRelease _portalHotfixRelease;
    private PortalRelease _portalRelease;

    public PortalHotfixReleasePortalTopLevelBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    public String getBaseGitRepositoryName() {
        return "liferay-portal-ee";
    }

    @Override
    public String getBranchName() {
        String testBuildHotfixZipURL = this.getParameterValue("TEST_BUILD_HOTFIX_ZIP_URL");
        if (JenkinsResultsParserUtil.isNullOrEmpty(testBuildHotfixZipURL)) {
            throw new RuntimeException("Please set 'TEST_BUILD_HOTFIX_ZIP_URL'");
        }
        Matcher matcher = _hotfixZipURLPattern.matcher(testBuildHotfixZipURL);
        if (!matcher.find()) {
            throw new RuntimeException("Please set a valid 'TEST_BUILD_HOTFIX_ZIP_URL'");
        }
        String branchName = JenkinsResultsParserUtil.combine(matcher.group("majorVersion"), ".", matcher.group("minorVersion"), ".x");
        if (branchName.startsWith("6")) {
            return "ee-" + branchName;
        }
        return branchName;
    }

    @Override
    public PortalFixpackRelease getPortalFixpackRelease() {
        if (this._portalFixpackRelease != null) {
            return this._portalFixpackRelease;
        }
        String patcherPortalVersion = this.getParameterValue("PATCHER_BUILD_PATCHER_PORTAL_VERSION");
        if (JenkinsResultsParserUtil.isNullOrEmpty(patcherPortalVersion)) {
            return null;
        }
        Matcher matcher = _patcherPortalVersionDXPPattern.matcher(patcherPortalVersion);
        if (!matcher.find()) {
            return null;
        }
        try {
            URL portalFixpackURL = new URL(JenkinsResultsParserUtil.combine("https://files.liferay.com/private/ee/fix-packs/", matcher.group("majorVersion"), ".", matcher.group("minorVersion"), ".", matcher.group("fixVersion"), "/", matcher.group("fixpackType"), "/liferay-", patcherPortalVersion, ".zip"));
            this._portalFixpackRelease = new PortalFixpackRelease(portalFixpackURL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        return this._portalFixpackRelease;
    }

    @Override
    public PortalHotfixRelease getPortalHotfixRelease() {
        if (this._portalHotfixRelease != null) {
            return this._portalHotfixRelease;
        }
        try {
            this._portalHotfixRelease = new PortalHotfixRelease(new URL(this.getParameterValue("TEST_BUILD_HOTFIX_ZIP_URL")), this.getPortalFixpackRelease(), this.getPortalRelease());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        return this._portalHotfixRelease;
    }

    @Override
    public PortalRelease getPortalRelease() {
        Matcher patcherPortalVersion62Matcher;
        if (this._portalRelease != null) {
            return this._portalRelease;
        }
        PortalFixpackRelease portalFixpackRelease = this.getPortalFixpackRelease();
        if (portalFixpackRelease != null) {
            this._portalRelease = portalFixpackRelease.getPortalRelease();
            return this._portalRelease;
        }
        String patcherPortalVersion = this.getParameterValue("PATCHER_BUILD_PATCHER_PORTAL_VERSION");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(patcherPortalVersion) && (patcherPortalVersion62Matcher = _patcherPortalVersion62Pattern.matcher(patcherPortalVersion)).find()) {
            StringBuilder sb = new StringBuilder();
            sb.append(patcherPortalVersion62Matcher.group("majorVersion"));
            sb.append(".");
            sb.append(patcherPortalVersion62Matcher.group("minorVersion"));
            sb.append(".");
            sb.append(patcherPortalVersion62Matcher.group("fixVersion"));
            String servicePackVersion = patcherPortalVersion62Matcher.group("servicePackVersion");
            if (JenkinsResultsParserUtil.isNullOrEmpty(servicePackVersion)) {
                sb.append(".");
                sb.append(Integer.parseInt(servicePackVersion) + 1);
            }
            this._portalRelease = new PortalRelease(sb.toString());
            return this._portalRelease;
        }
        Matcher hotfixZipURLMatcher = _hotfixZipURLPattern.matcher(this.getParameterValue("TEST_BUILD_HOTFIX_ZIP_URL"));
        if (!hotfixZipURLMatcher.find()) {
            return null;
        }
        this._portalRelease = new PortalRelease(JenkinsResultsParserUtil.combine(hotfixZipURLMatcher.group("majorVersion"), ".", hotfixZipURLMatcher.group("minorVersion"), ".", hotfixZipURLMatcher.group("fixVersion")));
        return this._portalRelease;
    }
}

