/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.PortalFixpackRelease;
import com.liferay.jenkins.results.parser.PortalRelease;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PortalHotfixRelease {
    private static final Pattern _pattern = Pattern.compile("https?://.+/(?<hotfixName>liferay-(hotfix|security-de|security-dxp)-(?<hotfixVersion>\\d+)(-\\d{6}-\\d)?-\\d{4})");
    private final PortalFixpackRelease _portalFixpackRelease;
    private final URL _portalHotfixReleaseURL;
    private final PortalRelease _portalRelease;

    public PortalHotfixRelease(URL portalHotfixReleaseURL, PortalFixpackRelease portalFixpackRelease, PortalRelease portalRelease) {
        this._portalHotfixReleaseURL = portalHotfixReleaseURL;
        this._portalFixpackRelease = portalFixpackRelease;
        this._portalRelease = portalRelease;
    }

    public PortalFixpackRelease getPortalFixpackRelease() {
        return this._portalFixpackRelease;
    }

    public String getPortalHotfixReleaseName() {
        String portalHotfixReleaseURLString = String.valueOf(this._portalHotfixReleaseURL);
        Matcher matcher = _pattern.matcher(portalHotfixReleaseURLString);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group("hotfixName");
    }

    public URL getPortalHotfixReleaseURL() {
        return this._portalHotfixReleaseURL;
    }

    public String getPortalHotfixReleaseVersion() {
        String portalHotfixReleaseURLString = String.valueOf(this._portalHotfixReleaseURL);
        Matcher matcher = _pattern.matcher(portalHotfixReleaseURLString);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group("hotfixVersion");
    }

    public PortalRelease getPortalRelease() {
        return this._portalRelease;
    }
}

