/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalFixpackRelease;
import com.liferay.jenkins.results.parser.PortalRelease;
import com.liferay.jenkins.results.parser.PortalTopLevelBuild;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PortalFixpackReleasePortalTopLevelBuild
extends PortalTopLevelBuild {
    private static final Pattern _pattern = Pattern.compile("(?<major>\\d)\\.(?<minor>\\d)\\.(?<fix>\\d+)");
    private PortalFixpackRelease _portalFixpackRelease;
    private PortalRelease _portalRelease;

    public PortalFixpackReleasePortalTopLevelBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    public String getBaseGitRepositoryName() {
        return "liferay-portal-ee";
    }

    @Override
    public String getBranchName() {
        PortalFixpackRelease portalFixpackRelease = this.getPortalFixpackRelease();
        PortalRelease portalRelease = portalFixpackRelease.getPortalRelease();
        String portalVersion = portalRelease.getPortalVersion();
        Matcher matcher = _pattern.matcher(portalVersion);
        if (!matcher.find()) {
            throw new RuntimeException("Invalid portal version: " + portalVersion);
        }
        String branchName = JenkinsResultsParserUtil.combine(matcher.group("major"), ".", matcher.group("minor"), ".x");
        if (branchName.equals("6.1.x")) {
            return "ee-6.1.30";
        }
        if (branchName.equals("6.2.x")) {
            return "ee-6.2.10";
        }
        return branchName;
    }

    @Override
    public PortalFixpackRelease getPortalFixpackRelease() {
        if (this._portalFixpackRelease != null) {
            return this._portalFixpackRelease;
        }
        try {
            URL portalFixpackURL = new URL(this.getParameterValue("TEST_BUILD_FIX_PACK_ZIP_URL"));
            this._portalFixpackRelease = new PortalFixpackRelease(portalFixpackURL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        return this._portalFixpackRelease;
    }

    @Override
    public PortalRelease getPortalRelease() {
        if (this._portalRelease != null) {
            return this._portalRelease;
        }
        PortalFixpackRelease portalFixpackRelease = this.getPortalFixpackRelease();
        this._portalRelease = portalFixpackRelease.getPortalRelease();
        return this._portalRelease;
    }
}

