/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class PortalEnvironmentJob
extends BaseJob
implements PortalTestClassJob {
    private final String _portalBranchName;

    @Override
    public Set<String> getDistTypes() {
        return new HashSet<String>();
    }

    @Override
    public PortalGitWorkingDirectory getPortalGitWorkingDirectory() {
        return GitWorkingDirectoryFactory.newPortalGitWorkingDirectory(this.getPortalBranchName());
    }

    protected PortalEnvironmentJob(String jobName, Job.BuildProfile buildProfile, String portalBranchName) {
        super(jobName, buildProfile);
        this._portalBranchName = portalBranchName;
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        this.jobPropertiesFiles.add(new File(portalGitWorkingDirectory.getWorkingDirectory(), "test.properties"));
        GitWorkingDirectory jenkinsGitWorkingDirectory = GitWorkingDirectoryFactory.newJenkinsGitWorkingDirectory();
        this.jobPropertiesFiles.add(new File(jenkinsGitWorkingDirectory.getWorkingDirectory(), "commands/dependencies/test-environment.properties"));
        this.readJobProperties();
    }

    protected String getPortalBranchName() {
        return this._portalBranchName;
    }

    @Override
    protected Set<String> getRawBatchNames() {
        String environmentJobNames = JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "environment.job.names", this.getPortalBranchName());
        return new HashSet<String>(Arrays.asList(environmentJobNames.split(",")));
    }
}

