/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import java.io.File;
import java.util.Collections;
import java.util.Set;

public class PortalAppReleaseJob
extends BaseJob
implements PortalTestClassJob {
    private final PortalGitWorkingDirectory _portalGitWorkingDirectory;

    @Override
    public Set<String> getDistTypes() {
        return Collections.emptySet();
    }

    @Override
    public PortalGitWorkingDirectory getPortalGitWorkingDirectory() {
        return this._portalGitWorkingDirectory;
    }

    @Override
    public boolean isSegmentEnabled() {
        return true;
    }

    protected PortalAppReleaseJob(String jobName, Job.BuildProfile buildProfile, String portalBranchName) {
        super(jobName, buildProfile);
        GitWorkingDirectory jenkinsGitWorkingDirectory = GitWorkingDirectoryFactory.newJenkinsGitWorkingDirectory();
        this.jobPropertiesFiles.add(new File(jenkinsGitWorkingDirectory.getWorkingDirectory(), "commands/build.properties"));
        this._portalGitWorkingDirectory = GitWorkingDirectoryFactory.newPortalGitWorkingDirectory(portalBranchName);
        this.jobPropertiesFiles.add(new File(this._portalGitWorkingDirectory.getWorkingDirectory(), "test.properties"));
        this.readJobProperties();
    }

    @Override
    protected Set<String> getRawBatchNames() {
        String testBatchName;
        Job.BuildProfile buildProfile = this.getBuildProfile();
        if (buildProfile == null) {
            buildProfile = Job.BuildProfile.PORTAL;
        }
        if (JenkinsResultsParserUtil.isNullOrEmpty(testBatchName = JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.names", false, this.getJobName(), buildProfile.toString()))) {
            testBatchName = JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.names", false, this.getJobName(), this._portalGitWorkingDirectory.getUpstreamBranchName(), buildProfile.toString());
        }
        return this.getSetFromString(testBatchName);
    }
}

