/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PluginsGitRepositoryJob;
import com.liferay.jenkins.results.parser.TestSuiteJob;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public abstract class PluginsTestSuiteJob
extends PluginsGitRepositoryJob
implements TestSuiteJob {
    private final String _pluginName;

    public String getPluginName() {
        return this._pluginName;
    }

    @Override
    public List<File> getPluginsTestBaseDirs() {
        return Arrays.asList(this._getPluginTestBaseDir());
    }

    @Override
    public String getTestSuiteName() {
        return this.getPluginName();
    }

    protected PluginsTestSuiteJob(String jobName, String pluginName, Job.BuildProfile buildProfile, String branchName) {
        super(jobName, buildProfile, branchName);
        this._pluginName = pluginName;
        this.jobPropertiesFiles.add(new File(this._getPluginTestBaseDir(), "test.properties"));
    }

    @Override
    protected Set<String> getRawBatchNames() {
        return this.getSetFromString(JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.names", this.getJobName(), this.getTestSuiteName()));
    }

    private File _getPluginTestBaseDir() {
        GitWorkingDirectory pluginsGitWorkingDirectory = this.getGitWorkingDirectory();
        return new File(pluginsGitWorkingDirectory.getWorkingDirectory(), JenkinsResultsParserUtil.combine("portlets/", this.getPluginName(), "/test/functional"));
    }
}

