/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.TestSuiteJob;
import java.io.File;
import java.util.Collections;
import java.util.Set;

public class PluginsMarketplaceAppJob
extends BaseJob
implements PortalTestClassJob,
TestSuiteJob {
    private final String _appType;
    private final PortalGitWorkingDirectory _portalGitWorkingDirectory;

    @Override
    public Set<String> getDistTypes() {
        return Collections.emptySet();
    }

    @Override
    public PortalGitWorkingDirectory getPortalGitWorkingDirectory() {
        return this._portalGitWorkingDirectory;
    }

    @Override
    public String getTestSuiteName() {
        return this._appType;
    }

    protected PluginsMarketplaceAppJob(String jobName, String appType, Job.BuildProfile buildProfile, String portalBranchName) {
        super(jobName, buildProfile);
        if (JenkinsResultsParserUtil.isNullOrEmpty(appType)) {
            appType = System.getenv("TEST_APP_TYPE");
        }
        if (JenkinsResultsParserUtil.isNullOrEmpty(appType)) {
            appType = "community";
        }
        this._appType = appType;
        this._portalGitWorkingDirectory = GitWorkingDirectoryFactory.newPortalGitWorkingDirectory(portalBranchName);
        this.jobPropertiesFiles.add(new File(this._portalGitWorkingDirectory.getWorkingDirectory(), "test.properties"));
        this.readJobProperties();
    }

    @Override
    protected Set<String> getRawBatchNames() {
        return this.getSetFromString(JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.names", this.getJobName(), this.getTestSuiteName()));
    }
}

