/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitRepositoryJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public abstract class PluginsGitRepositoryJob
extends GitRepositoryJob
implements PortalTestClassJob {
    protected Properties buildProperties;
    protected PortalGitWorkingDirectory portalGitWorkingDirectory;
    private final String _branchName;

    @Override
    public String getBranchName() {
        return this._branchName;
    }

    @Override
    public Set<String> getDistTypes() {
        String testBatchDistAppServers = JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.dist.app.servers");
        return this.getSetFromString(testBatchDistAppServers);
    }

    @Override
    public GitWorkingDirectory getGitWorkingDirectory() {
        if (this.gitWorkingDirectory != null) {
            return this.gitWorkingDirectory;
        }
        String pluginsBranchName = this.getBranchName();
        String workingDirectoryPath = this.getBuildPropertyValue(JenkinsResultsParserUtil.combine("plugins.dir[", pluginsBranchName, "]"));
        this.gitWorkingDirectory = GitWorkingDirectoryFactory.newGitWorkingDirectory(pluginsBranchName, workingDirectoryPath);
        return this.gitWorkingDirectory;
    }

    public abstract List<File> getPluginsTestBaseDirs();

    @Override
    public PortalGitWorkingDirectory getPortalGitWorkingDirectory() {
        return this.portalGitWorkingDirectory;
    }

    protected PluginsGitRepositoryJob(String jobName, Job.BuildProfile buildProfile, String branchName) {
        super(jobName, buildProfile);
        this._branchName = branchName;
        this.getGitWorkingDirectory();
        this.setGitRepositoryDir(this.gitWorkingDirectory.getWorkingDirectory());
        this.checkGitRepositoryDir();
        String portalBranchName = this.getBuildPropertyValue(JenkinsResultsParserUtil.combine("plugins.portal.branch.name[", this.getBranchName(), "]"));
        File portalGitRepositoryDir = new File(this.getBuildPropertyValue(JenkinsResultsParserUtil.combine("portal.dir[", portalBranchName, "]")));
        this.jobPropertiesFiles.add(new File(portalGitRepositoryDir, "test.properties"));
        this.portalGitWorkingDirectory = (PortalGitWorkingDirectory)GitWorkingDirectoryFactory.newGitWorkingDirectory(portalBranchName, portalGitRepositoryDir.getPath());
    }

    protected String getBuildPropertyValue(String buildPropertyName) {
        if (this.buildProperties == null) {
            try {
                this.buildProperties = JenkinsResultsParserUtil.getBuildProperties();
            }
            catch (IOException ioException) {
                throw new RuntimeException("Unable to get build properties", ioException);
            }
        }
        return this.buildProperties.getProperty(buildPropertyName);
    }

    @Override
    protected Set<String> getRawBatchNames() {
        return this.getSetFromString(JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.names", this.getJobName()));
    }
}

