/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import java.io.File;
import java.util.Collections;
import java.util.Set;

public class PluginsExtraAppsJob
extends BaseJob
implements PortalTestClassJob {
    private final PortalGitWorkingDirectory _portalGitWorkingDirectory;

    @Override
    public Set<String> getDistTypes() {
        return Collections.emptySet();
    }

    @Override
    public PortalGitWorkingDirectory getPortalGitWorkingDirectory() {
        return this._portalGitWorkingDirectory;
    }

    protected PluginsExtraAppsJob(String jobName, Job.BuildProfile buildProfile, String portalBranchName) {
        super(jobName, buildProfile);
        this._portalGitWorkingDirectory = GitWorkingDirectoryFactory.newPortalGitWorkingDirectory(portalBranchName);
        this.jobPropertiesFiles.add(new File(this._portalGitWorkingDirectory.getWorkingDirectory(), "test.properties"));
        this.readJobProperties();
    }

    @Override
    protected Set<String> getRawBatchNames() {
        String portalBundleVersion = System.getenv("TEST_PORTAL_BUNDLE_VERSION");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(portalBundleVersion)) {
            return this.getSetFromString(JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.names", this.getJobName()));
        }
        return this.getSetFromString(JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.names", this.getJobName(), "release"));
    }
}

