/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ParallelExecutor<T> {
    private final Collection<Callable<T>> _callables;
    private final boolean _disposeExecutor;
    private boolean _excludeNulls;
    private ExecutorService _executorService;

    public ParallelExecutor(Collection<Callable<T>> callables, boolean excludeNulls, ExecutorService executorService) {
        this._callables = callables;
        this._excludeNulls = excludeNulls;
        this._executorService = executorService;
        if (this._executorService == null) {
            this._disposeExecutor = true;
            this._executorService = Executors.newSingleThreadExecutor();
        } else {
            this._disposeExecutor = false;
        }
    }

    public ParallelExecutor(Collection<Callable<T>> callables, ExecutorService executorService) {
        this(callables, false, executorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> execute() {
        try {
            ArrayList<Future<T>> futures = new ArrayList<Future<T>>(this._callables.size());
            for (Callable<T> callable : this._callables) {
                futures.add(this._executorService.submit(callable));
            }
            ArrayList results = new ArrayList(this._callables.size());
            for (Future future : futures) {
                try {
                    Object result = future.get();
                    if (result == null && this._excludeNulls) continue;
                    results.add(result);
                }
                catch (InterruptedException | ExecutionException exception) {
                    throw new RuntimeException(exception);
                }
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        finally {
            if (this._disposeExecutor) {
                this._executorService.shutdown();
                while (!this._executorService.isShutdown()) {
                    JenkinsResultsParserUtil.sleep(100L);
                }
                this._executorService = null;
            }
        }
    }
}

