/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MultiPattern {
    private final List<Pattern> _patterns;

    public MultiPattern(String ... patternStrings) {
        this._patterns = new ArrayList<Pattern>(patternStrings.length);
        for (String patternString : patternStrings) {
            this._patterns.add(Pattern.compile(patternString));
        }
    }

    public Matcher find(String input) {
        for (Pattern pattern : this._patterns) {
            Matcher matcher = pattern.matcher(input);
            if (!matcher.find()) continue;
            return matcher;
        }
        return null;
    }

    public int getSize() {
        return this._patterns.size();
    }

    public int indexOf(Pattern pattern) {
        return this._patterns.indexOf(pattern);
    }

    public Matcher matches(String input) {
        for (Pattern pattern : this._patterns) {
            Matcher matcher = pattern.matcher(input);
            if (!matcher.matches()) continue;
            return matcher;
        }
        return null;
    }

    public boolean matchesAll(String ... inputs) {
        for (String input : inputs) {
            if (this.matches(input) != null) continue;
            return false;
        }
        return true;
    }
}

