/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.BuildData;
import com.liferay.jenkins.results.parser.CentralMergePullRequestJob;
import com.liferay.jenkins.results.parser.DefaultPortalJob;
import com.liferay.jenkins.results.parser.FixPackBuilderGitRepositoryJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PluginsAcceptancePullRequestJob;
import com.liferay.jenkins.results.parser.PluginsExtraAppsJob;
import com.liferay.jenkins.results.parser.PluginsMarketplaceAppJob;
import com.liferay.jenkins.results.parser.PluginsReleaseJob;
import com.liferay.jenkins.results.parser.PluginsUpstreamJob;
import com.liferay.jenkins.results.parser.PortalAWSJob;
import com.liferay.jenkins.results.parser.PortalAcceptancePullRequestJob;
import com.liferay.jenkins.results.parser.PortalAcceptanceUpstreamJob;
import com.liferay.jenkins.results.parser.PortalAppReleaseJob;
import com.liferay.jenkins.results.parser.PortalBuildData;
import com.liferay.jenkins.results.parser.PortalEnvironmentJob;
import com.liferay.jenkins.results.parser.PortalFixpackEnvironmentJob;
import com.liferay.jenkins.results.parser.PortalFixpackReleaseJob;
import com.liferay.jenkins.results.parser.PortalGitRepositoryJob;
import com.liferay.jenkins.results.parser.PortalHotfixReleaseJob;
import com.liferay.jenkins.results.parser.PortalReleaseEnvironmentJob;
import com.liferay.jenkins.results.parser.PortalReleaseJob;
import com.liferay.jenkins.results.parser.PortalTestSuiteUpstreamJob;
import com.liferay.jenkins.results.parser.PortalUpstreamJob;
import com.liferay.jenkins.results.parser.QAWebsitesGitRepositoryJob;
import com.liferay.jenkins.results.parser.RootCauseAnalysisToolBatchJob;
import com.liferay.jenkins.results.parser.RootCauseAnalysisToolJob;
import com.liferay.jenkins.results.parser.SimpleJob;
import com.liferay.jenkins.results.parser.SubrepositoryAcceptancePullRequestJob;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JobFactory {
    private static final Map<String, Job> _jobs = new HashMap<String, Job>();

    public static Job newJob(Build build) {
        TopLevelBuild topLevelBuild = build.getTopLevelBuild();
        return JobFactory._newJob(topLevelBuild.getJobName(), topLevelBuild.getTestSuiteName(), topLevelBuild.getBranchName(), topLevelBuild.getBaseGitRepositoryName(), topLevelBuild.getBuildProfile(), topLevelBuild.getProjectNames());
    }

    public static Job newJob(BuildData buildData) {
        String upstreamBranchName = null;
        if (buildData instanceof PortalBuildData) {
            PortalBuildData portalBuildData = (PortalBuildData)buildData;
            upstreamBranchName = portalBuildData.getPortalUpstreamBranchName();
        }
        return JobFactory._newJob(buildData.getJobName(), null, upstreamBranchName, null, null);
    }

    public static Job newJob(String jobName) {
        return JobFactory._newJob(jobName, null, null, null, null);
    }

    public static Job newJob(String jobName, String testSuiteName) {
        return JobFactory._newJob(jobName, testSuiteName, null, null, null);
    }

    public static Job newJob(String jobName, String testSuiteName, String branchName) {
        return JobFactory._newJob(jobName, testSuiteName, branchName, null, null);
    }

    public static Job newJob(String jobName, String testSuiteName, String branchName, String repositoryName) {
        return JobFactory._newJob(jobName, testSuiteName, branchName, repositoryName, null);
    }

    public static Job newJob(String jobName, String testSuiteName, String branchName, String repositoryName, Job.BuildProfile buildProfile) {
        return JobFactory._newJob(jobName, testSuiteName, branchName, repositoryName, buildProfile);
    }

    private static boolean _isCentralMergePullRequest(GitWorkingDirectory gitWorkingDirectory) {
        File modifiedFile;
        String modifiedFileName;
        List<File> currentBranchModifiedFiles = gitWorkingDirectory.getModifiedFilesList();
        return currentBranchModifiedFiles.size() == 1 && (modifiedFileName = (modifiedFile = currentBranchModifiedFiles.get(0)).getName()).equals("ci-merge");
    }

    private static Job _newJob(String jobName, String testSuiteName, String branchName, String repositoryName, Job.BuildProfile buildProfile) {
        return JobFactory._newJob(jobName, testSuiteName, branchName, repositoryName, buildProfile, null);
    }

    private static Job _newJob(String jobName, String testSuiteName, String branchName, String repositoryName, Job.BuildProfile buildProfile, List<String> projectNames) {
        Job job;
        if (buildProfile == null) {
            buildProfile = Job.BuildProfile.PORTAL;
        }
        String jobKey = JenkinsResultsParserUtil.combine(jobName, "-", buildProfile.toString());
        if (testSuiteName != null && !testSuiteName.isEmpty()) {
            jobKey = JenkinsResultsParserUtil.combine(jobName, "-", testSuiteName);
        }
        if ((job = _jobs.get(jobKey)) != null) {
            return job;
        }
        if (jobName.equals("js-test-csv-report") || jobName.equals("junit-test-csv-report")) {
            PortalGitRepositoryJob portalGitRepositoryJob = new PortalGitRepositoryJob(jobName, buildProfile){

                @Override
                protected GitWorkingDirectory getNewGitWorkingDirectory() {
                    return GitWorkingDirectoryFactory.newGitWorkingDirectory(this.getBranchName(), System.getProperty("user.dir"));
                }

                @Override
                protected void init() {
                    try {
                        this.setJobProperties(JenkinsResultsParserUtil.getBuildProperties());
                    }
                    catch (IOException ioException) {
                        throw new RuntimeException(ioException);
                    }
                    this.gitWorkingDirectory = this.getNewGitWorkingDirectory();
                    this.setGitRepositoryDir(this.gitWorkingDirectory.getWorkingDirectory());
                    this.checkGitRepositoryDir();
                }
            };
            _jobs.put(jobKey, portalGitRepositoryJob);
            return _jobs.get(jobKey);
        }
        if (jobName.equals("root-cause-analysis-tool")) {
            _jobs.put(jobKey, new RootCauseAnalysisToolJob(jobName, buildProfile, branchName));
            return _jobs.get(jobKey);
        }
        if (jobName.equals("root-cause-analysis-tool-batch")) {
            _jobs.put(jobKey, new RootCauseAnalysisToolBatchJob(jobName, buildProfile, branchName));
            return _jobs.get(jobKey);
        }
        if (jobName.equals("test-fixpack-builder-pullrequest")) {
            FixPackBuilderGitRepositoryJob fixPackBuilderGitRepositoryJob = new FixPackBuilderGitRepositoryJob(jobName, buildProfile, testSuiteName, branchName);
            _jobs.put(jobKey, fixPackBuilderGitRepositoryJob);
            return fixPackBuilderGitRepositoryJob;
        }
        if (jobName.startsWith("test-plugins-acceptance-pullrequest(")) {
            PluginsAcceptancePullRequestJob pluginsAcceptancePullRequestJob = new PluginsAcceptancePullRequestJob(jobName, buildProfile, branchName);
            _jobs.put(jobKey, pluginsAcceptancePullRequestJob);
            return pluginsAcceptancePullRequestJob;
        }
        if (jobName.equals("test-plugins-extraapps")) {
            PluginsExtraAppsJob pluginsExtraAppsJob = new PluginsExtraAppsJob(jobName, buildProfile, branchName);
            _jobs.put(jobKey, pluginsExtraAppsJob);
            return pluginsExtraAppsJob;
        }
        if (jobName.equals("test-plugins-marketplaceapp")) {
            PluginsMarketplaceAppJob pluginsMarketplaceAppJob = new PluginsMarketplaceAppJob(jobName, testSuiteName, buildProfile, branchName);
            _jobs.put(jobKey, pluginsMarketplaceAppJob);
            return pluginsMarketplaceAppJob;
        }
        if (jobName.equals("test-plugins-release")) {
            PluginsReleaseJob pluginsReleaseJob = new PluginsReleaseJob(jobName, testSuiteName, buildProfile, branchName);
            _jobs.put(jobKey, pluginsReleaseJob);
            return pluginsReleaseJob;
        }
        if (jobName.equals("test-plugins-upstream")) {
            PluginsUpstreamJob pluginsUpstreamJob = new PluginsUpstreamJob(jobName, testSuiteName, buildProfile, branchName);
            _jobs.put(jobKey, pluginsUpstreamJob);
            return pluginsUpstreamJob;
        }
        if (jobName.startsWith("test-portal-acceptance-pullrequest(") || jobName.equals("test-portal-source-format")) {
            PortalAcceptancePullRequestJob portalAcceptancePullRequestJob = new PortalAcceptancePullRequestJob(jobName, buildProfile, testSuiteName);
            if (JobFactory._isCentralMergePullRequest(portalAcceptancePullRequestJob.getGitWorkingDirectory())) {
                portalAcceptancePullRequestJob = new CentralMergePullRequestJob(jobName, buildProfile);
            }
            _jobs.put(jobKey, portalAcceptancePullRequestJob);
            return portalAcceptancePullRequestJob;
        }
        if (jobName.startsWith("test-portal-acceptance-upstream")) {
            _jobs.put(jobKey, new PortalAcceptanceUpstreamJob(jobName, buildProfile, testSuiteName));
            return _jobs.get(jobKey);
        }
        if (jobName.equals("test-portal-app-release")) {
            _jobs.put(jobKey, new PortalAppReleaseJob(jobName, buildProfile, branchName));
            return _jobs.get(jobKey);
        }
        if (jobName.startsWith("test-portal-aws(")) {
            _jobs.put(jobKey, new PortalAWSJob(jobName, buildProfile, branchName));
            return _jobs.get(jobKey);
        }
        if (jobName.startsWith("test-portal-environment(")) {
            _jobs.put(jobKey, new PortalEnvironmentJob(jobName, buildProfile, branchName));
            return _jobs.get(jobKey);
        }
        if (jobName.startsWith("test-portal-environment-release(")) {
            _jobs.put(jobKey, new PortalReleaseEnvironmentJob(jobName, buildProfile, branchName));
            return _jobs.get(jobKey);
        }
        if (jobName.startsWith("test-portal-fixpack-environment(")) {
            _jobs.put(jobKey, new PortalFixpackEnvironmentJob(jobName, buildProfile, branchName));
            return _jobs.get(jobKey);
        }
        if (jobName.equals("test-portal-fixpack-release")) {
            _jobs.put(jobKey, new PortalFixpackReleaseJob(jobName, buildProfile, branchName, testSuiteName));
            return _jobs.get(jobKey);
        }
        if (jobName.equals("test-portal-hotfix-release")) {
            _jobs.put(jobKey, new PortalHotfixReleaseJob(jobName, buildProfile, branchName, testSuiteName));
            return _jobs.get(jobKey);
        }
        if (jobName.equals("test-portal-release")) {
            _jobs.put(jobKey, new PortalReleaseJob(jobName, buildProfile, branchName, testSuiteName));
            return _jobs.get(jobKey);
        }
        if (jobName.startsWith("test-portal-testsuite-upstream(")) {
            _jobs.put(jobKey, new PortalTestSuiteUpstreamJob(jobName, buildProfile, testSuiteName));
            return _jobs.get(jobKey);
        }
        if (jobName.startsWith("test-portal-testsuite-upstream-controller(")) {
            _jobs.put(jobKey, new SimpleJob(jobName, buildProfile));
            return _jobs.get(jobKey);
        }
        if (jobName.startsWith("test-portal-upstream(")) {
            _jobs.put(jobKey, new PortalUpstreamJob(jobName, buildProfile));
            return _jobs.get(jobKey);
        }
        if (jobName.equals("test-qa-websites-functional-daily") || jobName.equals("test-qa-websites-functional-environment") || jobName.equals("test-qa-websites-functional-weekly")) {
            _jobs.put(jobKey, new QAWebsitesGitRepositoryJob(jobName, buildProfile, testSuiteName, branchName, projectNames));
            return _jobs.get(jobKey);
        }
        if (jobName.equals("test-results-consistency-report-controller")) {
            _jobs.put(jobKey, new SimpleJob(jobName, buildProfile));
            return _jobs.get(jobKey);
        }
        if (jobName.startsWith("test-subrepository-acceptance-pullrequest(")) {
            _jobs.put(jobKey, new SubrepositoryAcceptancePullRequestJob(jobName, buildProfile, testSuiteName, repositoryName));
            return _jobs.get(jobKey);
        }
        _jobs.put(jobKey, new DefaultPortalJob(jobName, buildProfile, testSuiteName));
        return _jobs.get(jobKey);
    }
}

