/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class JenkinsAPIUtil {
    public static JSONObject getAPIJSONObject(String jenkinsURL) {
        return JenkinsAPIUtil.getAPIJSONObject(jenkinsURL, null);
    }

    public static JSONObject getAPIJSONObject(String jenkinsURL, String tree) {
        if (jenkinsURL == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(JenkinsResultsParserUtil.getLocalURL(jenkinsURL));
        sb.append("/api/json");
        if (tree != null) {
            sb.append("?tree=");
            sb.append(tree);
        }
        try {
            return JenkinsResultsParserUtil.toJSONObject(sb.toString(), false);
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
            String errorMessage = "Unable to get Jenkins API JSON object from " + sb.toString();
            throw new RuntimeException(errorMessage, ioException);
        }
    }

    public static Map<String, String> getBuildParameters(JSONObject buildJSONObject) {
        HashMap<String, String> buildParameters = new HashMap<String, String>();
        JSONArray actionsJSONArray = buildJSONObject.getJSONArray("actions");
        for (int i = 0; i < actionsJSONArray.length(); ++i) {
            JSONObject actionJSONObject;
            Object actions = actionsJSONArray.get(i);
            if (actions == JSONObject.NULL || !(actionJSONObject = actionsJSONArray.getJSONObject(i)).has("parameters")) continue;
            JSONArray parametersJSONArray = actionJSONObject.getJSONArray("parameters");
            for (int j = 0; j < parametersJSONArray.length(); ++j) {
                JSONObject parameterJSONObject = parametersJSONArray.getJSONObject(j);
                buildParameters.put(parameterJSONObject.getString("name"), parameterJSONObject.getString("value"));
            }
        }
        return buildParameters;
    }

    public static JSONObject getLastCompletedBuildJSONObject(String jobURL, String tree) {
        StringBuffer sb = new StringBuffer();
        sb.append(JenkinsResultsParserUtil.getLocalURL(jobURL));
        sb.append("/lastCompletedBuild/api/json");
        if (tree != null) {
            sb.append("?tree=");
            sb.append(tree);
        }
        try {
            return JenkinsResultsParserUtil.toJSONObject(sb.toString(), false);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build JSON", ioException);
        }
    }

    public static int getLastCompletedBuildNumber(String jobURL) {
        JSONObject lastCompletedBuildJSONObject = JenkinsAPIUtil.getLastCompletedBuildJSONObject(jobURL, "number");
        return lastCompletedBuildJSONObject.getInt("number");
    }
}

