/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class GitRepositoryJob
extends BaseJob {
    protected File gitRepositoryDir;
    protected GitWorkingDirectory gitWorkingDirectory;
    private static final Pattern _jobNamePattern = Pattern.compile("[^\\(]+\\((?<branchName>[^\\)]+)\\)");
    private String _branchName;

    public String getBranchName() {
        if (this._branchName != null) {
            return this._branchName;
        }
        Matcher matcher = _jobNamePattern.matcher(this.getJobName());
        if (matcher.find()) {
            this._branchName = matcher.group("branchName");
            return this._branchName;
        }
        this._branchName = "master";
        return this._branchName;
    }

    public GitWorkingDirectory getGitWorkingDirectory() {
        if (this.gitWorkingDirectory != null) {
            return this.gitWorkingDirectory;
        }
        this.checkGitRepositoryDir();
        this.gitWorkingDirectory = GitWorkingDirectoryFactory.newGitWorkingDirectory(this.getBranchName(), JenkinsResultsParserUtil.getCanonicalPath(this.gitRepositoryDir));
        return this.gitWorkingDirectory;
    }

    public void setGitRepositoryDir(File gitRepositoryDir) {
        if (this.gitRepositoryDir != null) {
            throw new IllegalStateException("Repository directory is already set to " + this.gitRepositoryDir.getPath());
        }
        this.gitRepositoryDir = gitRepositoryDir;
    }

    protected GitRepositoryJob(String jobName, Job.BuildProfile buildProfile) {
        super(jobName, buildProfile);
    }

    protected void checkGitRepositoryDir() {
        if (this.gitRepositoryDir == null) {
            throw new IllegalStateException("Repository directory is not set");
        }
        if (!this.gitRepositoryDir.exists()) {
            throw new IllegalStateException(this.gitRepositoryDir.getPath() + " does not exist");
        }
    }
}

