/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseGitCommit;
import com.liferay.jenkins.results.parser.GitCommit;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class GitHubRemoteGitCommit
extends BaseGitCommit {
    protected List<String> modifiedFilenames;
    private final String _gitHubUsername;

    public String getGitHubCommitURL() {
        return JenkinsResultsParserUtil.combine("https://github.com/", this._gitHubUsername, "/", this.getGitRepositoryName(), "/commit/", this.getSHA());
    }

    public List<String> getModifiedFilenames() {
        if (this.modifiedFilenames == null) {
            this.init();
        }
        return this.modifiedFilenames;
    }

    public List<String> getStatusDescriptions() {
        try {
            JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(this.getGitHubStatusURL());
            JSONArray statusesJSONArray = jsonObject.getJSONArray("statuses");
            ArrayList<String> statusDescriptions = new ArrayList<String>(statusesJSONArray.length());
            for (int i = 0; i < statusesJSONArray.length(); ++i) {
                JSONObject statusJSONObject = statusesJSONArray.getJSONObject(i);
                statusDescriptions.add(statusJSONObject.optString("description"));
            }
            return statusDescriptions;
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get status data", ioException);
        }
    }

    public void setStatus(Status status, String context, String description, String targetURL) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("state", (Object)StringUtils.lowerCase((String)status.toString()));
        if (context != null) {
            jsonObject.put("context", (Object)context);
        }
        if (description != null) {
            jsonObject.put("description", (Object)description);
        }
        if (targetURL != null && targetURL.matches("https?\\:\\/\\/.*")) {
            jsonObject.put("target_url", (Object)targetURL);
        }
        try {
            JenkinsResultsParserUtil.toJSONObject(this.getGitHubStatusURL(), jsonObject.toString());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    protected GitHubRemoteGitCommit(String emailAddress, String gitHubUsername, String gitRepositoryName, String message, List<String> modifiedFilenames, String sha, GitCommit.Type type, long commitTime) {
        super(emailAddress, gitRepositoryName, message, sha, type, commitTime);
        this._gitHubUsername = gitHubUsername;
        this.modifiedFilenames = modifiedFilenames;
    }

    protected GitHubRemoteGitCommit(String gitHubUsername, String gitRepositoryName, String sha, GitCommit.Type type) {
        super(gitRepositoryName, sha, type);
        this._gitHubUsername = gitHubUsername;
    }

    protected String getGitHubStatusURL() {
        return JenkinsResultsParserUtil.getGitHubApiUrl(this.getGitRepositoryName(), this._gitHubUsername, "statuses/" + this.getSHA());
    }

    protected void init() {
        try {
            JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(this.getGitHubCommitURL(), false);
            JSONObject commitJSONObject = jsonObject.getJSONObject("commit");
            this.message = commitJSONObject.getString("message");
            JSONObject committerJSONObject = commitJSONObject.getJSONObject("committer");
            this.modifiedFilenames = Collections.emptyList();
            JSONArray filesJSONArray = jsonObject.getJSONArray("files");
            if (filesJSONArray != null) {
                this.modifiedFilenames = new ArrayList<String>(filesJSONArray.length());
                for (int i = 0; i < filesJSONArray.length(); ++i) {
                    JSONObject fileJSONObject = filesJSONArray.getJSONObject(i);
                    this.modifiedFilenames.add(fileJSONObject.getString("filename"));
                }
            }
            try {
                DateFormat gitHubDateFormat = JenkinsResultsParserUtil.getGitHubDateFormat();
                Date commitDate = gitHubDateFormat.parse(committerJSONObject.getString("date"));
                this.commitTime = commitDate.getTime();
            }
            catch (ParseException parseException) {
                throw new RuntimeException("Unable to parse committer date " + committerJSONObject.getString("date"), parseException);
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get GitHub API JSON for commit " + this.getSHA(), ioException);
        }
    }

    @Override
    protected void initCommitTime() {
        this.init();
    }

    @Override
    protected void initEmailAddress() {
        this.init();
    }

    @Override
    protected void initMessage() {
        this.init();
    }

    public static enum Status {
        ERROR,
        FAILURE,
        PENDING,
        SUCCESS;

    }
}

