/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitRepositoryJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.TestSuiteJob;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class FixPackBuilderGitRepositoryJob
extends GitRepositoryJob
implements TestSuiteJob {
    private final String _testSuiteName;
    private final String _upstreamBranchName;

    @Override
    public Set<String> getDistTypes() {
        return new HashSet<String>();
    }

    @Override
    public GitWorkingDirectory getGitWorkingDirectory() {
        return this.gitWorkingDirectory;
    }

    @Override
    public String getTestSuiteName() {
        return this._testSuiteName;
    }

    protected FixPackBuilderGitRepositoryJob(String jobName, Job.BuildProfile buildProfile, String testSuiteName, String upstreamBranchName) {
        super(jobName, buildProfile);
        this._testSuiteName = testSuiteName;
        this._upstreamBranchName = upstreamBranchName;
        this.gitWorkingDirectory = GitWorkingDirectoryFactory.newGitWorkingDirectory(this._upstreamBranchName, this._getFixPackBuilderGitRepositoryDir(), this._getFixPackBuilderRepositoryName());
        this.setGitRepositoryDir(this.gitWorkingDirectory.getWorkingDirectory());
        this.checkGitRepositoryDir();
        this.jobPropertiesFiles.add(new File(this.gitRepositoryDir, "test.properties"));
        this.readJobProperties();
    }

    @Override
    protected Set<String> getRawBatchNames() {
        return this.getSetFromString(JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.names"));
    }

    private File _getFixPackBuilderGitRepositoryDir() {
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        String fixPackBuilderDirPath = JenkinsResultsParserUtil.getProperty(buildProperties, "fix.pack.builder.dir", this.getBranchName());
        if (JenkinsResultsParserUtil.isNullOrEmpty(fixPackBuilderDirPath)) {
            throw new RuntimeException("Unable to find Fix Pack Builder directory path");
        }
        File fixPackBuilderDir = new File(fixPackBuilderDirPath);
        if (!fixPackBuilderDir.exists()) {
            throw new RuntimeException("Unable to find Fix Pack Builder directory");
        }
        return fixPackBuilderDir;
    }

    private String _getFixPackBuilderRepositoryName() {
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        String fixPackBuilderRepository = JenkinsResultsParserUtil.getProperty(buildProperties, "fix.pack.builder.repository", this.getBranchName());
        if (JenkinsResultsParserUtil.isNullOrEmpty(fixPackBuilderRepository)) {
            throw new RuntimeException("Unable to find Fix Pack Builder repository");
        }
        return fixPackBuilderRepository;
    }
}

