/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.TestSuiteJob;
import java.io.File;
import java.util.Properties;
import java.util.Set;

public class DefaultPortalJob
extends BaseJob
implements PortalTestClassJob,
TestSuiteJob {
    private PortalGitWorkingDirectory _portalGitWorkingDirectory;
    private final String _testSuiteName;

    @Override
    public Set<String> getDistTypes() {
        String testBatchDistAppServers = JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.dist.app.servers");
        return this.getSetFromString(testBatchDistAppServers);
    }

    @Override
    public PortalGitWorkingDirectory getPortalGitWorkingDirectory() {
        GitWorkingDirectory gitWorkingDirectory;
        if (this._portalGitWorkingDirectory != null) {
            return this._portalGitWorkingDirectory;
        }
        File portalRepositoryDir = new File(".");
        File portalTestPropertiesFile = new File(portalRepositoryDir, "test.properties");
        Properties portalTestProperties = JenkinsResultsParserUtil.getProperties(portalTestPropertiesFile);
        String portalUpstreamBranchName = portalTestProperties.getProperty("liferay.portal.branch", "master");
        String portalRepositoryName = "liferay-portal";
        if (!portalUpstreamBranchName.equals("master")) {
            portalRepositoryName = portalRepositoryName + "-ee";
        }
        if (!((gitWorkingDirectory = GitWorkingDirectoryFactory.newGitWorkingDirectory(portalUpstreamBranchName, portalRepositoryDir, portalRepositoryName)) instanceof PortalGitWorkingDirectory)) {
            throw new RuntimeException("Invalid portal Git working directory");
        }
        this._portalGitWorkingDirectory = (PortalGitWorkingDirectory)gitWorkingDirectory;
        return this._portalGitWorkingDirectory;
    }

    @Override
    public String getTestSuiteName() {
        return this._testSuiteName;
    }

    protected DefaultPortalJob(String jobName, Job.BuildProfile buildProfile, String testSuiteName) {
        super(jobName, buildProfile);
        this._testSuiteName = testSuiteName;
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        File portalWorkingDirectory = portalGitWorkingDirectory.getWorkingDirectory();
        this.jobPropertiesFiles.add(new File(portalWorkingDirectory, "build.properties"));
        this.jobPropertiesFiles.add(new File(portalWorkingDirectory, "test.properties"));
        this.readJobProperties();
    }

    @Override
    protected Set<String> getRawBatchNames() {
        return this.getSetFromString(JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.names"));
    }
}

