/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.CucumberFeatureResult;
import com.liferay.jenkins.results.parser.CucumberScenarioResult;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class CucumberFeatureFile
implements Serializable {
    private static final Pattern _gitGrepResultsPattern = Pattern.compile("(.+\\.feature)\\:.*");
    private static final Pattern _relativePathPattern = Pattern.compile(".*/features/(.*)/[^/]+");
    private final CucumberFeatureResult _cucumberFeatureResult;
    private final CucumberScenarioResult _cucumberScenarioResult;
    private final File _faroDir;
    private final Map<String, Set<String>> _featurePathsMap = new HashMap<String, Set<String>>();

    public CucumberFeatureFile(File faroDir, CucumberFeatureResult cucumberFeatureResult, CucumberScenarioResult cucumberScenarioResult) {
        this._faroDir = faroDir;
        this._cucumberFeatureResult = cucumberFeatureResult;
        this._cucumberScenarioResult = cucumberScenarioResult;
    }

    public String getCategoryName() {
        Matcher matcher = _relativePathPattern.matcher(this.getRelativePath());
        if (!matcher.matches()) {
            return "";
        }
        String folderNames = matcher.group(1);
        folderNames = folderNames.replaceAll("\\.", " ");
        folderNames = StringUtils.capitalize((String)folderNames);
        folderNames = folderNames.replaceAll("\\s*(.+?)[/\\s]*", "$1");
        return folderNames;
    }

    public File getFile() {
        return new File(this._faroDir, this.getRelativePath());
    }

    public String getRelativePath() {
        for (String featurePath : this._getFeaturePathsFromFeatureName()) {
            Set<String> featurePaths = this._getFeaturePathsFromScenarioName();
            if (!featurePaths.contains(featurePath)) continue;
            return featurePath;
        }
        throw new RuntimeException("Unable to find a matching file");
    }

    private Set<String> _getFeaturePaths(String name) {
        Set<String> featurePaths = this._featurePathsMap.get(name);
        if (featurePaths != null) {
            return featurePaths;
        }
        featurePaths = new HashSet<String>();
        try {
            Process process = JenkinsResultsParserUtil.executeBashCommands(false, this._faroDir, 10000L, JenkinsResultsParserUtil.combine("git grep \"", name.replaceAll("\"", "\\\\\""), "$\""));
            try {
                String gitGrepResults = JenkinsResultsParserUtil.readInputStream(process.getInputStream());
                for (String gitGrepResult : gitGrepResults.split("\n")) {
                    Matcher matcher = _gitGrepResultsPattern.matcher(gitGrepResult);
                    if (!matcher.find()) continue;
                    featurePaths.add(matcher.group(1));
                }
            }
            catch (IOException ioException) {
                throw new RuntimeException("Unable to read process input stream", ioException);
            }
        }
        catch (IOException | TimeoutException exception) {
            throw new RuntimeException(exception);
        }
        this._featurePathsMap.put(name, featurePaths);
        return this._featurePathsMap.get(name);
    }

    private Set<String> _getFeaturePathsFromFeatureName() {
        String featureName = this._cucumberFeatureResult.getName();
        return this._getFeaturePaths(featureName.trim());
    }

    private Set<String> _getFeaturePathsFromScenarioName() {
        String scenarioName = this._cucumberScenarioResult.getScenarioName();
        return this._getFeaturePaths(scenarioName.trim());
    }
}

