/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsCohort;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.ParallelExecutor;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import com.liferay.jenkins.results.parser.testray.TestrayRoutine;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class CISystemStatusReportUtil {
    private static final int _DAYS_PER_WEEK = 7;
    private static final Pattern _dateTimePattern = Pattern.compile(".*(?<date>\\d{4}-\\d{2}-\\d{2}\\[\\d{2}:\\d{2}:\\d{2}\\]).*");
    private static final ExecutorService _executorService = JenkinsResultsParserUtil.getNewThreadPoolExecutor(25, true);
    private static final HashMap<LocalDate, List<TestrayBuild>> _recentTestrayBuilds;
    private static final SimpleDateFormat _simpleDateFormat;

    public static void writeJenkinsDataJavaScriptFile(String filePath) throws IOException {
        JenkinsCohort jenkinsCohort = new JenkinsCohort(JenkinsResultsParserUtil.getBuildProperty("ci.system.status.report.jenkins.cohort"));
        jenkinsCohort.writeDataJavaScriptFile(filePath);
    }

    public static void writeTestrayDataJavaScriptFile(String filePath, TestrayRoutine testrayRoutine, String nameFilter) throws IOException {
        ArrayList callables = new ArrayList();
        for (LocalDate localDate : _recentTestrayBuilds.keySet()) {
            List<TestrayBuild> builds = testrayRoutine.getTestrayBuilds(200, localDate.toString(), nameFilter);
            _recentTestrayBuilds.put(localDate, builds);
            for (final TestrayBuild testrayBuild : builds) {
                callables.add(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return testrayBuild.getResult();
                    }
                });
            }
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, _executorService);
        parallelExecutor.execute();
        StringBuilder sb = new StringBuilder();
        sb.append("var relevantSuiteBuildData = ");
        sb.append(CISystemStatusReportUtil._getRelevantSuiteBuildDataJSONObject());
        sb.append("\nvar topLevelTotalBuildDurationData = ");
        sb.append(CISystemStatusReportUtil._getTopLevelTotalBuildDurationJSONObject());
        sb.append("\nvar topLevelActiveBuildDurationData = ");
        sb.append(CISystemStatusReportUtil._getTopLevelActiveBuildDurationJSONObject());
        sb.append("\nvar downstreamBuildDurationData = ");
        sb.append(CISystemStatusReportUtil._getDownstreamBuildDurationJSONObject());
        sb.append("\nvar testrayDataGeneratedDate = new Date(");
        sb.append(JenkinsResultsParserUtil.getCurrentTimeMillis());
        sb.append(");");
        sb.append("\nvar successRateData = ");
        sb.append(CISystemStatusReportUtil._getSuccessRateDataJSONArray());
        sb.append(";");
        JenkinsResultsParserUtil.write(filePath, sb.toString());
    }

    protected static String getPercentage(Integer dividend, Integer divisor) {
        double quotient = 0.0;
        if (divisor != 0) {
            quotient = (double)dividend.intValue() / (double)divisor.intValue();
        }
        DecimalFormat decimalFormat = new DecimalFormat("###.##%");
        return decimalFormat.format(quotient);
    }

    private static JSONObject _getDownstreamBuildDurationJSONObject() {
        JSONObject datesDurationsJSONObject = new JSONObject();
        JSONArray datesJSONArray = new JSONArray();
        JSONArray durationsJSONArray = new JSONArray();
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>(_recentTestrayBuilds.keySet());
        Collections.sort(dates);
        for (LocalDate date : dates) {
            ArrayList<Long> durations = new ArrayList<Long>();
            for (TestrayBuild testrayBuild : _recentTestrayBuilds.get(date)) {
                List<Long> downstreamDurations = testrayBuild.getDownstreamBuildDurations();
                if (downstreamDurations == null) continue;
                for (Long downstreamDuration : downstreamDurations) {
                    if (downstreamDuration == null || downstreamDuration < 0L) continue;
                    durations.add(downstreamDuration);
                }
            }
            durations.removeAll(Collections.singleton(null));
            if (durations.isEmpty()) {
                datesJSONArray.put((Object)date.toString());
            } else {
                String meanDuration = JenkinsResultsParserUtil.combine("mean: ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getAverage(durations)));
                datesJSONArray.put((Object)new String[]{date.toString(), meanDuration});
            }
            Collections.sort(durations);
            durationsJSONArray.put(durations);
        }
        datesDurationsJSONObject.put("dates", (Object)datesJSONArray);
        datesDurationsJSONObject.put("durations", (Object)durationsJSONArray);
        return datesDurationsJSONObject;
    }

    private static JSONObject _getRelevantSuiteBuildDataJSONObject() {
        JSONObject relevantSuiteBuildDataJSONObject = new JSONObject();
        JSONArray datesJSONArray = new JSONArray();
        JSONArray failedBuildsJSONArray = new JSONArray();
        JSONArray passedBuildsJSONArray = new JSONArray();
        JSONArray unstableBuildsJSONArray = new JSONArray();
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>(_recentTestrayBuilds.keySet());
        Collections.sort(dates);
        for (LocalDate date : dates) {
            int failedBuilds = 0;
            int passedBuilds = 0;
            int unstableBuilds = 0;
            for (TestrayBuild testrayBuild : _recentTestrayBuilds.get(date)) {
                String result = testrayBuild.getResult();
                if (result.equals("FAILURE")) {
                    ++failedBuilds;
                    continue;
                }
                if (result.equals("SUCCESS")) {
                    ++passedBuilds;
                    continue;
                }
                if (!result.equals("APPROVED")) continue;
                ++unstableBuilds;
            }
            datesJSONArray.put((Object)date.toString());
            passedBuildsJSONArray.put(passedBuilds);
            failedBuildsJSONArray.put(failedBuilds);
            unstableBuildsJSONArray.put(unstableBuilds);
        }
        relevantSuiteBuildDataJSONObject.put("dates", (Object)datesJSONArray);
        relevantSuiteBuildDataJSONObject.put("failed", (Object)failedBuildsJSONArray);
        relevantSuiteBuildDataJSONObject.put("succeeded", (Object)passedBuildsJSONArray);
        relevantSuiteBuildDataJSONObject.put("unstable", (Object)unstableBuildsJSONArray);
        return relevantSuiteBuildDataJSONObject;
    }

    private static JSONArray _getSuccessRateDataJSONArray() {
        JSONArray successRateDataJSONArray = new JSONArray();
        JSONArray titlesJSONArray = new JSONArray();
        titlesJSONArray.put((Object)"Time Period");
        titlesJSONArray.put((Object)"Adjusted Success Rate");
        titlesJSONArray.put((Object)"Success Rate");
        titlesJSONArray.put((Object)"Builds Run");
        successRateDataJSONArray.put((Object)titlesJSONArray);
        LocalDateTime currentLocalDateTime = LocalDateTime.now(ZoneOffset.UTC);
        successRateDataJSONArray.put((Object)CISystemStatusReportUtil._getSuccessRateJSONArray("Last 24 Hours", currentLocalDateTime.minusDays(1L), currentLocalDateTime));
        successRateDataJSONArray.put((Object)CISystemStatusReportUtil._getSuccessRateJSONArray("Last 7 Days", currentLocalDateTime.minusDays(7L), currentLocalDateTime));
        successRateDataJSONArray.put((Object)CISystemStatusReportUtil._getSuccessRateJSONArray("Previous 7 Days", currentLocalDateTime.minusDays(14L), currentLocalDateTime.minusDays(7L)));
        return successRateDataJSONArray;
    }

    private static JSONArray _getSuccessRateJSONArray(String title, LocalDateTime startLocalDateTime, LocalDateTime endLocalDateTime) {
        if (startLocalDateTime.compareTo(endLocalDateTime) >= 0) {
            throw new IllegalArgumentException("Start time must preceed end time");
        }
        HashSet<LocalDate> localDates = new HashSet<LocalDate>();
        int i = 0;
        while (startLocalDateTime.compareTo(endLocalDateTime.minusDays(i)) <= 0) {
            LocalDateTime localDateTime = endLocalDateTime.minusDays(i);
            localDates.add(localDateTime.toLocalDate());
            ++i;
        }
        int failedBuilds = 0;
        int passedBuilds = 0;
        int unstableBuilds = 0;
        for (LocalDate localDate : localDates) {
            for (TestrayBuild testrayBuild : _recentTestrayBuilds.get(localDate)) {
                Date date;
                String testrayBuildName = testrayBuild.getName();
                Matcher matcher = _dateTimePattern.matcher(testrayBuildName);
                if (!matcher.find()) continue;
                try {
                    date = _simpleDateFormat.parse(matcher.group("date"));
                }
                catch (ParseException parseException) {
                    throw new RuntimeException(parseException);
                }
                Instant instant = Instant.ofEpochMilli(date.getTime());
                ZonedDateTime zonedDateTime = instant.atZone(ZoneId.systemDefault());
                LocalDateTime localDateTime = zonedDateTime.toLocalDateTime();
                if (startLocalDateTime.compareTo(localDateTime) >= 0 || endLocalDateTime.compareTo(localDateTime) <= 0) continue;
                String testrayBuildResult = testrayBuild.getResult();
                if (testrayBuildResult.equals("FAILURE")) {
                    ++failedBuilds;
                    continue;
                }
                if (testrayBuildResult.equals("SUCCESS")) {
                    ++passedBuilds;
                    continue;
                }
                if (!testrayBuildResult.equals("APPROVED")) continue;
                ++unstableBuilds;
            }
        }
        int totalBuilds = failedBuilds + passedBuilds + unstableBuilds;
        JSONArray successRateJSONArray = new JSONArray();
        successRateJSONArray.put((Object)title);
        successRateJSONArray.put((Object)CISystemStatusReportUtil.getPercentage(passedBuilds + unstableBuilds, totalBuilds));
        successRateJSONArray.put((Object)CISystemStatusReportUtil.getPercentage(passedBuilds, totalBuilds));
        successRateJSONArray.put(totalBuilds);
        return successRateJSONArray;
    }

    private static JSONObject _getTopLevelActiveBuildDurationJSONObject() {
        JSONObject jsonObject = new JSONObject();
        JSONArray datesJSONArray = new JSONArray();
        JSONArray durationsJSONArray = new JSONArray();
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>(_recentTestrayBuilds.keySet());
        Collections.sort(dates);
        for (LocalDate date : dates) {
            ArrayList<Long> durations = new ArrayList<Long>();
            for (TestrayBuild testrayBuild : _recentTestrayBuilds.get(date)) {
                Long duration = testrayBuild.getTopLevelActiveBuildDuration();
                if (duration == null || duration < 0L) continue;
                durations.add(duration);
            }
            durations.removeAll(Collections.singleton(null));
            if (durations.isEmpty()) {
                datesJSONArray.put((Object)date.toString());
            } else {
                String meanDuration = JenkinsResultsParserUtil.combine("mean: ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getAverage(durations)));
                datesJSONArray.put((Object)new String[]{date.toString(), meanDuration});
            }
            Collections.sort(durations);
            durationsJSONArray.put(durations);
        }
        jsonObject.put("dates", (Object)datesJSONArray);
        jsonObject.put("durations", (Object)durationsJSONArray);
        return jsonObject;
    }

    private static JSONObject _getTopLevelTotalBuildDurationJSONObject() {
        JSONObject jsonObject = new JSONObject();
        JSONArray datesJSONArray = new JSONArray();
        JSONArray durationsJSONArray = new JSONArray();
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>(_recentTestrayBuilds.keySet());
        Collections.sort(dates);
        for (LocalDate date : dates) {
            ArrayList<Long> durations = new ArrayList<Long>();
            for (TestrayBuild testrayBuild : _recentTestrayBuilds.get(date)) {
                Long duration = testrayBuild.getTopLevelBuildDuration();
                if (duration == null || duration < 0L) continue;
                durations.add(duration);
            }
            durations.removeAll(Collections.singleton(null));
            if (durations.isEmpty()) {
                datesJSONArray.put((Object)date.toString());
            } else {
                String meanDuration = JenkinsResultsParserUtil.combine("mean: ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getAverage(durations)));
                datesJSONArray.put((Object)new String[]{date.toString(), meanDuration});
            }
            Collections.sort(durations);
            durationsJSONArray.put(durations);
        }
        jsonObject.put("dates", (Object)datesJSONArray);
        jsonObject.put("durations", (Object)durationsJSONArray);
        return jsonObject;
    }

    static {
        _simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd[HH:mm:ss]");
        _recentTestrayBuilds = new HashMap<LocalDate, List<TestrayBuild>>(){
            {
                LocalDate localDate = LocalDate.now(ZoneOffset.UTC);
                for (int i = 0; i <= 14; ++i) {
                    this.put(localDate.minusDays(i), new ArrayList());
                }
            }
        };
    }
}

