/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.ParallelExecutor;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import com.liferay.jenkins.results.parser.testray.TestrayRoutine;
import java.io.IOException;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.json.JSONArray;
import org.json.JSONObject;

public class CISystemHistoryReportUtil {
    private static final int _MONTHS_PER_YEAR = 12;
    private static final ExecutorService _executorService = JenkinsResultsParserUtil.getNewThreadPoolExecutor(25, true);
    private static final HashMap<String, List<TestrayBuild>> _recentTestrayBuilds = new HashMap<String, List<TestrayBuild>>(){
        {
            LocalDate currentLocalDate = LocalDate.now();
            for (int i = 0; i < 12; ++i) {
                LocalDate localDate = currentLocalDate.minusMonths(i);
                this.put(localDate.format(DateTimeFormatter.ofPattern("yyyy-MM")), new ArrayList());
            }
        }
    };

    public static void writeTestrayDataJavaScriptFile(String filePath, TestrayRoutine testrayRoutine, String nameFilter) throws IOException {
        ArrayList callables = new ArrayList();
        for (String month : _recentTestrayBuilds.keySet()) {
            List<TestrayBuild> builds = testrayRoutine.getTestrayBuilds(2500, month, nameFilter);
            _recentTestrayBuilds.put(month, builds);
            for (final TestrayBuild testrayBuild : builds) {
                callables.add(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return testrayBuild.getResult();
                    }
                });
            }
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, _executorService);
        parallelExecutor.execute();
        StringBuilder sb = new StringBuilder();
        sb.append("var topLevelTotalBuildDurationData = ");
        sb.append(CISystemHistoryReportUtil._getTopLevelTotalBuildDurationJSONObject());
        sb.append("\nvar topLevelActiveBuildDurationData = ");
        sb.append(CISystemHistoryReportUtil._getTopLevelActiveBuildDurationJSONObject());
        sb.append("\nvar downstreamBuildDurationData = ");
        sb.append(CISystemHistoryReportUtil._getDownstreamBuildDurationJSONObject());
        sb.append("\nvar testrayDataGeneratedDate = new Date(");
        sb.append(JenkinsResultsParserUtil.getCurrentTimeMillis());
        sb.append(");");
        JenkinsResultsParserUtil.write(filePath, sb.toString());
    }

    private static JSONObject _getDownstreamBuildDurationJSONObject() {
        JSONObject datesDurationsJSONObject = new JSONObject();
        JSONArray datesJSONArray = new JSONArray();
        JSONArray durationsJSONArray = new JSONArray();
        ArrayList<String> months = new ArrayList<String>(_recentTestrayBuilds.keySet());
        Collections.sort(months);
        for (String month : months) {
            ArrayList<Long> durations = new ArrayList<Long>();
            for (TestrayBuild testrayBuild : _recentTestrayBuilds.get(month)) {
                List<Long> downstreamDurations = testrayBuild.getDownstreamBuildDurations();
                if (downstreamDurations == null) continue;
                for (Long downstreamDuration : downstreamDurations) {
                    if (downstreamDuration == null || downstreamDuration < 0L) continue;
                    durations.add(downstreamDuration);
                }
            }
            if (durations.isEmpty()) {
                datesJSONArray.put((Object)month);
            } else {
                String meanDuration = JenkinsResultsParserUtil.combine("mean: ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getAverage(durations)));
                NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
                String total = JenkinsResultsParserUtil.combine("total: ", numberFormat.format(durations.size()));
                datesJSONArray.put((Object)new String[]{month, meanDuration, total});
            }
            Collections.sort(durations);
            durationsJSONArray.put(durations);
        }
        datesDurationsJSONObject.put("dates", (Object)datesJSONArray);
        datesDurationsJSONObject.put("durations", (Object)durationsJSONArray);
        return datesDurationsJSONObject;
    }

    private static JSONObject _getTopLevelActiveBuildDurationJSONObject() {
        JSONObject jsonObject = new JSONObject();
        JSONArray datesJSONArray = new JSONArray();
        JSONArray durationsJSONArray = new JSONArray();
        ArrayList<String> months = new ArrayList<String>(_recentTestrayBuilds.keySet());
        Collections.sort(months);
        for (String month : months) {
            ArrayList<Long> durations = new ArrayList<Long>();
            for (TestrayBuild testrayBuild : _recentTestrayBuilds.get(month)) {
                Long duration = testrayBuild.getTopLevelActiveBuildDuration();
                if (duration == null || duration < 0L) continue;
                durations.add(duration);
            }
            if (durations.isEmpty()) {
                datesJSONArray.put((Object)month);
            } else {
                String meanDuration = JenkinsResultsParserUtil.combine("mean: ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getAverage(durations)));
                NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
                String total = JenkinsResultsParserUtil.combine("total: ", numberFormat.format(durations.size()));
                datesJSONArray.put((Object)new String[]{month, meanDuration, total});
            }
            Collections.sort(durations);
            durationsJSONArray.put(durations);
        }
        jsonObject.put("dates", (Object)datesJSONArray);
        jsonObject.put("durations", (Object)durationsJSONArray);
        return jsonObject;
    }

    private static JSONObject _getTopLevelTotalBuildDurationJSONObject() {
        JSONObject jsonObject = new JSONObject();
        JSONArray datesJSONArray = new JSONArray();
        JSONArray durationsJSONArray = new JSONArray();
        ArrayList<String> months = new ArrayList<String>(_recentTestrayBuilds.keySet());
        Collections.sort(months);
        for (String month : months) {
            ArrayList<Long> durations = new ArrayList<Long>();
            for (TestrayBuild testrayBuild : _recentTestrayBuilds.get(month)) {
                Long duration = testrayBuild.getTopLevelBuildDuration();
                if (duration == null || duration < 0L) continue;
                durations.add(duration);
            }
            if (durations.isEmpty()) {
                datesJSONArray.put((Object)month);
            } else {
                String meanDuration = JenkinsResultsParserUtil.combine("mean: ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getAverage(durations)));
                NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
                String total = JenkinsResultsParserUtil.combine("total: ", numberFormat.format(durations.size()));
                datesJSONArray.put((Object)new String[]{month, meanDuration, total});
            }
            Collections.sort(durations);
            durationsJSONArray.put(durations);
        }
        jsonObject.put("dates", (Object)datesJSONArray);
        jsonObject.put("durations", (Object)durationsJSONArray);
        return jsonObject;
    }
}

