/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuildData;
import com.liferay.jenkins.results.parser.BaseBuildRunner;
import com.liferay.jenkins.results.parser.BuildData;
import com.liferay.jenkins.results.parser.BuildRunner;
import com.liferay.jenkins.results.parser.DefaultPortalBatchBuildRunner;
import com.liferay.jenkins.results.parser.MethodLogger;
import com.liferay.jenkins.results.parser.PortalBatchBuildData;
import com.liferay.jenkins.results.parser.PortalTestSuiteUpstreamControllerBuildData;
import com.liferay.jenkins.results.parser.PortalTestSuiteUpstreamControllerBuildRunner;
import com.liferay.jenkins.results.parser.PortalTestSuiteUpstreamControllerSingleSuiteBuildRunner;
import com.liferay.jenkins.results.parser.PortalTopLevelBuildData;
import com.liferay.jenkins.results.parser.RootCauseAnalysisBatchBuildRunner;
import com.liferay.jenkins.results.parser.RootCauseAnalysisToolTopLevelBuildRunner;
import com.liferay.jenkins.results.parser.TestResultsConsistencyReportControllerBuildRunner;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BuildRunnerFactory {
    private static final Pattern _jobNamePattern = Pattern.compile("[^\\(]+\\((?<upstreamBranchName>[^_]+)(_(?<testSuiteName>[^\\)]+))?\\)");

    public static BuildRunner<?, ?> newBuildRunner(BuildData buildData) {
        String jobName = buildData.getJobName();
        BaseBuildRunner buildRunner = null;
        if (jobName.equals("root-cause-analysis-tool")) {
            buildRunner = new RootCauseAnalysisToolTopLevelBuildRunner((PortalTopLevelBuildData)buildData);
        } else if (jobName.equals("root-cause-analysis-tool-batch")) {
            buildRunner = new RootCauseAnalysisBatchBuildRunner((PortalBatchBuildData)buildData);
        } else if (jobName.contains("-batch")) {
            buildRunner = new DefaultPortalBatchBuildRunner((PortalBatchBuildData)buildData);
        }
        if (jobName.startsWith("test-portal-testsuite-upstream-controller(")) {
            Matcher matcher = _jobNamePattern.matcher(jobName);
            buildRunner = matcher.find() && matcher.group("testSuiteName") != null ? new PortalTestSuiteUpstreamControllerSingleSuiteBuildRunner<PortalTestSuiteUpstreamControllerBuildData>((PortalTestSuiteUpstreamControllerBuildData)buildData) : new PortalTestSuiteUpstreamControllerBuildRunner<PortalTestSuiteUpstreamControllerBuildData>((PortalTestSuiteUpstreamControllerBuildData)buildData);
        }
        if (jobName.startsWith("test-results-consistency-report-controller")) {
            buildRunner = new TestResultsConsistencyReportControllerBuildRunner<BaseBuildData>((BaseBuildData)buildData);
        }
        if (buildRunner == null) {
            throw new RuntimeException("Invalid build data " + buildData);
        }
        return (BuildRunner)Proxy.newProxyInstance(BuildRunner.class.getClassLoader(), new Class[]{BuildRunner.class}, (InvocationHandler)new MethodLogger(buildRunner));
    }
}

