/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BuildData;
import com.liferay.jenkins.results.parser.BuildDataFactory;
import com.liferay.jenkins.results.parser.BuildRunner;
import com.liferay.jenkins.results.parser.BuildRunnerFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalBuildData;
import com.liferay.jenkins.results.parser.PortalTopLevelBuildData;
import com.liferay.jenkins.results.parser.TopLevelBuildData;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BuildLauncher {
    private static final String _COMMAND_RUN = "run";
    private static final String _COMMAND_TEARDOWN = "teardown";
    private static final Pattern _buildOptionPattern = Pattern.compile("-D(?<name>[^=\\s]+)=(?<value>.+)");

    public static void main(String[] args) {
        String buildCommand = BuildLauncher._getBuildCommand(args);
        System.out.println("##");
        System.out.println("## " + buildCommand);
        System.out.println("##");
        BuildRunner<?, ?> buildRunner = BuildRunnerFactory.newBuildRunner(BuildLauncher._getBuildData(args));
        if (buildCommand.equals(_COMMAND_RUN)) {
            buildRunner.run();
        } else if (buildCommand.equals(_COMMAND_TEARDOWN)) {
            buildRunner.tearDown();
        }
    }

    private static String _getBuildCommand(String[] args) {
        String buildCommand = null;
        for (String arg : args) {
            if (!arg.equals(_COMMAND_RUN) && !arg.equals(_COMMAND_TEARDOWN)) continue;
            if (buildCommand != null) {
                throw new RuntimeException("Too many build commands");
            }
            buildCommand = arg;
        }
        if (buildCommand == null) {
            throw new RuntimeException("No available build command");
        }
        return buildCommand;
    }

    private static BuildData _getBuildData(String[] args) {
        String workspace;
        HashMap<String, String> buildProperties = new HashMap<String, String>();
        buildProperties.putAll(BuildLauncher._getEnvironmentVariables());
        buildProperties.putAll(BuildLauncher._getJenkinsBuildParameters(buildProperties));
        buildProperties.putAll(BuildLauncher._getBuildOptions(args));
        BuildData buildData = BuildDataFactory.newBuildData((String)buildProperties.get("RUN_ID"), (String)buildProperties.get("JOB_NAME"), (String)buildProperties.get("BUILD_URL"));
        String jenkinsGitHubURL = (String)buildProperties.get("JENKINS_GITHUB_URL");
        if (jenkinsGitHubURL != null && !jenkinsGitHubURL.isEmpty()) {
            buildData.setJenkinsGitHubURL(jenkinsGitHubURL);
        }
        if ((workspace = (String)buildProperties.get("WORKSPACE")) != null && !workspace.isEmpty()) {
            buildData.setWorkspaceDir(new File(workspace));
        }
        if (buildData instanceof PortalBuildData) {
            TopLevelBuildData topLevelBuildData;
            String portalUpstreamBranchName;
            PortalBuildData portalBuildData = (PortalBuildData)buildData;
            String portalGitHubURL = (String)buildProperties.get("PORTAL_GITHUB_URL");
            if (portalGitHubURL != null && !portalGitHubURL.isEmpty()) {
                portalBuildData.setPortalGitHubURL(portalGitHubURL);
            }
            if (JenkinsResultsParserUtil.isNullOrEmpty(portalUpstreamBranchName = (String)buildProperties.get("PORTAL_UPSTREAM_BRANCH_NAME")) && (topLevelBuildData = portalBuildData.getTopLevelBuildData()) instanceof PortalTopLevelBuildData) {
                PortalTopLevelBuildData portalTopLevelBuildData = (PortalTopLevelBuildData)topLevelBuildData;
                portalUpstreamBranchName = portalTopLevelBuildData.getPortalUpstreamBranchName();
            }
            if (portalUpstreamBranchName != null && !portalUpstreamBranchName.isEmpty()) {
                portalBuildData.setPortalUpstreamBranchName(portalUpstreamBranchName);
            }
        }
        return buildData;
    }

    private static Map<String, String> _getBuildOptions(String[] args) {
        HashMap<String, String> buildOptions = new HashMap<String, String>();
        for (String arg : args) {
            Matcher matcher = _buildOptionPattern.matcher(arg);
            if (!matcher.find()) continue;
            buildOptions.put(matcher.group("name"), matcher.group("value"));
        }
        return buildOptions;
    }

    private static Map<String, String> _getEnvironmentVariables() {
        HashMap<String, String> environmentVariables = new HashMap<String, String>();
        environmentVariables.put("BUILD_URL", System.getenv("BUILD_URL"));
        environmentVariables.put("JOB_NAME", System.getenv("JOB_NAME"));
        environmentVariables.put("PORTAL_GITHUB_URL", System.getenv("PORTAL_GITHUB_URL"));
        environmentVariables.put("PORTAL_UPSTREAM_BRANCH_NAME", System.getenv("PORTAL_UPSTREAM_BRANCH_NAME"));
        environmentVariables.put("RUN_ID", System.getenv("RUN_ID"));
        String workspace = System.getenv("WORKSPACE");
        if (workspace != null) {
            environmentVariables.put("WORKSPACE", workspace);
        }
        return environmentVariables;
    }

    private static Map<String, String> _getJenkinsBuildParameters(Map<String, String> buildProperties) {
        String buildURL = buildProperties.get("BUILD_URL");
        if (buildURL == null) {
            return new HashMap<String, String>();
        }
        return JenkinsResultsParserUtil.getBuildParameters(buildURL);
    }
}

