/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AxisBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.BuildDatabase;
import com.liferay.jenkins.results.parser.DefaultBuildDatabase;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public class BuildDatabaseUtil {
    private static final Map<String, BuildDatabase> _buildDatabases = new HashMap<String, BuildDatabase>();

    public static BuildDatabase getBuildDatabase() {
        return BuildDatabaseUtil._getBuildDatabase(null, null, true);
    }

    public static BuildDatabase getBuildDatabase(Build build) {
        return BuildDatabaseUtil._getBuildDatabase(BuildDatabaseUtil._getDistPath(build), build, true);
    }

    public static BuildDatabase getBuildDatabase(String baseDirPath, boolean download) {
        return BuildDatabaseUtil._getBuildDatabase(baseDirPath, null, download);
    }

    private static void _downloadBuildDatabaseFile(File baseDir, Build build) {
        if (JenkinsResultsParserUtil.isCINode()) {
            String filePath = JenkinsResultsParserUtil.combine("/opt/java/jenkins/userContent/jobs/", build.getJobName(), "/builds/", String.valueOf(build.getBuildNumber()));
            try {
                JenkinsMaster jenkinsMaster = build.getJenkinsMaster();
                BuildDatabaseUtil._downloadBuildDatabaseFile(baseDir, jenkinsMaster.getName(), filePath);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            String buildDatabaseURL = JenkinsResultsParserUtil.getBuildArtifactURL(build.getBuildURL(), "build-database.json");
            JenkinsResultsParserUtil.write(JenkinsResultsParserUtil.combine(String.valueOf(baseDir), "/", "build-database.json"), JenkinsResultsParserUtil.toString(buildDatabaseURL));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private static void _downloadBuildDatabaseFile(File baseDir, String distNodes, String distPath) {
        File buildDatabaseFile = new File(baseDir, "build-database.json");
        if (!JenkinsResultsParserUtil.isCINode()) {
            try {
                JenkinsResultsParserUtil.write(buildDatabaseFile, "{}");
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            return;
        }
        int maxRetries = 5;
        int retries = 0;
        while (retries < maxRetries) {
            try {
                ++retries;
                String distNode = JenkinsResultsParserUtil.getRandomString(Arrays.asList(distNodes.split(",")));
                String command = JenkinsResultsParserUtil.combine("time rsync -Iqs --timeout=1200 ", distNode, ":", distPath, "/", "build-database.json", " ", JenkinsResultsParserUtil.getCanonicalPath(buildDatabaseFile));
                command = command.replaceAll("\\(", "\\\\(");
                command = command.replaceAll("\\)", "\\\\)");
                Process process = JenkinsResultsParserUtil.executeBashCommands(true, new File("."), 600000L, command);
                if (process.exitValue() != 0) {
                    throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to download ", "build-database.json"));
                }
                break;
            }
            catch (IOException | RuntimeException | TimeoutException exception) {
                if (retries == maxRetries) {
                    throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to get ", "build-database.json", " file"), exception);
                }
                System.out.println("Unable to execute bash commands, retrying... ");
                exception.printStackTrace();
                JenkinsResultsParserUtil.sleep(3000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BuildDatabase _getBuildDatabase(String baseDirPath, Build build, boolean download) {
        if (baseDirPath == null && (baseDirPath = System.getenv("WORKSPACE")) == null) {
            throw new RuntimeException("Please set WORKSPACE");
        }
        Map<String, BuildDatabase> map = _buildDatabases;
        synchronized (map) {
            BuildDatabase buildDatabase = _buildDatabases.get(baseDirPath);
            if (buildDatabase == null) {
                File buildDatabaseFile;
                File baseDir = new File(baseDirPath);
                if (!baseDir.exists()) {
                    baseDir.mkdirs();
                }
                if (!(buildDatabaseFile = new File(baseDir, "build-database.json")).exists() && download) {
                    String distNodes = System.getenv("DIST_NODES");
                    String distPath = System.getenv("DIST_PATH");
                    if (distNodes != null && distPath != null) {
                        BuildDatabaseUtil._downloadBuildDatabaseFile(baseDir, distNodes, distPath);
                    } else if (build instanceof TopLevelBuild) {
                        BuildDatabaseUtil._downloadBuildDatabaseFile(baseDir, build);
                    }
                }
                buildDatabase = new DefaultBuildDatabase(baseDir);
                _buildDatabases.put(baseDirPath, buildDatabase);
            }
            return buildDatabase;
        }
    }

    private static String _getDistPath(Build build) {
        StringBuilder sb = new StringBuilder();
        if (JenkinsResultsParserUtil.isWindows()) {
            sb.append("C:");
        }
        sb.append("/tmp/jenkins/");
        JenkinsMaster jenkinsMaster = build.getJenkinsMaster();
        sb.append(jenkinsMaster.getName());
        sb.append("/");
        sb.append(build.getJobName());
        if (build instanceof AxisBuild) {
            AxisBuild axisBuild = (AxisBuild)build;
            sb.append("/");
            sb.append(axisBuild.getAxisNumber());
        }
        sb.append("/");
        sb.append(build.getBuildNumber());
        return sb.toString();
    }
}

