/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BuildData;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import com.liferay.jenkins.results.parser.WorkspaceUtil;

public abstract class BaseWorkspace
implements Workspace {
    private BuildData _buildData;
    private WorkspaceGitRepository _jenkinsWorkspaceGitRepository;
    private Job _job;

    @Override
    public void addJenkinsWorkspaceGitRepository(String jenkinsGitHubURL) {
        if (!JenkinsResultsParserUtil.isCINode() || jenkinsGitHubURL == null) {
            return;
        }
        this._jenkinsWorkspaceGitRepository = WorkspaceUtil.getWorkspaceGitRepository("jenkins", jenkinsGitHubURL, "master");
    }

    @Override
    public WorkspaceGitRepository getJenkinsWorkspaceGitRepository() {
        return this._jenkinsWorkspaceGitRepository;
    }

    @Override
    public void setBuildData(BuildData buildData) {
        this._buildData = buildData;
    }

    @Override
    public void setJob(Job job) {
        this._job = job;
    }

    @Override
    public void setUp() {
        this.setUpWorkspaceGitRepositories();
        this.setWorkspaceDefaultProperties();
        if (this._buildData != null) {
            this.setWorkspaceBuildDataProperties(this._buildData);
        }
        if (this._job != null) {
            this.setWorkspaceJobProperties(this._job);
        }
        this.writeWorkspaceGitRepositoryPropertiesFiles();
    }

    @Override
    public void tearDown() {
        this.tearDownWorkspaceGitRepositories();
    }

    protected void setUpJenkinsWorkspaceGitRepository() {
        if (this._jenkinsWorkspaceGitRepository != null) {
            this._jenkinsWorkspaceGitRepository.setUp();
        }
    }

    protected void setUpWorkspaceGitRepositories() {
        this.setUpJenkinsWorkspaceGitRepository();
    }

    protected abstract void setWorkspaceBuildDataProperties(BuildData var1);

    protected abstract void setWorkspaceDefaultProperties();

    protected abstract void setWorkspaceJobProperties(Job var1);

    protected void tearDownJenkinsWorkspaceGitRepository() {
        if (this._jenkinsWorkspaceGitRepository != null) {
            this._jenkinsWorkspaceGitRepository.tearDown();
        }
    }

    protected void tearDownWorkspaceGitRepositories() {
        this.tearDownJenkinsWorkspaceGitRepository();
    }

    protected abstract void writeWorkspaceGitRepositoryPropertiesFiles();
}

