/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BatchDependentJob;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.BuildFactory;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.JenkinsSlave;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.ParallelExecutor;
import com.liferay.jenkins.results.parser.TestSuiteJob;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalSegmentTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.SegmentTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroupFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseJob
implements Job {
    protected final List<File> jobPropertiesFiles = new ArrayList<File>();
    private static final Integer _THREAD_COUNT = 20;
    private static final ExecutorService _executorService = JenkinsResultsParserUtil.getNewThreadPoolExecutor(_THREAD_COUNT, true);
    private final Job.BuildProfile _buildProfile;
    private final String _jobName;
    private final Properties _jobProperties = new Properties();

    @Override
    public int getAxisCount() {
        List<AxisTestClassGroup> axisTestClassGroups = this.getAxisTestClassGroups();
        if (axisTestClassGroups == null) {
            return 0;
        }
        return axisTestClassGroups.size();
    }

    @Override
    public List<AxisTestClassGroup> getAxisTestClassGroups() {
        ArrayList<AxisTestClassGroup> axisTestClassGroups = new ArrayList<AxisTestClassGroup>();
        for (BatchTestClassGroup batchTestClassGroup : this.getBatchTestClassGroups()) {
            axisTestClassGroups.addAll(batchTestClassGroup.getAxisTestClassGroups());
        }
        return axisTestClassGroups;
    }

    @Override
    public Set<String> getBatchNames() {
        return this.getFilteredBatchNames(this.getRawBatchNames());
    }

    @Override
    public List<BatchTestClassGroup> getBatchTestClassGroups() {
        return this.getBatchTestClassGroups(this.getRawBatchNames());
    }

    @Override
    public List<Build> getBuildHistory(JenkinsMaster jenkinsMaster) {
        JSONObject jobJSONObject = this.getJobJSONObject(jenkinsMaster, "builds[number]");
        JSONArray buildsJSONArray = jobJSONObject.getJSONArray("builds");
        ArrayList<Build> builds = new ArrayList<Build>(buildsJSONArray.length());
        for (int i = 0; i < buildsJSONArray.length(); ++i) {
            JSONObject buildJSONObject = buildsJSONArray.getJSONObject(i);
            builds.add(BuildFactory.newBuild(JenkinsResultsParserUtil.combine(jenkinsMaster.getURL(), "/job/", this.getJobName(), "/", String.valueOf(buildJSONObject.getInt("number"))), null));
        }
        return builds;
    }

    @Override
    public Job.BuildProfile getBuildProfile() {
        return this._buildProfile;
    }

    @Override
    public List<String> getDistNodes() {
        try {
            List<JenkinsMaster> jenkinsMasters = JenkinsResultsParserUtil.getJenkinsMasters(JenkinsResultsParserUtil.getBuildProperties(), this._getSlaveRAMMinimumDefault(), this._getSlavesPerHostDefault(), JenkinsResultsParserUtil.getCohortName());
            int axisCount = this.getAxisCount();
            int distNodeAxisCount = this._getDistNodeAxisCount();
            int distNodeCount = axisCount / distNodeAxisCount;
            if (axisCount % distNodeAxisCount > 0) {
                ++distNodeCount;
            }
            distNodeCount = Math.min(distNodeCount, jenkinsMasters.size());
            distNodeCount = Math.max(distNodeCount, this._getDistNodeCountMinimum());
            List<JenkinsSlave> jenkinsSlaves = JenkinsResultsParserUtil.getReachableJenkinsSlaves(jenkinsMasters, distNodeCount);
            ArrayList<String> distNodes = new ArrayList<String>();
            for (JenkinsSlave jenkinsSlave : jenkinsSlaves) {
                distNodes.add(jenkinsSlave.getName());
            }
            return distNodes;
        }
        catch (IOException ioException) {
            return new ArrayList<String>();
        }
    }

    @Override
    public Job.DistType getDistType() {
        return Job.DistType.CI;
    }

    @Override
    public Set<String> getDistTypesExcludingTomcat() {
        TreeSet<String> distTypesExcludingTomcat = new TreeSet<String>(this.getDistTypes());
        distTypesExcludingTomcat.remove("tomcat");
        return distTypesExcludingTomcat;
    }

    @Override
    public String getJobName() {
        return this._jobName;
    }

    @Override
    public Properties getJobProperties() {
        return this._jobProperties;
    }

    @Override
    public String getJobProperty(String key) {
        return this._jobProperties.getProperty(key);
    }

    @Override
    public String getJobURL(JenkinsMaster jenkinsMaster) {
        return JenkinsResultsParserUtil.combine(jenkinsMaster.getURL(), "/job/", this._jobName);
    }

    @Override
    public Set<String> getSegmentNames() {
        return this.getFilteredSegmentNames(this.getRawBatchNames());
    }

    @Override
    public List<SegmentTestClassGroup> getSegmentTestClassGroups() {
        return this.getSegmentTestClassGroups(this.getRawBatchNames());
    }

    @Override
    public String getTestPropertiesContent() {
        HashMap<String, Properties> propertiesMap = new HashMap<String, Properties>();
        List<BatchTestClassGroup> batchTestClassGroups = this.getBatchTestClassGroups();
        if (this instanceof BatchDependentJob) {
            BatchDependentJob batchDependentJob = (BatchDependentJob)((Object)this);
            batchTestClassGroups.addAll(batchDependentJob.getDependentBatchTestClassGroups());
        }
        for (BatchTestClassGroup batchTestClassGroup : batchTestClassGroups) {
            Properties batchProperties = new Properties();
            batchProperties.setProperty("test.batch.job.name", batchTestClassGroup.getBatchJobName());
            batchProperties.setProperty("test.batch.maximum.slaves.per.host", String.valueOf(batchTestClassGroup.getMaximumSlavesPerHost()));
            batchProperties.setProperty("test.batch.minimum.slave.ram", String.valueOf(batchTestClassGroup.getMinimumSlaveRAM()));
            batchProperties.setProperty("test.batch.slave.label", batchTestClassGroup.getSlaveLabel());
            if (batchTestClassGroup instanceof FunctionalBatchTestClassGroup) {
                FunctionalBatchTestClassGroup functionalBatchTestClassGroup = (FunctionalBatchTestClassGroup)batchTestClassGroup;
                String testBatchRunPropertyQuery = functionalBatchTestClassGroup.getTestBatchRunPropertyQuery();
                if (testBatchRunPropertyQuery != null) {
                    batchProperties.setProperty("test.batch.run.property.query", testBatchRunPropertyQuery);
                }
            } else {
                batchProperties.setProperty("test.batch.size", String.valueOf(batchTestClassGroup.getAxisCount()));
            }
            propertiesMap.put(batchTestClassGroup.getBatchName(), batchProperties);
            for (int i = 0; i < batchTestClassGroup.getSegmentCount(); ++i) {
                Properties segmentProperties = new Properties();
                SegmentTestClassGroup segmentTestClassGroup = batchTestClassGroup.getSegmentTestClassGroup(i);
                segmentProperties.setProperty("test.batch.job.name", segmentTestClassGroup.getBatchJobName());
                segmentProperties.setProperty("test.batch.maximum.slaves.per.host", String.valueOf(segmentTestClassGroup.getMaximumSlavesPerHost()));
                segmentProperties.setProperty("test.batch.minimum.slave.ram", String.valueOf(segmentTestClassGroup.getMinimumSlaveRAM()));
                segmentProperties.setProperty("test.batch.name", segmentTestClassGroup.getBatchName());
                segmentProperties.setProperty("test.batch.size", String.valueOf(segmentTestClassGroup.getAxisCount()));
                segmentProperties.setProperty("test.batch.slave.label", segmentTestClassGroup.getSlaveLabel());
                String testCasePropertiesContent = segmentTestClassGroup.getTestCasePropertiesContent();
                if (testCasePropertiesContent != null) {
                    testCasePropertiesContent = testCasePropertiesContent.replaceAll("\n", "\\${line.separator}");
                    segmentProperties.setProperty("test.case.properties", testCasePropertiesContent);
                }
                if (segmentTestClassGroup instanceof FunctionalSegmentTestClassGroup) {
                    segmentProperties.setProperty("run.test.case.method.group", String.valueOf(i));
                }
                propertiesMap.put(segmentTestClassGroup.getSegmentName(), segmentProperties);
            }
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry propertiesEntry : propertiesMap.entrySet()) {
            Properties properties = (Properties)propertiesEntry.getValue();
            for (String propertyName : properties.stringPropertyNames()) {
                sb.append(propertyName);
                sb.append("[");
                sb.append((String)propertiesEntry.getKey());
                sb.append("]=");
                sb.append(properties.getProperty(propertyName));
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean isSegmentEnabled() {
        String segmentEnabled;
        String testSuiteName = "default";
        if (this instanceof TestSuiteJob) {
            TestSuiteJob testSuiteJob = (TestSuiteJob)((Object)this);
            testSuiteName = testSuiteJob.getTestSuiteName();
        }
        return (segmentEnabled = JenkinsResultsParserUtil.getProperty(this._jobProperties, "test.batch.segment.enabled", this.getJobName(), testSuiteName)) != null && segmentEnabled.equals("true");
    }

    @Override
    public boolean isValidationRequired() {
        return false;
    }

    @Override
    public void readJobProperties() {
        this._jobProperties.clear();
        for (File jobPropertiesFile : this.jobPropertiesFiles) {
            this._jobProperties.putAll((Map<?, ?>)JenkinsResultsParserUtil.getProperties(jobPropertiesFile));
        }
    }

    protected BaseJob(String jobName, Job.BuildProfile buildProfile) {
        this._jobName = jobName;
        this._buildProfile = buildProfile;
    }

    protected List<BatchTestClassGroup> getBatchTestClassGroups(Set<String> rawBatchNames) {
        if (rawBatchNames == null || rawBatchNames.isEmpty()) {
            return new ArrayList<BatchTestClassGroup>();
        }
        long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        System.out.println(JenkinsResultsParserUtil.combine("Started creating ", String.valueOf(rawBatchNames.size()), " batch test class groups at ", JenkinsResultsParserUtil.toDateString(new Date(start))));
        ArrayList callables = new ArrayList();
        final BaseJob job = this;
        for (final String batchName : rawBatchNames) {
            callables.add(new Callable<BatchTestClassGroup>(){
                private final Integer _pauseRetryCount = 2;
                private final Integer _pauseRetryDuration = 5000;

                @Override
                public BatchTestClassGroup call() throws Exception {
                    for (int i = 0; i < this._pauseRetryCount; ++i) {
                        try {
                            return this._call();
                        }
                        catch (Exception exception) {
                            System.out.println(JenkinsResultsParserUtil.combine("Retry creating a test class group in ", String.valueOf(this._pauseRetryDuration / 1000), " seconds."));
                            JenkinsResultsParserUtil.sleep(this._pauseRetryDuration.intValue());
                            continue;
                        }
                    }
                    return this._call();
                }

                private BatchTestClassGroup _call() throws Exception {
                    long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
                    System.out.println(JenkinsResultsParserUtil.combine("[", batchName, "] Started batch test class ", "group at ", JenkinsResultsParserUtil.toDateString(new Date(start))));
                    BatchTestClassGroup batchTestClassGroup = TestClassGroupFactory.newBatchTestClassGroup(batchName, job);
                    long duration = JenkinsResultsParserUtil.getCurrentTimeMillis() - start;
                    System.out.println(JenkinsResultsParserUtil.combine("[", batchName, "] Completed batch test class ", "group in ", JenkinsResultsParserUtil.toDurationString(duration), " at ", JenkinsResultsParserUtil.toDateString(new Date())));
                    if (batchTestClassGroup.getAxisCount() <= 0) {
                        return null;
                    }
                    return batchTestClassGroup;
                }
            });
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, _executorService);
        List<BatchTestClassGroup> batchTestClassGroups = parallelExecutor.execute();
        batchTestClassGroups.removeAll(Collections.singleton(null));
        System.out.println(JenkinsResultsParserUtil.combine("Completed creating ", String.valueOf(batchTestClassGroups.size()), " batch test class groups in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start), " at ", JenkinsResultsParserUtil.toDateString(new Date())));
        return batchTestClassGroups;
    }

    protected Set<String> getFilteredBatchNames(Set<String> rawBatchNames) {
        TreeSet<String> batchNames = new TreeSet<String>();
        for (BatchTestClassGroup batchTestClassGroup : this.getBatchTestClassGroups(rawBatchNames)) {
            batchNames.add(batchTestClassGroup.getBatchName());
        }
        return batchNames;
    }

    protected Set<String> getFilteredSegmentNames(Set<String> rawBatchNames) {
        TreeSet<String> segmentNames = new TreeSet<String>();
        for (BatchTestClassGroup batchTestClassGroup : this.getBatchTestClassGroups(rawBatchNames)) {
            for (int i = 0; i < batchTestClassGroup.getSegmentCount(); ++i) {
                SegmentTestClassGroup segmentTestClassGroup = batchTestClassGroup.getSegmentTestClassGroup(i);
                if (segmentTestClassGroup.getAxisCount() <= 0) continue;
                segmentNames.add(batchTestClassGroup.getBatchName() + "/" + i);
            }
        }
        return segmentNames;
    }

    protected JSONObject getJobJSONObject(JenkinsMaster jenkinsMaster, String tree) {
        if (this.getJobURL(jenkinsMaster) == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(JenkinsResultsParserUtil.getLocalURL(this.getJobURL(jenkinsMaster)));
        sb.append("/api/json?pretty");
        if (tree != null) {
            sb.append("&tree=");
            sb.append(tree);
        }
        try {
            return JenkinsResultsParserUtil.toJSONObject(sb.toString(), false);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get job JSON", ioException);
        }
    }

    protected abstract Set<String> getRawBatchNames();

    protected List<SegmentTestClassGroup> getSegmentTestClassGroups(Set<String> rawBatchNames) {
        ArrayList<SegmentTestClassGroup> segmentTestClassGroups = new ArrayList<SegmentTestClassGroup>();
        for (BatchTestClassGroup batchTestClassGroup : this.getBatchTestClassGroups(rawBatchNames)) {
            for (int i = 0; i < batchTestClassGroup.getSegmentCount(); ++i) {
                SegmentTestClassGroup segmentTestClassGroup = batchTestClassGroup.getSegmentTestClassGroup(i);
                if (segmentTestClassGroup.getAxisCount() <= 0) continue;
                segmentTestClassGroups.add(segmentTestClassGroup);
            }
        }
        return segmentTestClassGroups;
    }

    protected Set<String> getSetFromString(String string) {
        TreeSet<String> set = new TreeSet<String>();
        if (string == null) {
            return set;
        }
        for (String item : StringUtils.split((String)string, (String)",")) {
            if (item.startsWith("#")) continue;
            set.add(item.trim());
        }
        return set;
    }

    protected void setJobProperties(Properties properties) {
        this._jobProperties.clear();
        this._jobProperties.putAll((Map<?, ?>)properties);
    }

    private int _getDistNodeAxisCount() {
        try {
            String distNodeAxisCount = JenkinsResultsParserUtil.getBuildProperty("dist.node.axis.count");
            if (!JenkinsResultsParserUtil.isNullOrEmpty(distNodeAxisCount) && distNodeAxisCount.matches("\\d+") && !distNodeAxisCount.equals("0")) {
                return Integer.parseInt(distNodeAxisCount);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 25;
    }

    private int _getDistNodeCountMinimum() {
        try {
            String distNodeCountMinimum = JenkinsResultsParserUtil.getBuildProperty("dist.node.count.minimum");
            if (!JenkinsResultsParserUtil.isNullOrEmpty(distNodeCountMinimum) && distNodeCountMinimum.matches("\\d+") && !distNodeCountMinimum.equals("0")) {
                return Integer.parseInt(distNodeCountMinimum);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 3;
    }

    private int _getSlaveRAMMinimumDefault() {
        try {
            String slaveRAMMinimumDefault = JenkinsResultsParserUtil.getBuildProperty("slave.ram.minimum.default");
            if (!JenkinsResultsParserUtil.isNullOrEmpty(slaveRAMMinimumDefault) && slaveRAMMinimumDefault.matches("\\d+") && !slaveRAMMinimumDefault.equals("0")) {
                return Integer.parseInt(slaveRAMMinimumDefault);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 16;
    }

    private int _getSlavesPerHostDefault() {
        try {
            String slavesPerHostDefault = JenkinsResultsParserUtil.getBuildProperty("slaves.per.host.default");
            if (!JenkinsResultsParserUtil.isNullOrEmpty(slavesPerHostDefault) && slavesPerHostDefault.matches("\\d+") && !slavesPerHostDefault.equals("0")) {
                return Integer.parseInt(slavesPerHostDefault);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 2;
    }
}

