/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.vm.amazon;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.rds.AmazonRDS;
import com.amazonaws.services.rds.AmazonRDSClientBuilder;
import com.amazonaws.services.rds.model.CreateDBClusterRequest;
import com.amazonaws.services.rds.model.CreateDBInstanceRequest;
import com.amazonaws.services.rds.model.DBCluster;
import com.amazonaws.services.rds.model.DBInstance;
import com.amazonaws.services.rds.model.DeleteDBClusterRequest;
import com.amazonaws.services.rds.model.DeleteDBInstanceRequest;
import com.amazonaws.services.rds.model.DescribeDBClustersRequest;
import com.amazonaws.services.rds.model.DescribeDBClustersResult;
import com.amazonaws.services.rds.model.DescribeDBInstancesRequest;
import com.amazonaws.services.rds.model.DescribeDBInstancesResult;
import com.amazonaws.services.rds.model.Endpoint;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.vm.VM;
import java.util.List;

public abstract class AuroraAmazonVM
extends VM {
    private final AmazonRDS _amazonRDS;
    private final String _dbClusterId;
    private String _dbEngine;
    private String _dbEngineVersion;
    private String _dbInstanceClass;
    private final String _dbInstanceId;
    private String _dbPassword;
    private String _dbUsername;

    @Override
    public void create() {
        CreateDBClusterRequest createDBClusterRequest = new CreateDBClusterRequest();
        createDBClusterRequest.withBackupRetentionPeriod(Integer.valueOf(1));
        createDBClusterRequest.withDBClusterIdentifier(this._dbClusterId);
        createDBClusterRequest.withEngine(this._dbEngine);
        createDBClusterRequest.withEngineVersion(this._dbEngineVersion);
        createDBClusterRequest.withMasterUsername(this._dbUsername);
        createDBClusterRequest.withMasterUserPassword(this._dbPassword);
        createDBClusterRequest.withVpcSecurityGroupIds(new String[]{"sg-9ce452fb"});
        this._amazonRDS.createDBCluster(createDBClusterRequest);
        String dbClusterStatus = this._getDBClusterStatus();
        System.out.println("Waiting for the DB cluster to start");
        long timeout = System.currentTimeMillis() + 600000L;
        while (!dbClusterStatus.equals("available")) {
            if (System.currentTimeMillis() >= timeout) {
                throw new RuntimeException("Timeout occurred while waiting for DB cluster status \"available\"");
            }
            JenkinsResultsParserUtil.sleep(30000L);
            dbClusterStatus = this._getDBClusterStatus();
        }
        CreateDBInstanceRequest createDBInstanceRequest = new CreateDBInstanceRequest();
        createDBInstanceRequest.withDBClusterIdentifier(this._dbClusterId);
        createDBInstanceRequest.withDBInstanceClass(this._dbInstanceClass);
        createDBInstanceRequest.withDBInstanceIdentifier(this._dbInstanceId);
        createDBInstanceRequest.withEngine(this._dbEngine);
        createDBInstanceRequest.withMultiAZ(Boolean.valueOf(false));
        createDBInstanceRequest.withPubliclyAccessible(Boolean.valueOf(true));
        this._amazonRDS.createDBInstance(createDBInstanceRequest);
        String dbInstanceStatus = this._getDBInstanceStatus();
        System.out.println("Waiting for the DB instance to start");
        timeout = System.currentTimeMillis() + 600000L;
        while (!dbInstanceStatus.equals("available")) {
            if (System.currentTimeMillis() >= timeout) {
                throw new RuntimeException("Timeout occurred while waiting for DB instance status \"available\"");
            }
            JenkinsResultsParserUtil.sleep(30000L);
            dbInstanceStatus = this._getDBInstanceStatus();
        }
    }

    @Override
    public void delete() {
        DeleteDBInstanceRequest deleteDBInstanceRequest = new DeleteDBInstanceRequest();
        deleteDBInstanceRequest.withDBInstanceIdentifier(this._dbInstanceId);
        deleteDBInstanceRequest.withSkipFinalSnapshot(Boolean.valueOf(true));
        this._amazonRDS.deleteDBInstance(deleteDBInstanceRequest);
        DeleteDBClusterRequest deleteDBClusterRequest = new DeleteDBClusterRequest();
        deleteDBClusterRequest.withDBClusterIdentifier(this._dbClusterId);
        deleteDBClusterRequest.withSkipFinalSnapshot(Boolean.valueOf(true));
        this._amazonRDS.deleteDBCluster(deleteDBClusterRequest);
    }

    public String getAddress() {
        DBInstance dbInstance = this._getDBInstance();
        Endpoint endpoint = dbInstance.getEndpoint();
        return endpoint.getAddress();
    }

    public String getDBEngine() {
        return this._dbEngine;
    }

    public String getDBEngineVersion() {
        return this._dbEngineVersion;
    }

    public String getDBPassword() {
        return this._dbPassword;
    }

    public String getDBUsername() {
        return this._dbUsername;
    }

    protected AuroraAmazonVM(String awsAccessKeyId, String awsSecretAccessKey, String dbInstanceId) {
        this._dbInstanceId = dbInstanceId;
        BasicAWSCredentials basicAWSCredentials = new BasicAWSCredentials(awsAccessKeyId, awsSecretAccessKey);
        AmazonRDSClientBuilder amazonRDSClientBuilder = AmazonRDSClientBuilder.standard();
        amazonRDSClientBuilder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)basicAWSCredentials));
        amazonRDSClientBuilder.withRegion(Regions.US_WEST_1);
        this._amazonRDS = (AmazonRDS)amazonRDSClientBuilder.build();
        this._dbClusterId = this._getDbClusterId();
    }

    protected AuroraAmazonVM(String awsAccessKeyId, String awsSecretAccessKey, String dbClusterId, String dbEngine, String dbEngineVersion, String dbInstanceClass, String dbInstanceId, String dbPassword, String dbUsername) {
        this._dbClusterId = dbClusterId;
        this._dbEngine = dbEngine;
        this._dbEngineVersion = dbEngineVersion;
        this._dbInstanceClass = dbInstanceClass;
        this._dbInstanceId = dbInstanceId;
        this._dbPassword = dbPassword;
        this._dbUsername = dbUsername;
        BasicAWSCredentials basicAWSCredentials = new BasicAWSCredentials(awsAccessKeyId, awsSecretAccessKey);
        AmazonRDSClientBuilder amazonRDSClientBuilder = AmazonRDSClientBuilder.standard();
        amazonRDSClientBuilder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)basicAWSCredentials));
        amazonRDSClientBuilder.withRegion(Regions.US_WEST_1);
        this._amazonRDS = (AmazonRDS)amazonRDSClientBuilder.build();
    }

    private String _getDbClusterId() {
        DBInstance dbInstance = this._getDBInstance();
        return dbInstance.getDBClusterIdentifier();
    }

    private String _getDBClusterStatus() {
        DescribeDBClustersRequest describeDBClustersRequest = new DescribeDBClustersRequest();
        describeDBClustersRequest.withDBClusterIdentifier(this._dbClusterId);
        DescribeDBClustersResult describeDBClustersResult = this._amazonRDS.describeDBClusters(describeDBClustersRequest);
        List auroraClusters = describeDBClustersResult.getDBClusters();
        DBCluster auroraCluster = (DBCluster)auroraClusters.get(0);
        return auroraCluster.getStatus();
    }

    private DBInstance _getDBInstance() {
        DescribeDBInstancesRequest describeDBInstancesRequest = new DescribeDBInstancesRequest();
        describeDBInstancesRequest.withDBInstanceIdentifier(this._dbInstanceId);
        DescribeDBInstancesResult describeDBInstancesResult = this._amazonRDS.describeDBInstances(describeDBInstancesRequest);
        List dbInstances = describeDBInstancesResult.getDBInstances();
        return (DBInstance)dbInstances.get(0);
    }

    private String _getDBInstanceStatus() {
        DBInstance dbInstance = this._getDBInstance();
        return dbInstance.getDBInstanceStatus();
    }
}

