/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.vm.amazon;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2ClientBuilder;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.EbsInstanceBlockDeviceSpecification;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceBlockDeviceMapping;
import com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification;
import com.amazonaws.services.ec2.model.InstanceState;
import com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.vm.VM;
import java.util.List;

public abstract class AmazonVM
extends VM {
    private final AmazonEC2 _amazonEC2;
    private String _imageId;
    private String _instanceId;
    private String _instanceType;
    private String _keyName;

    @Override
    public void create() {
        RunInstancesRequest runInstancesRequest = new RunInstancesRequest();
        runInstancesRequest.withImageId(this._imageId);
        runInstancesRequest.withInstanceType(this._instanceType);
        runInstancesRequest.withKeyName(this._keyName);
        runInstancesRequest.withMaxCount(Integer.valueOf(1));
        runInstancesRequest.withMinCount(Integer.valueOf(1));
        runInstancesRequest.withSecurityGroupIds(new String[]{"sg-9ce452fb"});
        RunInstancesResult runInstancesResult = this._amazonEC2.runInstances(runInstancesRequest);
        Reservation instanceReservation = runInstancesResult.getReservation();
        String instanceReservationId = instanceReservation.getReservationId();
        DescribeInstancesResult describeInstancesResult = this._amazonEC2.describeInstances();
        List reservations = describeInstancesResult.getReservations();
        for (Reservation reservation : reservations) {
            String reservationId = reservation.getReservationId();
            if (!reservationId.equals(instanceReservationId)) continue;
            List instances = reservation.getInstances();
            Instance instance = (Instance)instances.get(0);
            this._instanceId = instance.getInstanceId();
            break;
        }
        this._waitForInstanceState("running");
        this._amazonEC2.modifyInstanceAttribute(this._getModifyInstanceAttributeRequest());
    }

    @Override
    public void delete() {
        TerminateInstancesRequest terminateInstancesRequest = new TerminateInstancesRequest();
        terminateInstancesRequest.withInstanceIds(new String[]{this._instanceId});
        this._amazonEC2.terminateInstances(terminateInstancesRequest);
        this._waitForInstanceState("terminated");
    }

    public String getInstanceId() {
        return this._instanceId;
    }

    public String getPublicDnsName() {
        Instance instance = this._getInstance();
        return instance.getPublicDnsName();
    }

    protected AmazonVM(String awsAccessKeyId, String awsSecretAccessKey, String instanceId) {
        this._instanceId = instanceId;
        BasicAWSCredentials basicAWSCredentials = new BasicAWSCredentials(awsAccessKeyId, awsSecretAccessKey);
        AmazonEC2ClientBuilder amazonEC2ClientBuilder = AmazonEC2ClientBuilder.standard();
        amazonEC2ClientBuilder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)basicAWSCredentials));
        amazonEC2ClientBuilder.withRegion(Regions.US_WEST_1);
        this._amazonEC2 = (AmazonEC2)amazonEC2ClientBuilder.build();
    }

    protected AmazonVM(String awsAccessKeyId, String awsSecretAccessKey, String imageId, String instanceType, String keyName) {
        this._imageId = imageId;
        this._instanceType = instanceType;
        this._keyName = keyName;
        BasicAWSCredentials basicAWSCredentials = new BasicAWSCredentials(awsAccessKeyId, awsSecretAccessKey);
        AmazonEC2ClientBuilder amazonEC2ClientBuilder = AmazonEC2ClientBuilder.standard();
        amazonEC2ClientBuilder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)basicAWSCredentials));
        amazonEC2ClientBuilder.withRegion(Regions.US_WEST_1);
        this._amazonEC2 = (AmazonEC2)amazonEC2ClientBuilder.build();
    }

    private String _getDeviceName() {
        Instance instance = this._getInstance();
        List instanceBlockDeviceMappings = instance.getBlockDeviceMappings();
        InstanceBlockDeviceMapping instanceBlockDeviceMapping = (InstanceBlockDeviceMapping)instanceBlockDeviceMappings.get(0);
        return instanceBlockDeviceMapping.getDeviceName();
    }

    private EbsInstanceBlockDeviceSpecification _getEbsInstanceBlockDeviceSpecification() {
        EbsInstanceBlockDeviceSpecification ebsInstanceBlockDeviceSpecification = new EbsInstanceBlockDeviceSpecification();
        ebsInstanceBlockDeviceSpecification.withDeleteOnTermination(Boolean.valueOf(true));
        return ebsInstanceBlockDeviceSpecification;
    }

    private Instance _getInstance() {
        DescribeInstancesRequest describeInstancesRequest = new DescribeInstancesRequest();
        describeInstancesRequest.withInstanceIds(new String[]{this._instanceId});
        DescribeInstancesResult describeInstancesResult = this._amazonEC2.describeInstances(describeInstancesRequest);
        List reservations = describeInstancesResult.getReservations();
        Reservation reservation = (Reservation)reservations.get(0);
        List instances = reservation.getInstances();
        return (Instance)instances.get(0);
    }

    private InstanceBlockDeviceMappingSpecification _getInstanceBlockDeviceMappingSpecification() {
        InstanceBlockDeviceMappingSpecification instanceBlockDeviceMappingSpecification = new InstanceBlockDeviceMappingSpecification();
        instanceBlockDeviceMappingSpecification.withDeviceName(this._getDeviceName());
        instanceBlockDeviceMappingSpecification.withEbs(this._getEbsInstanceBlockDeviceSpecification());
        return instanceBlockDeviceMappingSpecification;
    }

    private String _getInstanceState() {
        Instance instance = this._getInstance();
        InstanceState instanceState = instance.getState();
        return instanceState.getName();
    }

    private ModifyInstanceAttributeRequest _getModifyInstanceAttributeRequest() {
        ModifyInstanceAttributeRequest modifyInstanceAttributeRequest = new ModifyInstanceAttributeRequest();
        modifyInstanceAttributeRequest.withBlockDeviceMappings(new InstanceBlockDeviceMappingSpecification[]{this._getInstanceBlockDeviceMappingSpecification()});
        modifyInstanceAttributeRequest.withInstanceId(this._instanceId);
        return modifyInstanceAttributeRequest;
    }

    private void _waitForInstanceState(String targetState) {
        String instanceState = this._getInstanceState();
        System.out.println(JenkinsResultsParserUtil.combine("Waiting for the EC2 instance state \"", targetState, "\""));
        long timeout = System.currentTimeMillis() + 600000L;
        while (!instanceState.equals(targetState)) {
            if (System.currentTimeMillis() >= timeout) {
                throw new RuntimeException("Timeout occurred while waiting for EC2 instance state \"" + targetState + "\"");
            }
            JenkinsResultsParserUtil.sleep(30000L);
            instanceState = this._getInstanceState();
        }
    }
}

