/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.DefaultBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalAxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalSegmentTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.JUnitBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.JUnitSegmentTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.ModulesCompileBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.ModulesJUnitBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.ModulesSemVerBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.NPMTestBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.PluginsBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.PluginsSegmentTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.RESTBuilderBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.SegmentTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.ServiceBuilderBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TCKJunitBatchTestClassGroup;
import java.util.HashMap;
import java.util.Map;

public class TestClassGroupFactory {
    private static final Map<String, BatchTestClassGroup> _batchTestClassGroups = new HashMap<String, BatchTestClassGroup>();

    public static AxisTestClassGroup newAxisTestClassGroup(BatchTestClassGroup batchTestClassGroup) {
        if (batchTestClassGroup instanceof FunctionalBatchTestClassGroup) {
            return new FunctionalAxisTestClassGroup((FunctionalBatchTestClassGroup)batchTestClassGroup);
        }
        return new AxisTestClassGroup(batchTestClassGroup);
    }

    public static BatchTestClassGroup newBatchTestClassGroup(String batchName, BatchTestClassGroup.BuildProfile buildProfile, Job job) {
        String key = JenkinsResultsParserUtil.combine(batchName, "_", buildProfile.toString(), "_", job.getJobName());
        if (_batchTestClassGroups.containsKey(key)) {
            return _batchTestClassGroups.get(key);
        }
        BatchTestClassGroup batchTestClassGroup = null;
        if (job instanceof PortalTestClassJob) {
            PortalTestClassJob portalTestClassJob = (PortalTestClassJob)job;
            batchTestClassGroup = batchName.contains("functional-") || batchName.contains("subrepository-functional-") ? new FunctionalBatchTestClassGroup(batchName, portalTestClassJob) : (batchName.startsWith("integration-") || batchName.startsWith("junit-test-") || batchName.startsWith("subrepository-integration-") || batchName.startsWith("subrepository-unit-") || batchName.startsWith("unit-") ? new JUnitBatchTestClassGroup(batchName, portalTestClassJob) : (batchName.startsWith("modules-compile-") ? new ModulesCompileBatchTestClassGroup(batchName, portalTestClassJob) : (batchName.startsWith("modules-integration-") || batchName.startsWith("modules-unit-") ? new ModulesJUnitBatchTestClassGroup(batchName, portalTestClassJob) : (batchName.startsWith("modules-semantic-versioning-") ? new ModulesSemVerBatchTestClassGroup(batchName, portalTestClassJob) : (batchName.startsWith("plugins-compile-") ? new PluginsBatchTestClassGroup(batchName, portalTestClassJob) : (batchName.startsWith("js-test-") || batchName.startsWith("portal-frontend-js-") ? new NPMTestBatchTestClassGroup(batchName, portalTestClassJob) : (batchName.startsWith("rest-builder-") ? new RESTBuilderBatchTestClassGroup(batchName, portalTestClassJob) : (batchName.startsWith("service-builder-") ? new ServiceBuilderBatchTestClassGroup(batchName, portalTestClassJob) : (batchName.startsWith("tck-") ? new TCKJunitBatchTestClassGroup(batchName, portalTestClassJob) : new DefaultBatchTestClassGroup(batchName, portalTestClassJob))))))))));
        }
        if (batchTestClassGroup == null) {
            throw new IllegalArgumentException("Unknown test class group");
        }
        _batchTestClassGroups.put(key, batchTestClassGroup);
        return batchTestClassGroup;
    }

    public static BatchTestClassGroup newBatchTestClassGroup(String batchName, Job job) {
        BatchTestClassGroup.BuildProfile buildProfile = BatchTestClassGroup.BuildProfile.PORTAL;
        if (job.getBuildProfile() == Job.BuildProfile.DXP) {
            buildProfile = BatchTestClassGroup.BuildProfile.DXP;
        }
        return TestClassGroupFactory.newBatchTestClassGroup(batchName, buildProfile, job);
    }

    public static SegmentTestClassGroup newSegmentTestClassGroup(BatchTestClassGroup batchTestClassGroup) {
        if (batchTestClassGroup instanceof FunctionalBatchTestClassGroup) {
            return new FunctionalSegmentTestClassGroup((FunctionalBatchTestClassGroup)batchTestClassGroup);
        }
        if (batchTestClassGroup instanceof JUnitBatchTestClassGroup) {
            return new JUnitSegmentTestClassGroup((JUnitBatchTestClassGroup)batchTestClassGroup);
        }
        if (batchTestClassGroup instanceof PluginsBatchTestClassGroup) {
            return new PluginsSegmentTestClassGroup((PluginsBatchTestClassGroup)batchTestClassGroup);
        }
        return new SegmentTestClassGroup(batchTestClassGroup);
    }
}

