/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BaseTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroupFactory;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public class NPMTestBatchTestClassGroup
extends BatchTestClassGroup {
    private static final String _TOKEN_CLASS_METHOD_SEPARATOR = "::";

    @Override
    public int getAxisCount() {
        if (!this.isStableTestSuiteBatch() && this.testRelevantIntegrationUnitOnly) {
            return 0;
        }
        return super.getAxisCount();
    }

    @Override
    public AxisTestClassGroup getAxisTestClassGroup(int axisId) {
        if (axisId != 0) {
            throw new IllegalArgumentException("axisId is not 0");
        }
        AxisTestClassGroup axisTestClassGroup = (AxisTestClassGroup)this.axisTestClassGroups.get(axisId);
        if (axisTestClassGroup != null) {
            return (AxisTestClassGroup)this.axisTestClassGroups.get(axisId);
        }
        return TestClassGroupFactory.newAxisTestClassGroup(this);
    }

    public Map<File, NPMTestBatchTestClass> getNPMTestBatchTestClasses() {
        return NPMTestBatchTestClass.getNPMTestBatchTestClasses();
    }

    public void writeTestCSVReportFile() throws Exception {
        BatchTestClassGroup.CSVReport csvReport = new BatchTestClassGroup.CSVReport(new BatchTestClassGroup.CSVReport.Row("Module Name", "Class Name", "Method Name", "Ignored", "File Path"));
        Map<File, NPMTestBatchTestClass> npmTestBatchTestClasses = this.getNPMTestBatchTestClasses();
        for (NPMTestBatchTestClass npmTestBatchTestClass : npmTestBatchTestClasses.values()) {
            File moduleTestClassFile = npmTestBatchTestClass.getTestClassFile();
            String moduleName = moduleTestClassFile.getName();
            List<TestClassGroup.TestClass.TestClassMethod> jsTestClassMethods = npmTestBatchTestClass.getJSTestClassMethods();
            for (TestClassGroup.TestClass.TestClassMethod jsTestClassMethod : jsTestClassMethods) {
                String classMethodName = jsTestClassMethod.getName();
                int colonIndex = classMethodName.indexOf(_TOKEN_CLASS_METHOD_SEPARATOR);
                String filePath = classMethodName.substring(0, colonIndex);
                String className = filePath.substring(filePath.lastIndexOf("/") + 1);
                String methodName = classMethodName.substring(colonIndex + _TOKEN_CLASS_METHOD_SEPARATOR.length());
                BatchTestClassGroup.CSVReport.Row csvReportRow = new BatchTestClassGroup.CSVReport.Row();
                csvReportRow.add(moduleName);
                csvReportRow.add(className);
                csvReportRow.add(StringEscapeUtils.escapeCsv((String)methodName));
                if (jsTestClassMethod.isIgnored()) {
                    csvReportRow.add("TRUE");
                } else {
                    csvReportRow.add("");
                }
                csvReportRow.add(filePath);
                csvReport.addRow(csvReportRow);
            }
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy");
        File csvReportFile = new File(JenkinsResultsParserUtil.combine("Report_js_", simpleDateFormat.format(new Date()), ".csv"));
        try {
            JenkinsResultsParserUtil.write(csvReportFile, csvReport.toString());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    protected NPMTestBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
        List<File> moduleDirs;
        try {
            moduleDirs = !(!this.testRelevantChanges || this.includeStableTestSuite && this.isStableTestSuiteBatch()) ? this.portalGitWorkingDirectory.getModifiedNPMTestModuleDirsList() : this.portalGitWorkingDirectory.getNPMTestModuleDirsList();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        if (moduleDirs.isEmpty()) {
            return;
        }
        AxisTestClassGroup axisTestClassGroup = TestClassGroupFactory.newAxisTestClassGroup(this);
        for (File moduleDir : moduleDirs) {
            NPMTestBatchTestClass npmTestBatchTestClass = NPMTestBatchTestClass.getInstance(batchName, this.portalGitWorkingDirectory, new File(JenkinsResultsParserUtil.getCanonicalPath(moduleDir)));
            this.testClasses.add(npmTestBatchTestClass);
            axisTestClassGroup.addTestClass(npmTestBatchTestClass);
        }
        this.axisTestClassGroups.add(0, axisTestClassGroup);
    }

    public static class NPMTestBatchTestClass
    extends BaseTestClassGroup.BaseTestClass {
        private static final Pattern _itPattern = Pattern.compile("\\s+(?<xit>x)?it\\s*\\(\\s*\\'(?<description>[\\s\\S]*?)\\'");
        private static final Map<File, NPMTestBatchTestClass> _npmTestBatchTestClasses = new HashMap<File, NPMTestBatchTestClass>();
        private final GitWorkingDirectory _gitWorkingDirectory;
        private final List<TestClassGroup.TestClass.TestClassMethod> _jsTestClassMethods = new ArrayList<TestClassGroup.TestClass.TestClassMethod>();
        private final File _moduleFile;

        public List<TestClassGroup.TestClass.TestClassMethod> getJSTestClassMethods() {
            return this._jsTestClassMethods;
        }

        protected static NPMTestBatchTestClass getInstance(String batchName, GitWorkingDirectory gitWorkingDirectory, File moduleDir) {
            if (_npmTestBatchTestClasses.containsKey(moduleDir)) {
                return _npmTestBatchTestClasses.get(moduleDir);
            }
            _npmTestBatchTestClasses.put(moduleDir, new NPMTestBatchTestClass(batchName, gitWorkingDirectory, new File(JenkinsResultsParserUtil.getCanonicalPath(moduleDir))));
            return _npmTestBatchTestClasses.get(moduleDir);
        }

        protected static Map<File, NPMTestBatchTestClass> getNPMTestBatchTestClasses() {
            return _npmTestBatchTestClasses;
        }

        protected NPMTestBatchTestClass(String batchName, GitWorkingDirectory gitWorkingDirectory, File testClassFile) {
            super(testClassFile);
            this.addTestClassMethod(batchName);
            this._gitWorkingDirectory = gitWorkingDirectory;
            this._moduleFile = testClassFile;
            this.initJSTestClassMethods();
        }

        protected void initJSTestClassMethods() {
            List<File> jsFiles = JenkinsResultsParserUtil.findFiles(this._moduleFile, ".*\\.js");
            String workingDirectoryPath = JenkinsResultsParserUtil.getCanonicalPath(this._gitWorkingDirectory.getWorkingDirectory());
            for (File jsFile : jsFiles) {
                try {
                    String jsFileRelativePath = JenkinsResultsParserUtil.getCanonicalPath(jsFile);
                    jsFileRelativePath = jsFileRelativePath.replace(workingDirectoryPath, "");
                    String jsFileContent = JenkinsResultsParserUtil.read(jsFile);
                    Matcher matcher = _itPattern.matcher(jsFileContent);
                    while (matcher.find()) {
                        String methodName = matcher.group("description");
                        String xit = matcher.group("xit");
                        boolean methodIgnored = false;
                        if (xit != null) {
                            methodIgnored = true;
                        }
                        this._jsTestClassMethods.add(new TestClassGroup.TestClass.TestClassMethod(methodIgnored, jsFileRelativePath + NPMTestBatchTestClassGroup._TOKEN_CLASS_METHOD_SEPARATOR + methodName, this));
                    }
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
            }
        }
    }
}

