/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.google.common.collect.Lists;
import com.liferay.jenkins.results.parser.AntException;
import com.liferay.jenkins.results.parser.AntUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BaseTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.SegmentTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroupFactory;
import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.util.PropsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FunctionalBatchTestClassGroup
extends BatchTestClassGroup {
    private static final Pattern _poshiTestCasePattern = Pattern.compile("(?<namespace>[^\\.]+)\\.(?<className>[^\\#]+)\\#(?<methodName>.*)");
    private final PortalTestClassJob _portalTestClassJob;
    private String _relevantTestBatchRunPropertyQuery;

    @Override
    public int getAxisCount() {
        return this.axisTestClassGroups.size();
    }

    public String getRelevantTestBatchRunPropertyQuery() {
        return this._relevantTestBatchRunPropertyQuery;
    }

    @Override
    public String getTestCasePropertiesContent() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> segmentIndexes = new ArrayList<String>();
        for (int segmentIndex = 0; segmentIndex < this.getSegmentCount(); ++segmentIndex) {
            SegmentTestClassGroup segmentTestClassGroup = this.getSegmentTestClassGroup(segmentIndex);
            sb.append(segmentTestClassGroup.getTestCasePropertiesContent());
            sb.append("\n");
            segmentIndexes.add(String.valueOf(segmentIndex));
        }
        sb.append("RUN_TEST_CASE_METHOD_GROUPS=");
        sb.append(JenkinsResultsParserUtil.join(" ", segmentIndexes));
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public List<TestClassGroup.TestClass> getTestClasses() {
        ArrayList<TestClassGroup.TestClass> testClasses = new ArrayList<TestClassGroup.TestClass>();
        for (AxisTestClassGroup axisTestClassGroup : this.axisTestClassGroups) {
            testClasses.addAll(axisTestClassGroup.getTestClasses());
        }
        return testClasses;
    }

    protected FunctionalBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
        this._portalTestClassJob = portalTestClassJob;
        this._setRelevantTestBatchRunPropertyQuery();
        this.setAxisTestClassGroups();
        this.setSegmentTestClassGroups();
    }

    @Override
    protected void setAxisTestClassGroups() {
        if (!this.axisTestClassGroups.isEmpty()) {
            return;
        }
        for (List<String> poshiTestClassGroup : this._getPoshiTestClassGroups()) {
            if (poshiTestClassGroup.isEmpty()) continue;
            AxisTestClassGroup axisTestClassGroup = TestClassGroupFactory.newAxisTestClassGroup(this);
            for (String testClassMethodName : poshiTestClassGroup) {
                Matcher matcher = _poshiTestCasePattern.matcher(testClassMethodName);
                if (!matcher.find()) {
                    throw new RuntimeException("Invalid test class method name " + testClassMethodName);
                }
                axisTestClassGroup.addTestClass(FunctionalTestClass.getInstance(testClassMethodName));
            }
            this.axisTestClassGroups.add(axisTestClassGroup);
        }
    }

    private String _getDefaultTestBatchRunPropertyGlobalQuery(String testSuiteName) {
        return this.getFirstPropertyValue("test.batch.run.property.global.query", this.batchName, testSuiteName);
    }

    private String _getDefaultTestBatchRunPropertyQuery(String testSuiteName) {
        return this.getFirstPropertyValue("test.batch.run.property.query", this.batchName, testSuiteName);
    }

    private List<File> _getFunctionalRequiredModuleDirs(List<File> moduleDirs) {
        ArrayList functionalRequiredModuleDirs = Lists.newArrayList(moduleDirs);
        File modulesBaseDir = new File(this.portalGitWorkingDirectory.getWorkingDirectory(), "modules");
        for (File moduleDir : moduleDirs) {
            Properties moduleDirTestProperties = JenkinsResultsParserUtil.getProperties(new File(moduleDir, "test.properties"));
            String functionalRequiredModuleDirPaths = moduleDirTestProperties.getProperty("modules.includes.required.functional[" + this.testSuiteName + "]");
            if (functionalRequiredModuleDirPaths == null) continue;
            for (String functionalRequiredModuleDirPath : functionalRequiredModuleDirPaths.split(",")) {
                File functionalRequiredModuleDir = new File(modulesBaseDir, functionalRequiredModuleDirPath);
                if (!functionalRequiredModuleDir.exists() || functionalRequiredModuleDirs.contains(functionalRequiredModuleDir)) continue;
                functionalRequiredModuleDirs.add(functionalRequiredModuleDir);
            }
        }
        return Lists.newArrayList((Iterable)functionalRequiredModuleDirs);
    }

    private List<List<String>> _getPoshiTestClassGroups() {
        String query = this.getRelevantTestBatchRunPropertyQuery();
        if (query == null) {
            return new ArrayList<List<String>>();
        }
        PortalGitWorkingDirectory portalGitWorkingDirectory = this._portalTestClassJob.getPortalGitWorkingDirectory();
        File portalDir = portalGitWorkingDirectory.getWorkingDirectory();
        HashMap<String, String> parameters = new HashMap<String, String>();
        String testBaseDirName = this._getTestBaseDirName();
        if (testBaseDirName != null) {
            parameters.put("test.base.dir.name", testBaseDirName);
        }
        try {
            AntUtil.callTarget(portalDir, "build-test.xml", "prepare-poshi-runner-properties", parameters);
        }
        catch (AntException antException) {
            throw new RuntimeException(antException);
        }
        Properties properties = JenkinsResultsParserUtil.getProperties(new File(portalDir, "portal-web/test/test-portal-web.properties"), new File(portalDir, "portal-web/test/test-portal-web-ext.properties"));
        properties.setProperty("ignore.errors.util.classes", "true");
        for (String propertyName : properties.stringPropertyNames()) {
            String propertyValue = properties.getProperty(propertyName);
            if (propertyValue == null) continue;
            PropsUtil.set((String)propertyName, (String)propertyValue);
        }
        try {
            PoshiContext.clear();
            PoshiContext.readFiles();
            return PoshiContext.getTestBatchGroups((String)query, (int)this.getAxisMaxSize());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private String _getTestBaseDirName() {
        String testBaseDirName = System.getenv("test.base.dir.name");
        if (testBaseDirName == null || !testBaseDirName.isEmpty()) {
            testBaseDirName = System.getenv("env.TEST_BASE_DIR_NAME");
        }
        if (testBaseDirName == null || !testBaseDirName.isEmpty()) {
            testBaseDirName = System.getenv("TEST_BASE_DIR_NAME");
        }
        if (testBaseDirName == null || !testBaseDirName.isEmpty()) {
            return null;
        }
        File testBaseDir = new File(testBaseDirName);
        if (!testBaseDir.exists() || !testBaseDir.isDirectory()) {
            return null;
        }
        try {
            return testBaseDir.getCanonicalPath();
        }
        catch (IOException ioException) {
            return null;
        }
    }

    private void _setRelevantTestBatchRunPropertyQuery() {
        String stableTestBatchRunPropertyQuery;
        if (!this.testRelevantChanges) {
            this._relevantTestBatchRunPropertyQuery = this._getDefaultTestBatchRunPropertyQuery(this.testSuiteName);
            return;
        }
        HashSet<File> modifiedDirsList = new HashSet<File>();
        try {
            modifiedDirsList.addAll(this.portalGitWorkingDirectory.getModifiedModuleDirsList());
        }
        catch (IOException ioException) {
            File workingDirectory = this.portalGitWorkingDirectory.getWorkingDirectory();
            throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to get module directories in ", workingDirectory.getPath()), ioException);
        }
        File modulesDir = new File(this.portalGitWorkingDirectory.getWorkingDirectory(), "modules");
        modifiedDirsList.addAll(this.portalGitWorkingDirectory.getModifiedDirsList(false, JenkinsResultsParserUtil.toPathMatchers(null, JenkinsResultsParserUtil.getCanonicalPath(modulesDir)), null));
        modifiedDirsList.addAll(this.getRequiredModuleDirs(Lists.newArrayList(modifiedDirsList)));
        modifiedDirsList.addAll(this._getFunctionalRequiredModuleDirs(Lists.newArrayList(modifiedDirsList)));
        StringBuilder sb = new StringBuilder();
        for (File modifiedDir : modifiedDirsList) {
            File modifiedDirTestProperties = new File(modifiedDir, "test.properties");
            if (!modifiedDirTestProperties.exists()) continue;
            Properties testProperties = JenkinsResultsParserUtil.getProperties(modifiedDirTestProperties);
            String testBatchRunPropertyQuery = null;
            String firstMatchingPropertyName = this.getFirstMatchingPropertyName("test.batch.run.property.query", testProperties, this.testSuiteName);
            if (firstMatchingPropertyName != null) {
                testBatchRunPropertyQuery = JenkinsResultsParserUtil.getProperty(testProperties, firstMatchingPropertyName);
            }
            if (testBatchRunPropertyQuery == null) {
                testBatchRunPropertyQuery = JenkinsResultsParserUtil.getProperty(testProperties, JenkinsResultsParserUtil.combine("test.batch.run.property.query[", this.batchName, "][", this.testSuiteName, "]"));
            }
            if (testBatchRunPropertyQuery == null) continue;
            if (sb.length() > 0) {
                sb.append(" OR (");
            } else {
                sb.append("(");
            }
            sb.append(testBatchRunPropertyQuery);
            sb.append(")");
        }
        if (sb.length() == 0) {
            sb.append("(");
            sb.append(this._getDefaultTestBatchRunPropertyQuery(this.testSuiteName));
            sb.append(")");
        }
        if ((stableTestBatchRunPropertyQuery = this._getDefaultTestBatchRunPropertyQuery("stable")) != null && this.includeStableTestSuite && this.isStableTestSuiteBatch()) {
            sb.append(" OR (");
            sb.append(stableTestBatchRunPropertyQuery);
            sb.append(")");
        }
        this._relevantTestBatchRunPropertyQuery = sb.toString();
        String defaultGlobalQuery = this._getDefaultTestBatchRunPropertyGlobalQuery(this.testSuiteName);
        if (defaultGlobalQuery != null && !defaultGlobalQuery.isEmpty()) {
            this._relevantTestBatchRunPropertyQuery = JenkinsResultsParserUtil.combine("(", defaultGlobalQuery, ") AND (", this._relevantTestBatchRunPropertyQuery, ")");
        }
    }

    public static class FunctionalTestClass
    extends BaseTestClassGroup.BaseTestClass {
        private final String _testClassMethodName;

        public Properties getPoshiProperties() {
            return PoshiContext.getNamespacedClassCommandNameProperties((String)this.getTestClassMethodName());
        }

        public String getTestClassMethodName() {
            return this._testClassMethodName;
        }

        protected static FunctionalTestClass getInstance(String testClassMethodName) {
            return new FunctionalTestClass(testClassMethodName);
        }

        protected FunctionalTestClass(String testClassMethodName) {
            super(FunctionalTestClass._getTestClassFile(testClassMethodName));
            this.addTestClassMethod(testClassMethodName);
            this._testClassMethodName = testClassMethodName;
        }

        private static File _getTestClassFile(String testClassMethodName) {
            Matcher matcher = _poshiTestCasePattern.matcher(testClassMethodName);
            if (!matcher.find()) {
                throw new RuntimeException("Invalid test class method name " + testClassMethodName);
            }
            return new File(PoshiContext.getFilePathFromFileName((String)(matcher.group("className") + ".testcase"), (String)matcher.group("namespace")));
        }
    }
}

