/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.google.common.collect.Lists;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.TestSuiteJob;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BaseTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.SegmentTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroupFactory;
import java.io.File;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public abstract class BatchTestClassGroup
extends BaseTestClassGroup {
    protected static final String NAME_STABLE_TEST_SUITE = "stable";
    protected final List<AxisTestClassGroup> axisTestClassGroups = new ArrayList<AxisTestClassGroup>();
    protected final String batchName;
    protected final List<PathMatcher> excludesPathMatchers = new ArrayList<PathMatcher>();
    protected final List<PathMatcher> includesPathMatchers = new ArrayList<PathMatcher>();
    protected boolean includeStableTestSuite;
    protected final Properties jobProperties;
    protected final PortalGitWorkingDirectory portalGitWorkingDirectory;
    protected List<String> stableTestSuiteBatchNames = new ArrayList<String>();
    protected boolean testPrivatePortalBranch;
    protected boolean testReleaseBundle;
    protected boolean testRelevantChanges;
    protected boolean testRelevantIntegrationUnitOnly;
    protected final String testSuiteName;
    private static final int _AXES_SIZE_MAX_DEFAULT = 5000;
    private static final boolean _ENABLE_TEST_RELEASE_BUNDLE_DEFAULT = false;
    private static final boolean _ENABLE_TEST_RELEVANT_CHANGES_DEFAULT = false;
    private static final int _SEGMENT_MAX_CHILDREN_DEFAULT = 25;
    private final List<SegmentTestClassGroup> _segmentTestClassGroups = new ArrayList<SegmentTestClassGroup>();

    public int getAxisCount() {
        String axisCount = this.getFirstPropertyValue("test.batch.axis.count");
        if (axisCount != null) {
            return Integer.parseInt(axisCount);
        }
        int testClassCount = this.testClasses.size();
        if (testClassCount == 0) {
            return 0;
        }
        int axisMaxSize = this.getAxisMaxSize();
        if (axisMaxSize <= 0) {
            throw new RuntimeException("'test.batch.axis.max.size' cannot be 0 or less");
        }
        return (int)Math.ceil((double)testClassCount / (double)axisMaxSize);
    }

    public AxisTestClassGroup getAxisTestClassGroup(int axisId) {
        return this.axisTestClassGroups.get(axisId);
    }

    public List<AxisTestClassGroup> getAxisTestClassGroups() {
        return this.axisTestClassGroups;
    }

    public String getBatchName() {
        return this.batchName;
    }

    public Integer getMaximumSlavesPerHost() {
        String maximumSlavesPerHost = this.getFirstPropertyValue("test.batch.maximum.slaves.per.host");
        if (maximumSlavesPerHost == null) {
            return JenkinsMaster.getSlavesPerHostDefault();
        }
        return Integer.valueOf(maximumSlavesPerHost);
    }

    public Integer getMinimumSlaveRAM() {
        String minimumSlaveRAM = this.getFirstPropertyValue("test.batch.minimum.slave.ram");
        if (minimumSlaveRAM == null) {
            return JenkinsMaster.getSlaveRAMMinimumDefault();
        }
        return Integer.valueOf(minimumSlaveRAM);
    }

    public PortalGitWorkingDirectory getPortalGitWorkingDirectory() {
        return this.portalGitWorkingDirectory;
    }

    public int getSegmentCount() {
        return this._segmentTestClassGroups.size();
    }

    public SegmentTestClassGroup getSegmentTestClassGroup(int segmentId) {
        return this._segmentTestClassGroups.get(segmentId);
    }

    public List<SegmentTestClassGroup> getSegmentTestClassGroups() {
        return this._segmentTestClassGroups;
    }

    public String getTestCasePropertiesContent() {
        return null;
    }

    protected BatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        this.batchName = batchName;
        this.portalGitWorkingDirectory = portalTestClassJob.getPortalGitWorkingDirectory();
        String portalBranchName = this.portalGitWorkingDirectory.getUpstreamBranchName();
        if (portalBranchName.endsWith("-private")) {
            this.testPrivatePortalBranch = true;
        }
        if (portalTestClassJob instanceof TestSuiteJob) {
            TestSuiteJob testSuiteJob = (TestSuiteJob)((Object)portalTestClassJob);
            this.testSuiteName = testSuiteJob.getTestSuiteName();
        } else {
            this.testSuiteName = null;
        }
        this.jobProperties = portalTestClassJob.getJobProperties();
        String stableTestSuiteBatchNamesFirstPropertyValue = this.getFirstPropertyValue("test.batch.names", batchName, NAME_STABLE_TEST_SUITE);
        if (stableTestSuiteBatchNamesFirstPropertyValue != null) {
            Collections.addAll(this.stableTestSuiteBatchNames, stableTestSuiteBatchNamesFirstPropertyValue.split("\\s*,\\s*"));
        }
        this._setTestReleaseBundle();
        this._setTestRelevantChanges();
        this._setTestRelevantIntegrationUnitOnly();
        this._setIncludeStableTestSuite();
    }

    protected int getAxisMaxSize() {
        String axisMaxSize = this.getFirstPropertyValue("test.batch.axis.max.size");
        if (axisMaxSize != null) {
            return Integer.parseInt(axisMaxSize);
        }
        return 5000;
    }

    protected String getFirstMatchingPropertyName(String basePropertyName, Properties properties, String testSuiteName) {
        return this.getFirstMatchingPropertyName(basePropertyName, null, properties, testSuiteName);
    }

    protected String getFirstMatchingPropertyName(String basePropertyName, String batchName, Properties properties, String testSuiteName) {
        if (batchName == null) {
            batchName = this.batchName;
        }
        if (basePropertyName.contains("[") || basePropertyName.contains("]")) {
            throw new RuntimeException("Invalid base property name " + basePropertyName);
        }
        Pattern pattern = Pattern.compile(JenkinsResultsParserUtil.combine(basePropertyName, "\\[(?<batchName>[^\\]]+)\\]", "(\\[(?<testSuiteName>[^\\]]+)\\])?"));
        for (String propertyName : properties.stringPropertyNames()) {
            String targetTestSuiteName;
            Matcher matcher;
            if (!propertyName.startsWith(basePropertyName) || !(matcher = pattern.matcher(propertyName)).find()) continue;
            String batchNameRegex = matcher.group("batchName");
            if (!batchName.matches(batchNameRegex = batchNameRegex.replace("*", ".+")) || !Objects.equals(testSuiteName, targetTestSuiteName = matcher.group("testSuiteName"))) continue;
            return propertyName;
        }
        return null;
    }

    protected String getFirstPropertyValue(String basePropertyName) {
        return this.getFirstPropertyValue(basePropertyName, this.batchName, this.testSuiteName);
    }

    protected String getFirstPropertyValue(String basePropertyName, String batchName) {
        return this.getFirstPropertyValue(basePropertyName, batchName, this.testSuiteName);
    }

    protected String getFirstPropertyValue(String basePropertyName, String batchName, String testSuiteName) {
        if (basePropertyName.contains("[") || basePropertyName.contains("]")) {
            throw new RuntimeException("Invalid base property name " + basePropertyName);
        }
        ArrayList<String> propertyNames = new ArrayList<String>();
        if (testSuiteName != null) {
            propertyNames.add(JenkinsResultsParserUtil.combine(basePropertyName, "[", batchName, "][", testSuiteName, "]"));
            propertyNames.add(this.getFirstMatchingPropertyName(basePropertyName, batchName, this.jobProperties, testSuiteName));
            propertyNames.add(JenkinsResultsParserUtil.combine(basePropertyName, "[", testSuiteName, "]"));
        }
        propertyNames.add(JenkinsResultsParserUtil.combine(basePropertyName, "[", batchName, "]"));
        propertyNames.add(this.getFirstMatchingPropertyName(basePropertyName, batchName, this.jobProperties, null));
        propertyNames.add(basePropertyName);
        for (String propertyName : propertyNames) {
            String propertyValue;
            if (propertyName == null || !this.jobProperties.containsKey(propertyName) || (propertyValue = JenkinsResultsParserUtil.getProperty(this.jobProperties, propertyName)) == null || propertyValue.isEmpty()) continue;
            return propertyValue;
        }
        return null;
    }

    protected List<PathMatcher> getPathMatchers(String relativeGlobs, File workingDirectory) {
        if (relativeGlobs == null || relativeGlobs.isEmpty()) {
            return Collections.emptyList();
        }
        return JenkinsResultsParserUtil.toPathMatchers(JenkinsResultsParserUtil.getCanonicalPath(workingDirectory) + File.separator, JenkinsResultsParserUtil.getGlobsFromProperty(relativeGlobs));
    }

    protected List<String> getRelevantIntegrationUnitBatchList() {
        String relevantTestBatchNames;
        ArrayList<String> relevantIntegrationUnitBatchList = new ArrayList<String>();
        if (this.testSuiteName.equals("relevant") && (relevantTestBatchNames = this.getFirstPropertyValue("test.batch.names")) != null) {
            for (String relevantTestBatchName : relevantTestBatchNames.split(",")) {
                if (!relevantTestBatchName.startsWith("integration-") && !relevantTestBatchName.startsWith("modules-integration") && !relevantTestBatchName.startsWith("modules-unit") && !relevantTestBatchName.startsWith("unit-")) continue;
                relevantIntegrationUnitBatchList.add(relevantTestBatchName);
            }
        }
        return relevantIntegrationUnitBatchList;
    }

    protected List<PathMatcher> getRelevantIntegrationUnitIncludePathMatchers() {
        ArrayList<PathMatcher> relevantIntegrationUnitIncludePathMatchers = new ArrayList<PathMatcher>();
        List<String> relevantIntegrationUnitBatchList = this.getRelevantIntegrationUnitBatchList();
        if (!relevantIntegrationUnitBatchList.isEmpty()) {
            for (String relevantIntegrationUnitBatch : relevantIntegrationUnitBatchList) {
                String integrationUnitIncludesPropertyValue = this.getFirstPropertyValue("test.batch.class.names.includes", relevantIntegrationUnitBatch);
                if (integrationUnitIncludesPropertyValue == null) continue;
                relevantIntegrationUnitIncludePathMatchers.addAll(this.getPathMatchers(integrationUnitIncludesPropertyValue, this.portalGitWorkingDirectory.getWorkingDirectory()));
            }
        }
        return relevantIntegrationUnitIncludePathMatchers;
    }

    protected List<File> getRequiredModuleDirs(List<File> moduleDirs) {
        return this._getRequiredModuleDirs(moduleDirs, new ArrayList<File>(moduleDirs));
    }

    protected int getSegmentMaxChildren() {
        String segmentMaxChildren = this.getFirstPropertyValue("test.batch.segment.max.children");
        if (segmentMaxChildren == null || !segmentMaxChildren.matches("\\d+")) {
            return 25;
        }
        return Integer.valueOf(segmentMaxChildren);
    }

    protected boolean isIntegrationUnitTestFileModifiedOnly() {
        List<PathMatcher> relevantIntegrationUnitIncludePathMatchers = this.getRelevantIntegrationUnitIncludePathMatchers();
        List<File> modifiedFilesList = this.portalGitWorkingDirectory.getModifiedFilesList();
        if (relevantIntegrationUnitIncludePathMatchers.isEmpty() || modifiedFilesList.isEmpty()) {
            return false;
        }
        for (File modifiedFile : modifiedFilesList) {
            if (JenkinsResultsParserUtil.isFileIncluded(null, relevantIntegrationUnitIncludePathMatchers, modifiedFile)) continue;
            return false;
        }
        return true;
    }

    protected boolean isStableTestSuiteBatch() {
        return this.stableTestSuiteBatchNames.contains(this.batchName);
    }

    protected void setAxisTestClassGroups() {
        int testClassCount = this.testClasses.size();
        if (testClassCount == 0) {
            return;
        }
        int axisCount = this.getAxisCount();
        int axisSize = (int)Math.ceil((double)testClassCount / (double)axisCount);
        for (List axisTestClasses : Lists.partition((List)this.testClasses, (int)axisSize)) {
            AxisTestClassGroup axisTestClassGroup = TestClassGroupFactory.newAxisTestClassGroup(this);
            for (TestClassGroup.TestClass axisTestClass : axisTestClasses) {
                axisTestClassGroup.addTestClass(axisTestClass);
            }
            this.axisTestClassGroups.add(axisTestClassGroup);
        }
    }

    protected void setSegmentTestClassGroups() {
        if (!this._segmentTestClassGroups.isEmpty()) {
            return;
        }
        if (this.axisTestClassGroups.isEmpty()) {
            return;
        }
        HashMap<Integer, ArrayList<AxisTestClassGroup>> axisTestClassGroupsMap = new HashMap<Integer, ArrayList<AxisTestClassGroup>>();
        for (AxisTestClassGroup axisTestClassGroup : this.axisTestClassGroups) {
            Integer minimumSlaveRAM = axisTestClassGroup.getMinimumSlaveRAM();
            List axisTestClassGroups = (ArrayList<AxisTestClassGroup>)axisTestClassGroupsMap.get(minimumSlaveRAM);
            if (axisTestClassGroups == null) {
                axisTestClassGroups = new ArrayList<AxisTestClassGroup>();
            }
            axisTestClassGroups.add(axisTestClassGroup);
            axisTestClassGroupsMap.put(minimumSlaveRAM, (ArrayList<AxisTestClassGroup>)axisTestClassGroups);
        }
        for (List axisTestClassGroupsMapValue : axisTestClassGroupsMap.values()) {
            for (List axisTestClassGroups : Lists.partition((List)axisTestClassGroupsMapValue, (int)this.getSegmentMaxChildren())) {
                SegmentTestClassGroup segmentTestClassGroup = TestClassGroupFactory.newSegmentTestClassGroup(this);
                for (AxisTestClassGroup axisTestClassGroup : axisTestClassGroups) {
                    segmentTestClassGroup.addAxisTestClassGroup(axisTestClassGroup);
                }
                this._segmentTestClassGroups.add(segmentTestClassGroup);
            }
        }
    }

    private List<File> _getRequiredModuleDirs(List<File> moduleDirs, List<File> requiredModuleDirs) {
        File modulesBaseDir = new File(this.portalGitWorkingDirectory.getWorkingDirectory(), "modules");
        for (File moduleDir : moduleDirs) {
            Properties moduleDirTestProperties = JenkinsResultsParserUtil.getProperties(new File(moduleDir, "test.properties"));
            String requiredModuleDirPaths = moduleDirTestProperties.getProperty("modules.includes.required[" + this.testSuiteName + "]");
            if (requiredModuleDirPaths == null) continue;
            for (String requiredModuleDirPath : requiredModuleDirPaths.split(",")) {
                File requiredModuleDir = new File(modulesBaseDir, requiredModuleDirPath);
                if (!requiredModuleDir.exists() || requiredModuleDirs.contains(requiredModuleDir)) continue;
                requiredModuleDirs.add(requiredModuleDir);
            }
        }
        return Lists.newArrayList(requiredModuleDirs);
    }

    private void _setIncludeStableTestSuite() {
        this.includeStableTestSuite = this.testRelevantChanges;
    }

    private void _setTestReleaseBundle() {
        String propertyValue = this.getFirstPropertyValue("test.release.bundle");
        if (propertyValue != null) {
            this.testReleaseBundle = Boolean.parseBoolean(propertyValue);
            return;
        }
        this.testReleaseBundle = false;
    }

    private void _setTestRelevantChanges() {
        String propertyValue = this.getFirstPropertyValue("test.relevant.changes");
        if (propertyValue != null) {
            this.testRelevantChanges = Boolean.parseBoolean(propertyValue);
            return;
        }
        this.testRelevantChanges = false;
    }

    private void _setTestRelevantIntegrationUnitOnly() {
        if (this.testRelevantChanges && this.isIntegrationUnitTestFileModifiedOnly()) {
            this.testRelevantIntegrationUnitOnly = true;
            return;
        }
        this.testRelevantIntegrationUnitOnly = false;
    }

    protected static final class CSVReport {
        private List<Row> _csvReportRows = new ArrayList<Row>();

        public CSVReport(Row headerRow) {
            if (headerRow == null) {
                throw new IllegalArgumentException("headerRow is null");
            }
            this._csvReportRows.add(headerRow);
        }

        public void addRow(Row csvReportRow) {
            Row headerRow = this._csvReportRows.get(0);
            if (csvReportRow.size() != headerRow.size()) {
                throw new IllegalArgumentException("Row length does not match headers length");
            }
            this._csvReportRows.add(csvReportRow);
        }

        public String toString() {
            StringBuilder sb = null;
            for (Row csvReportRow : this._csvReportRows) {
                if (sb == null) {
                    sb = new StringBuilder();
                } else {
                    sb.append("\n");
                }
                sb.append(csvReportRow.toString());
            }
            return sb.toString();
        }

        protected static final class Row
        extends ArrayList<String> {
            public Row() {
            }

            public Row(String ... strings) {
                for (String string : strings) {
                    this.add(string);
                }
            }

            @Override
            public String toString() {
                return StringUtils.join(this.iterator(), (String)",");
            }
        }
    }

    public static enum BuildProfile {
        DXP{
            private static final String _TEXT = "dxp";

            public String toString() {
                return _TEXT;
            }
        }
        ,
        PORTAL{
            private static final String _TEXT = "portal";

            public String toString() {
                return _TEXT;
            }
        };

    }

    public static class BatchTestClass
    extends BaseTestClassGroup.BaseTestClass {
        protected static BatchTestClass getInstance(String batchName, PortalGitWorkingDirectory portalGitWorkingDirectory) {
            File testClassFile = new File(portalGitWorkingDirectory.getWorkingDirectory(), "build-test-batch.xml");
            return new BatchTestClass(batchName, testClassFile);
        }

        protected BatchTestClass(String batchName, File testClassFile) {
            super(testClassFile);
            this.addTestClassMethod(batchName);
        }
    }
}

