/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.spira;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.spira.PathSpiraArtifact;
import com.liferay.jenkins.results.parser.spira.SearchQuery;
import com.liferay.jenkins.results.parser.spira.SpiraProject;
import com.liferay.jenkins.results.parser.spira.SpiraRestAPIUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class SpiraTestSetFolder
extends PathSpiraArtifact {
    protected static final String ARTIFACT_TYPE_NAME = "testsetfolder";
    protected static final String KEY_ID = "TestSetFolderId";
    private SpiraTestSetFolder _parentSpiraTestSetFolder;

    public static SpiraTestSetFolder createSpiraTestSetFolder(SpiraProject spiraProject, String testSetFolderName) {
        return SpiraTestSetFolder.createSpiraTestSetFolder(spiraProject, testSetFolderName, null);
    }

    public static SpiraTestSetFolder createSpiraTestSetFolder(SpiraProject spiraProject, String testSetFolderName, Integer parentTestSetFolderID) {
        List<SpiraTestSetFolder> spiraTestSetFolders;
        SpiraTestSetFolder parentSpiraTestSetFolder;
        String testSetFolderPath = "/" + testSetFolderName;
        if (parentTestSetFolderID != null && (parentSpiraTestSetFolder = spiraProject.getSpiraTestSetFolderByID(parentTestSetFolderID)) != null) {
            testSetFolderPath = parentSpiraTestSetFolder.getPath() + "/" + testSetFolderName;
        }
        if (!(spiraTestSetFolders = spiraProject.getSpiraTestSetFoldersByPath(testSetFolderPath)).isEmpty()) {
            return spiraTestSetFolders.get(0);
        }
        String urlPath = "projects/{project_id}/test-set-folders";
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
        JSONObject requestJSONObject = new JSONObject();
        requestJSONObject.put("Name", (Object)StringEscapeUtils.unescapeJava((String)testSetFolderName));
        requestJSONObject.put("ParentTestSetFolderId", (Object)parentTestSetFolderID);
        try {
            JSONObject responseJSONObject = SpiraRestAPIUtil.requestJSONObject(urlPath, null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.POST, requestJSONObject.toString());
            return spiraProject.getSpiraTestSetFolderByID(responseJSONObject.getInt(KEY_ID));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public static SpiraTestSetFolder createSpiraTestSetFolderByPath(SpiraProject spiraProject, String testSetFolderPath) {
        List<SpiraTestSetFolder> spiraTestSetFolders = spiraProject.getSpiraTestSetFoldersByPath(testSetFolderPath);
        if (!spiraTestSetFolders.isEmpty()) {
            return spiraTestSetFolders.get(0);
        }
        String testSetFolderName = SpiraTestSetFolder.getPathName(testSetFolderPath);
        String parentTestSetFolderPath = SpiraTestSetFolder.getParentPath(testSetFolderPath);
        if (parentTestSetFolderPath.isEmpty()) {
            return SpiraTestSetFolder.createSpiraTestSetFolder(spiraProject, testSetFolderName);
        }
        SpiraTestSetFolder parentSpiraTestSetFolder = SpiraTestSetFolder.createSpiraTestSetFolderByPath(spiraProject, parentTestSetFolderPath);
        return SpiraTestSetFolder.createSpiraTestSetFolder(spiraProject, testSetFolderName, parentSpiraTestSetFolder.getID());
    }

    public static void deleteSpiraTestSetFolderByID(SpiraProject spiraProject, int testSetFolderID) {
        List<SpiraTestSetFolder> spiraTestSetFolders = SpiraTestSetFolder.getSpiraTestSetFolders(spiraProject, new SearchQuery.SearchParameter(KEY_ID, testSetFolderID));
        if (spiraTestSetFolders.isEmpty()) {
            return;
        }
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
        urlPathReplacements.put("test_set_folder_id", String.valueOf(testSetFolderID));
        try {
            SpiraRestAPIUtil.request("projects/{project_id}/test-set-folders/{test_set_folder_id}", null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.DELETE, null);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        SpiraTestSetFolder.removeCachedSpiraArtifacts(SpiraTestSetFolder.class, spiraTestSetFolders);
    }

    public static void deleteSpiraTestSetFoldersByPath(SpiraProject spiraProject, String testSetFolderPath) {
        List<SpiraTestSetFolder> spiraTestSetFolders = spiraProject.getSpiraTestSetFoldersByPath(testSetFolderPath);
        for (SpiraTestSetFolder spiraTestSetFolder : spiraTestSetFolders) {
            SpiraTestSetFolder.deleteSpiraTestSetFolderByID(spiraProject, spiraTestSetFolder.getID());
        }
    }

    public SpiraTestSetFolder getParentSpiraTestSetFolder() {
        if (this._parentSpiraTestSetFolder != null) {
            return this._parentSpiraTestSetFolder;
        }
        Object parentTestSetFolderID = this.jsonObject.get("ParentTestSetFolderId");
        if (parentTestSetFolderID == JSONObject.NULL) {
            return null;
        }
        if (!(parentTestSetFolderID instanceof Integer)) {
            return null;
        }
        SpiraProject spiraProject = this.getSpiraProject();
        this._parentSpiraTestSetFolder = spiraProject.getSpiraTestSetFolderByID((Integer)parentTestSetFolderID);
        return this._parentSpiraTestSetFolder;
    }

    @Override
    public String getURL() {
        SpiraProject spiraProject = this.getSpiraProject();
        return JenkinsResultsParserUtil.combine("https://liferay.spiraservice.net/", String.valueOf(spiraProject.getID()), "/TestSet/List/", String.valueOf(this.getID()), ".aspx");
    }

    protected static List<SpiraTestSetFolder> getSpiraTestSetFolders(final SpiraProject spiraProject, SearchQuery.SearchParameter ... searchParameters) {
        return SpiraTestSetFolder.getSpiraArtifacts(SpiraTestSetFolder.class, new Supplier<List<JSONObject>>(){

            @Override
            public List<JSONObject> get() {
                return SpiraTestSetFolder._requestSpiraTestSetFolders(spiraProject);
            }
        }, new Function<JSONObject, SpiraTestSetFolder>(){

            @Override
            public SpiraTestSetFolder apply(JSONObject jsonObject) {
                return new SpiraTestSetFolder(jsonObject);
            }
        }, searchParameters);
    }

    @Override
    protected PathSpiraArtifact getParentSpiraArtifact() {
        return this.getParentSpiraTestSetFolder();
    }

    private static List<JSONObject> _requestSpiraTestSetFolders(SpiraProject spiraProject) {
        ArrayList<JSONObject> spiraTestSetFolders = new ArrayList<JSONObject>();
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
        try {
            JSONArray responseJSONArray = SpiraRestAPIUtil.requestJSONArray("projects/{project_id}/test-set-folders", null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.GET, null);
            for (int i = 0; i < responseJSONArray.length(); ++i) {
                JSONObject responseJSONObject = responseJSONArray.getJSONObject(i);
                responseJSONObject.put("ProjectId", spiraProject.getID());
                spiraTestSetFolders.add(responseJSONObject);
            }
            return spiraTestSetFolders;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private SpiraTestSetFolder(JSONObject jsonObject) {
        super(jsonObject);
        SpiraTestSetFolder.cacheSpiraArtifact(SpiraTestSetFolder.class, this);
    }
}

