/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.spira;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.spira.BaseSpiraArtifact;
import com.liferay.jenkins.results.parser.spira.PathSpiraArtifact;
import com.liferay.jenkins.results.parser.spira.SearchQuery;
import com.liferay.jenkins.results.parser.spira.SpiraProject;
import com.liferay.jenkins.results.parser.spira.SpiraRestAPIUtil;
import com.liferay.jenkins.results.parser.spira.SpiraTestCaseObject;
import com.liferay.jenkins.results.parser.spira.SpiraTestSetFolder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class SpiraTestSet
extends PathSpiraArtifact {
    protected static final String ARTIFACT_TYPE_NAME = "testset";
    protected static final String KEY_ID = "TestSetId";
    private SpiraTestSetFolder _parentSpiraTestSetFolder;
    private Map<Integer, SpiraTestSetTestCase> _spiraTestSetTestCases = Collections.synchronizedMap(new HashMap());

    public static SpiraTestSet createSpiraTestSet(SpiraProject spiraProject, String testSetName, String testSetDescription) {
        return SpiraTestSet._createSpiraTestSet(spiraProject, testSetName, testSetDescription, null);
    }

    public static SpiraTestSet createSpiraTestSet(SpiraProject spiraProject, String testSetName, String testSetDescription, Integer parentTestSetFolderID) {
        return SpiraTestSet._createSpiraTestSet(spiraProject, testSetName, testSetDescription, parentTestSetFolderID);
    }

    public static SpiraTestSet createSpiraTestSetByPath(SpiraProject spiraProject, String testSetPath, String testSetDescription) {
        List<SpiraTestSet> spiraTestSets = spiraProject.getSpiraTestSetsByPath(testSetPath);
        if (!spiraTestSets.isEmpty()) {
            return spiraTestSets.get(0);
        }
        String testSetName = SpiraTestSet.getPathName(testSetPath);
        String parentTestSetFolderPath = SpiraTestSet.getParentPath(testSetPath);
        if (parentTestSetFolderPath.isEmpty()) {
            return SpiraTestSet.createSpiraTestSet(spiraProject, testSetName, testSetDescription);
        }
        SpiraTestSetFolder parentSpiraTestSetFolder = SpiraTestSetFolder.createSpiraTestSetFolderByPath(spiraProject, parentTestSetFolderPath);
        return SpiraTestSet.createSpiraTestSet(spiraProject, testSetName, testSetDescription, parentSpiraTestSetFolder.getID());
    }

    public SpiraTestSetFolder getParentSpiraTestSetFolder() {
        if (this._parentSpiraTestSetFolder != null) {
            return this._parentSpiraTestSetFolder;
        }
        Object testSetFolderID = this.jsonObject.get("TestSetFolderId");
        if (testSetFolderID == JSONObject.NULL) {
            return null;
        }
        if (!(testSetFolderID instanceof Integer)) {
            return null;
        }
        SpiraProject spiraProject = this.getSpiraProject();
        this._parentSpiraTestSetFolder = spiraProject.getSpiraTestSetFolderByID((Integer)testSetFolderID);
        return this._parentSpiraTestSetFolder;
    }

    @Override
    public String getURL() {
        SpiraProject spiraProject = this.getSpiraProject();
        return JenkinsResultsParserUtil.combine("https://liferay.spiraservice.net/", String.valueOf(spiraProject.getID()), "/TestSet/", String.valueOf(this.getID()), ".aspx");
    }

    protected static List<SpiraTestSet> getSpiraTestSets(final SpiraProject spiraProject, final SearchQuery.SearchParameter ... searchParameters) {
        return SpiraTestSet.getSpiraArtifacts(SpiraTestSet.class, new Supplier<List<JSONObject>>(){

            @Override
            public List<JSONObject> get() {
                return SpiraTestSet._requestSpiraTestSets(spiraProject, searchParameters);
            }
        }, new Function<JSONObject, SpiraTestSet>(){

            @Override
            public SpiraTestSet apply(JSONObject jsonObject) {
                return new SpiraTestSet(jsonObject);
            }
        }, searchParameters);
    }

    protected SpiraTestSetTestCase assignSpiraTestCaseObject(SpiraTestCaseObject spiraTestCaseObject) {
        if (this._spiraTestSetTestCases.containsKey(spiraTestCaseObject.getID())) {
            return this._spiraTestSetTestCases.get(spiraTestCaseObject.getID());
        }
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        SpiraProject spiraProject = this.getSpiraProject();
        urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
        urlPathReplacements.put("test_case_id", String.valueOf(spiraTestCaseObject.getID()));
        urlPathReplacements.put("test_set_id", String.valueOf(this.getID()));
        JSONArray requestJSONArray = new JSONArray();
        try {
            JSONArray responseJSONArray = SpiraRestAPIUtil.requestJSONArray("projects/{project_id}/test-sets/{test_set_id}/test-case-mapping/{test_case_id}", null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.POST, requestJSONArray.toString());
            int i = 0;
            if (i < responseJSONArray.length()) {
                SpiraTestSetTestCase spiraTestSetTestCase = new SpiraTestSetTestCase(responseJSONArray.getJSONObject(i));
                this._spiraTestSetTestCases.put(spiraTestSetTestCase.getTestCaseID(), spiraTestSetTestCase);
                return spiraTestSetTestCase;
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return null;
    }

    @Override
    protected PathSpiraArtifact getParentSpiraArtifact() {
        return this.getParentSpiraTestSetFolder();
    }

    private static SpiraTestSet _createSpiraTestSet(SpiraProject spiraProject, String testSetName, String testSetDescription, Integer parentTestSetFolderID) {
        List<SpiraTestSet> spiraTestSets = SpiraTestSet.getSpiraTestSets(spiraProject, new SearchQuery.SearchParameter("Name", testSetName), new SearchQuery.SearchParameter("TestCaseFolderId", parentTestSetFolderID));
        if (!spiraTestSets.isEmpty()) {
            return spiraTestSets.get(0);
        }
        String urlPath = "projects/{project_id}/test-sets";
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
        JSONObject requestJSONObject = new JSONObject();
        requestJSONObject.put("Name", (Object)StringEscapeUtils.unescapeJava((String)testSetName));
        requestJSONObject.put("TestRunTypeId", (Object)TestRunType.AUTOMATED.getID());
        requestJSONObject.put("TestSetStatusId", (Object)Status.IN_PROGRESS.getID());
        if (parentTestSetFolderID != null && parentTestSetFolderID != 0) {
            requestJSONObject.put("TestSetFolderId", (Object)parentTestSetFolderID);
        }
        if (testSetDescription == null) {
            testSetDescription = "";
        }
        requestJSONObject.put("Description", (Object)StringEscapeUtils.unescapeJava((String)testSetDescription));
        try {
            JSONObject responseJSONObject = SpiraRestAPIUtil.requestJSONObject(urlPath, null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.POST, requestJSONObject.toString());
            return spiraProject.getSpiraTestSetByID(responseJSONObject.getInt(KEY_ID));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private static List<JSONObject> _requestSpiraTestSets(SpiraProject spiraProject, SearchQuery.SearchParameter ... searchParameters) {
        ArrayList<JSONObject> spiraTestSetFolders = new ArrayList<JSONObject>();
        HashMap<String, String> urlParameters = new HashMap<String, String>();
        urlParameters.put("number_of_rows", String.valueOf(15000));
        urlParameters.put("release_id", null);
        urlParameters.put("sort_direction", "ASC");
        urlParameters.put("sort_field", KEY_ID);
        urlParameters.put("starting_row", String.valueOf(1));
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
        JSONArray requestJSONArray = new JSONArray();
        for (SearchQuery.SearchParameter searchParameter : searchParameters) {
            requestJSONArray.put((Object)searchParameter.toFilterJSONObject());
        }
        try {
            JSONArray responseJSONArray = SpiraRestAPIUtil.requestJSONArray("projects/{project_id}/test-sets/search", urlParameters, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.POST, requestJSONArray.toString());
            for (int i = 0; i < responseJSONArray.length(); ++i) {
                JSONObject responseJSONObject = responseJSONArray.getJSONObject(i);
                responseJSONObject.put("ProjectId", spiraProject.getID());
                spiraTestSetFolders.add(responseJSONObject);
            }
            return spiraTestSetFolders;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private SpiraTestSet(JSONObject jsonObject) {
        super(jsonObject);
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        SpiraProject spiraProject = this.getSpiraProject();
        urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
        urlPathReplacements.put("test_set_id", String.valueOf(this.getID()));
        try {
            JSONArray responseJSONArray = SpiraRestAPIUtil.requestJSONArray("projects/{project_id}/test-sets/{test_set_id}/test-cases", null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.GET, null);
            for (int i = 0; i < responseJSONArray.length(); ++i) {
                SpiraTestSetTestCase spiraTestSetTestCase = new SpiraTestSetTestCase(responseJSONArray.getJSONObject(i));
                this._spiraTestSetTestCases.put(spiraTestSetTestCase.getTestCaseID(), spiraTestSetTestCase);
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        SpiraTestSet.cacheSpiraArtifact(SpiraTestSet.class, this);
    }

    protected static class SpiraTestSetTestCase
    extends BaseSpiraArtifact {
        protected static final String KEY_ID = "TestSetTestCaseId";

        @Override
        public String getURL() {
            SpiraTestCaseObject spiraTestCaseObject = this.getSpiraTestCaseObject();
            return spiraTestCaseObject.getURL();
        }

        protected SpiraTestCaseObject getSpiraTestCaseObject() {
            SpiraProject spiraProject = this.getSpiraProject();
            return spiraProject.getSpiraTestCaseObjectByID(this.getTestCaseID());
        }

        protected Integer getTestCaseID() {
            return this.jsonObject.getInt("TestCaseId");
        }

        private SpiraTestSetTestCase(JSONObject jsonObject) {
            super(jsonObject);
        }
    }

    public static enum TestRunType {
        AUTOMATED(2),
        MANUAL(1);

        private final Integer _id;

        public Integer getID() {
            return this._id;
        }

        private TestRunType(Integer id) {
            this._id = id;
        }
    }

    public static enum Status {
        BLOCKED(4),
        COMPLETED(3),
        DEFERRED(5),
        IN_PROGRESS(2),
        NOT_STARTED(1);

        private final Integer _id;

        public Integer getID() {
            return this._id;
        }

        private Status(Integer id) {
            this._id = id;
        }
    }
}

