/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.spira;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.spira.BaseSpiraArtifact;
import com.liferay.jenkins.results.parser.spira.SearchQuery;
import com.liferay.jenkins.results.parser.spira.SpiraProject;
import com.liferay.jenkins.results.parser.spira.SpiraRestAPIUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.json.JSONArray;
import org.json.JSONObject;

public class SpiraTestCaseType
extends BaseSpiraArtifact {
    protected static final String ARTIFACT_TYPE_NAME = "testcasetype";
    protected static final String KEY_ID = "TestCaseTypeId";

    @Override
    public String getURL() {
        SpiraProject spiraProject = this.getSpiraProject();
        return JenkinsResultsParserUtil.combine("https://liferay.spiraservice.net/", "/pt/", String.valueOf(spiraProject.getProjectTemplateID()), "/Administration/TestCaseTypes.aspx");
    }

    protected static List<SpiraTestCaseType> getSpiraTestCaseTypes(final SpiraProject spiraProject, SearchQuery.SearchParameter ... searchParameters) {
        return SpiraTestCaseType.getSpiraArtifacts(SpiraTestCaseType.class, new Supplier<List<JSONObject>>(){

            @Override
            public List<JSONObject> get() {
                return SpiraTestCaseType._requestSpiraTestCaseTypes(spiraProject);
            }
        }, new Function<JSONObject, SpiraTestCaseType>(){

            @Override
            public SpiraTestCaseType apply(JSONObject jsonObject) {
                return new SpiraTestCaseType(jsonObject);
            }
        }, searchParameters);
    }

    private static List<JSONObject> _requestSpiraTestCaseTypes(SpiraProject spiraProject) {
        ArrayList<JSONObject> spiraTestCaseTypes = new ArrayList<JSONObject>();
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("project_template_id", String.valueOf(spiraProject.getProjectTemplateID()));
        try {
            JSONArray responseJSONArray = SpiraRestAPIUtil.requestJSONArray("project-templates/{project_template_id}/test-cases/types", null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.GET, null);
            for (int i = 0; i < responseJSONArray.length(); ++i) {
                JSONObject responseJSONObject = responseJSONArray.getJSONObject(i);
                responseJSONObject.put("ProjectId", spiraProject.getID());
                spiraTestCaseTypes.add(responseJSONObject);
            }
            return spiraTestCaseTypes;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private SpiraTestCaseType(JSONObject jsonObject) {
        super(jsonObject);
        SpiraTestCaseType.cacheSpiraArtifact(SpiraTestCaseType.class, this);
    }
}

