/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.spira;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.ParallelExecutor;
import com.liferay.jenkins.results.parser.spira.BaseSpiraArtifact;
import com.liferay.jenkins.results.parser.spira.MultiListSpiraCustomPropertyValue;
import com.liferay.jenkins.results.parser.spira.PathSpiraArtifact;
import com.liferay.jenkins.results.parser.spira.SearchQuery;
import com.liferay.jenkins.results.parser.spira.SpiraAutomationHost;
import com.liferay.jenkins.results.parser.spira.SpiraCustomListValue;
import com.liferay.jenkins.results.parser.spira.SpiraCustomProperty;
import com.liferay.jenkins.results.parser.spira.SpiraCustomPropertyValue;
import com.liferay.jenkins.results.parser.spira.SpiraProject;
import com.liferay.jenkins.results.parser.spira.SpiraRelease;
import com.liferay.jenkins.results.parser.spira.SpiraReleaseBuild;
import com.liferay.jenkins.results.parser.spira.SpiraRestAPIUtil;
import com.liferay.jenkins.results.parser.spira.SpiraTestCaseObject;
import com.liferay.jenkins.results.parser.spira.SpiraTestSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import org.json.JSONArray;
import org.json.JSONObject;

public class SpiraTestCaseRun
extends BaseSpiraArtifact {
    protected static final Integer ARTIFACT_TYPE_ID = 5;
    protected static final String ARTIFACT_TYPE_NAME = "testrun";
    protected static final String KEY_ID = "TestRunId";
    private JSONObject _automatedJSONObject;

    public static void clearCachedSpiraTestCaseRuns() {
        SpiraTestCaseRun.clearCachedSpiraArtifacts(SpiraTestCaseRun.class);
    }

    public static void deleteSpiraTestCaseRuns(List<SpiraTestCaseRun> spiraTestCaseRuns) {
        for (SpiraTestCaseRun spiraTestCaseRun : spiraTestCaseRuns) {
            HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
            SpiraProject spiraProject = spiraTestCaseRun.getSpiraProject();
            urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
            urlPathReplacements.put("test_run_id", String.valueOf(spiraTestCaseRun.getID()));
            try {
                SpiraRestAPIUtil.request("projects/{project_id}/test-runs/{test_run_id}", null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.DELETE, null);
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }
    }

    public static List<SpiraTestCaseRun> recordSpiraTestCaseRuns(SpiraProject spiraProject, SpiraRelease spiraRelease, SpiraReleaseBuild spiraReleaseBuild, SpiraTestSet spiraTestSet, List<Result> results) {
        Integer releaseID = null;
        if (spiraRelease != null) {
            releaseID = spiraRelease.getID();
        }
        Integer releaseBuildID = null;
        if (spiraReleaseBuild != null) {
            releaseBuildID = spiraReleaseBuild.getID();
        }
        Integer testSetID = null;
        if (spiraTestSet != null) {
            testSetID = spiraTestSet.getID();
        }
        Calendar calendar = Calendar.getInstance();
        JSONArray requestJSONArray = new JSONArray();
        for (Result result : results) {
            JSONObject requestJSONObject = new JSONObject();
            SpiraAutomationHost spiraAutomationHost = result.getSpiraAutomationHost();
            requestJSONObject.put("AutomationHostId", spiraAutomationHost.getID());
            SpiraTestCaseObject spiraTestCaseObject = result.getSpiraTestCaseObject();
            requestJSONObject.put("TestCaseId", spiraTestCaseObject.getID());
            requestJSONObject.put("CustomProperties", (Object)result.getCustomPropertyValuesJSONArray());
            requestJSONObject.put("ExecutionStatusId", (Object)result.getStatusID());
            requestJSONObject.put("RunnerMessage", (Object)spiraTestCaseObject.getName());
            requestJSONObject.put("RunnerName", (Object)"Liferay CI");
            requestJSONObject.put("RunnerStackTrace", (Object)result.getDescription());
            requestJSONObject.put("RunnerTestName", (Object)spiraTestCaseObject.getName());
            requestJSONObject.put("StartDate", (Object)PathSpiraArtifact.toDateString(calendar));
            requestJSONObject.put("TestRunFormatId", (Object)result.getRunnerFormatID());
            if (releaseID != null) {
                requestJSONObject.put("ReleaseId", (Object)releaseID);
            }
            if (releaseBuildID != null) {
                requestJSONObject.put("BuildId", (Object)releaseBuildID);
            }
            if (testSetID != null) {
                requestJSONObject.put("TestSetId", (Object)testSetID);
                SpiraTestSet.SpiraTestSetTestCase spiraTestSetTestCase = spiraTestSet.assignSpiraTestCaseObject(spiraTestCaseObject);
                requestJSONObject.put("TestSetTestCaseId", spiraTestSetTestCase.getID());
            }
            requestJSONArray.put((Object)requestJSONObject);
        }
        String urlPath = "projects/{project_id}/test-runs/record-multiple";
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
        try {
            JSONArray responseJSONArray = SpiraRestAPIUtil.requestJSONArray(urlPath, null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.POST, requestJSONArray.toString());
            ArrayList<SpiraTestCaseRun> spiraTestCaseRuns = new ArrayList<SpiraTestCaseRun>();
            for (int i = 0; i < responseJSONArray.length(); ++i) {
                JSONObject responseJSONObject = responseJSONArray.getJSONObject(i);
                responseJSONObject.put("ProjectId", spiraProject.getID());
                spiraTestCaseRuns.add(new SpiraTestCaseRun(responseJSONObject));
            }
            return spiraTestCaseRuns;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public static List<SpiraTestCaseRun> recordSpiraTestCaseRuns(final SpiraProject spiraProject, final SpiraRelease spiraRelease, final SpiraReleaseBuild spiraReleaseBuild, final SpiraTestSet spiraTestSet, List<Result> results, Integer resultGroupSize, Integer threadCount) {
        if (results.size() < resultGroupSize) {
            return SpiraTestCaseRun.recordSpiraTestCaseRuns(spiraProject, spiraRelease, spiraReleaseBuild, spiraTestSet, results);
        }
        ArrayList callables = new ArrayList();
        int resultCount = results.size();
        int resultGroupCount = resultCount / resultGroupSize;
        if (resultCount % resultGroupSize > 0) {
            ++resultGroupCount;
        }
        for (int i = 0; i < resultGroupCount; ++i) {
            int resultGroupStart = i * resultGroupSize;
            int resultGroupEnd = (i + 1) * resultGroupSize - 1;
            if (resultGroupEnd > resultCount) {
                resultGroupEnd = resultCount;
            }
            final List<Result> resultGroup = results.subList(resultGroupStart, resultGroupEnd);
            IndexedCallable<List<SpiraTestCaseRun>> callable = new IndexedCallable<List<SpiraTestCaseRun>>(Integer.valueOf(i)){

                @Override
                public List<SpiraTestCaseRun> safeCall() {
                    long start = System.currentTimeMillis();
                    String startString = JenkinsResultsParserUtil.toDateString(new Date(start), "America/Los_Angeles");
                    this.print("Starting at " + startString);
                    for (Result result : resultGroup) {
                        result.initSpiraTestCaseObject();
                    }
                    List<SpiraTestCaseRun> spiraTestCaseRuns = SpiraTestCaseRun.recordSpiraTestCaseRuns(spiraProject, spiraRelease, spiraReleaseBuild, spiraTestSet, resultGroup);
                    String durationString = JenkinsResultsParserUtil.toDurationString(System.currentTimeMillis() - start);
                    this.print("Completed in " + durationString);
                    return spiraTestCaseRuns;
                }
            };
            callables.add(callable);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Recording results for ");
        sb.append(resultGroupCount);
        sb.append(" groups of ");
        sb.append(resultGroupSize);
        sb.append(" in ");
        sb.append(threadCount);
        sb.append(" threads.");
        System.out.println(sb.toString());
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, JenkinsResultsParserUtil.getNewThreadPoolExecutor(threadCount, true));
        ArrayList<SpiraTestCaseRun> spiraTestCaseRuns = new ArrayList<SpiraTestCaseRun>();
        for (List spiraTestCaseRunList : parallelExecutor.execute()) {
            spiraTestCaseRuns.addAll(spiraTestCaseRunList);
        }
        return spiraTestCaseRuns;
    }

    public JSONObject getAutomatedJSONObject() {
        if (this._automatedJSONObject != null) {
            return this._automatedJSONObject;
        }
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        SpiraProject spiraProject = this.getSpiraProject();
        urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
        urlPathReplacements.put("test_run_id", String.valueOf(this.getID()));
        try {
            this._automatedJSONObject = SpiraRestAPIUtil.requestJSONObject("projects/{project_id}/test-runs/{test_run_id}/automated", null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.GET, null);
            return this._automatedJSONObject;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public String getURL() {
        SpiraProject spiraProject = this.getSpiraProject();
        return JenkinsResultsParserUtil.combine("https://liferay.spiraservice.net/", String.valueOf(spiraProject.getID()), "/TestRun/", String.valueOf(this.getID()), ".aspx");
    }

    protected static List<SpiraTestCaseRun> getSpiraTestCaseRuns(final SpiraProject spiraProject, final SpiraTestCaseObject spiraTestCase, final SearchQuery.SearchParameter ... searchParameters) {
        ArrayList<SearchQuery.SearchParameter> searchParameterList = new ArrayList<SearchQuery.SearchParameter>();
        Collections.addAll(searchParameterList, searchParameters);
        searchParameterList.add(new SearchQuery.SearchParameter("TestCaseId", spiraTestCase.getID()));
        return SpiraTestCaseRun.getSpiraArtifacts(SpiraTestCaseRun.class, new Supplier<List<JSONObject>>(){

            @Override
            public List<JSONObject> get() {
                return SpiraTestCaseRun._requestSpiraTestCaseRuns(spiraProject, spiraTestCase, searchParameters);
            }
        }, new Function<JSONObject, SpiraTestCaseRun>(){

            @Override
            public SpiraTestCaseRun apply(JSONObject jsonObject) {
                return new SpiraTestCaseRun(jsonObject);
            }
        }, searchParameterList.toArray(new SearchQuery.SearchParameter[0]));
    }

    private static List<JSONObject> _requestSpiraTestCaseRuns(SpiraProject spiraProject, SpiraTestCaseObject spiraTestCase, SearchQuery.SearchParameter ... searchParameters) {
        HashMap<String, String> urlParameters = new HashMap<String, String>();
        urlParameters.put("number_of_rows", String.valueOf(1000));
        urlParameters.put("sort_direction", "DESC");
        urlParameters.put("sort_field", KEY_ID);
        urlParameters.put("starting_row", String.valueOf(1));
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
        urlPathReplacements.put("test_case_id", String.valueOf(spiraTestCase.getID()));
        JSONArray requestJSONArray = new JSONArray();
        for (SearchQuery.SearchParameter searchParameter : searchParameters) {
            requestJSONArray.put((Object)searchParameter.toFilterJSONObject());
        }
        try {
            JSONArray responseJSONArray = SpiraRestAPIUtil.requestJSONArray("projects/{project_id}/test-cases/{test_case_id}/test-runs/search", urlParameters, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.POST, requestJSONArray.toString());
            ArrayList<JSONObject> spiraTestCaseRuns = new ArrayList<JSONObject>();
            for (int i = 0; i < responseJSONArray.length(); ++i) {
                JSONObject responseJSONObject = responseJSONArray.getJSONObject(i);
                responseJSONObject.put("ProjectId", spiraProject.getID());
                spiraTestCaseRuns.add(responseJSONObject);
            }
            return spiraTestCaseRuns;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private SpiraTestCaseRun(JSONObject jsonObject) {
        super(jsonObject);
        SpiraTestCaseRun.cacheSpiraArtifact(SpiraTestCaseRun.class, this);
    }

    private static abstract class IndexedCallable<T>
    implements Callable<T> {
        private final Integer _index;

        @Override
        public final T call() {
            try {
                return this.safeCall();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        public abstract T safeCall();

        protected IndexedCallable(Integer index) {
            this._index = index;
        }

        protected Integer getIndex() {
            return this._index;
        }

        protected void print(String s) {
            System.out.println(JenkinsResultsParserUtil.combine("[thread_" + this.getIndex(), "] ", s));
        }
    }

    public static enum Status {
        BLOCKED(5),
        CAUTION(6),
        FAILED(1),
        NOT_APPLICABLE(4),
        NOT_RUN(3),
        PASSED(2);

        private final Integer _id;

        public Integer getID() {
            return this._id;
        }

        private Status(Integer id) {
            this._id = id;
        }
    }

    public static enum RunnerFormat {
        HTML(2),
        PLAIN(1);

        private final Integer _id;

        public Integer getID() {
            return this._id;
        }

        private RunnerFormat(Integer id) {
            this._id = id;
        }
    }

    public static class Result
    implements Serializable {
        private final String _description;
        private final Long _duration;
        private final RunnerFormat _runnerFormat;
        private final SpiraAutomationHost _spiraAutomationHost;
        private final List<SpiraCustomPropertyValue> _spiraCustomPropertyValues;
        private SpiraTestCaseObject _spiraTestCaseObject;
        private transient Supplier<SpiraTestCaseObject> _spiraTestCaseObjectSupplier;
        private final Status _status;

        public Result(SpiraTestCaseObject spiraTestCaseObject, SpiraAutomationHost spiraAutomationHost, RunnerFormat runnerFormat, String runnerStackTrace, long duration, Status status, List<SpiraCustomPropertyValue> spiraCustomPropertyValues) {
            this._spiraTestCaseObject = spiraTestCaseObject;
            this._spiraAutomationHost = spiraAutomationHost;
            this._runnerFormat = runnerFormat;
            this._description = runnerStackTrace;
            this._duration = duration;
            this._status = status;
            this._spiraCustomPropertyValues = spiraCustomPropertyValues;
        }

        public Result(Supplier<SpiraTestCaseObject> spiraTestCaseObjectSupplier, SpiraAutomationHost spiraAutomationHost, RunnerFormat runnerFormat, String runnerStackTrace, long duration, Status status, List<SpiraCustomPropertyValue> spiraCustomPropertyValues) {
            this._spiraTestCaseObjectSupplier = spiraTestCaseObjectSupplier;
            this._spiraAutomationHost = spiraAutomationHost;
            this._runnerFormat = runnerFormat;
            this._description = runnerStackTrace;
            this._duration = duration;
            this._status = status;
            this._spiraCustomPropertyValues = spiraCustomPropertyValues;
        }

        public JSONArray getCustomPropertyValuesJSONArray() {
            JSONArray customPropertyValuesJSONArray = new JSONArray();
            if (this._spiraCustomPropertyValues == null) {
                return customPropertyValuesJSONArray;
            }
            for (SpiraCustomPropertyValue spiraCustomPropertyValue : this._spiraCustomPropertyValues) {
                if (spiraCustomPropertyValue instanceof MultiListSpiraCustomPropertyValue) {
                    this._putMultiListSpiraCustomPropertyValue(customPropertyValuesJSONArray, (MultiListSpiraCustomPropertyValue)spiraCustomPropertyValue);
                    continue;
                }
                customPropertyValuesJSONArray.put((Object)spiraCustomPropertyValue.getCustomPropertyJSONObject());
            }
            customPropertyValuesJSONArray.put((Object)this._getDurationJSONObject());
            customPropertyValuesJSONArray.put((Object)this._getDurationStringJSONObject());
            return customPropertyValuesJSONArray;
        }

        public String getDescription() {
            return this._description;
        }

        public Integer getRunnerFormatID() {
            return this._runnerFormat.getID();
        }

        public SpiraAutomationHost getSpiraAutomationHost() {
            return this._spiraAutomationHost;
        }

        public SpiraProject getSpiraProject() {
            SpiraTestCaseObject spiraTestCaseObject = this.getSpiraTestCaseObject();
            return spiraTestCaseObject.getSpiraProject();
        }

        public SpiraTestCaseObject getSpiraTestCaseObject() {
            this.initSpiraTestCaseObject();
            return this._spiraTestCaseObject;
        }

        public Integer getStatusID() {
            return this._status.getID();
        }

        public void initSpiraTestCaseObject() {
            if (this._spiraTestCaseObject != null) {
                return;
            }
            if (this._spiraTestCaseObjectSupplier == null) {
                return;
            }
            this._spiraTestCaseObject = this._spiraTestCaseObjectSupplier.get();
        }

        private JSONObject _getDurationJSONObject() {
            SpiraCustomProperty spiraCustomProperty = SpiraCustomProperty.createSpiraCustomProperty(this.getSpiraProject(), SpiraTestCaseRun.class, "Duration", SpiraCustomProperty.Type.INTEGER);
            Integer duration = this._duration.intValue();
            if (this._duration > Integer.MAX_VALUE) {
                duration = Integer.MAX_VALUE;
            }
            SpiraCustomPropertyValue<?> spiraCustomPropertyValue = SpiraCustomPropertyValue.createSpiraCustomPropertyValue(spiraCustomProperty, String.valueOf(duration));
            return spiraCustomPropertyValue.getCustomPropertyJSONObject();
        }

        private JSONObject _getDurationStringJSONObject() {
            SpiraCustomProperty spiraCustomProperty = SpiraCustomProperty.createSpiraCustomProperty(this.getSpiraProject(), SpiraTestCaseRun.class, "Duration String", SpiraCustomProperty.Type.TEXT);
            SpiraCustomPropertyValue<?> spiraCustomPropertyValue = SpiraCustomPropertyValue.createSpiraCustomPropertyValue(spiraCustomProperty, JenkinsResultsParserUtil.toDurationString(this._duration));
            return spiraCustomPropertyValue.getCustomPropertyJSONObject();
        }

        private void _putMultiListSpiraCustomPropertyValue(JSONArray customPropertyValuesJSONArray, MultiListSpiraCustomPropertyValue multiListSpiraCustomPropertyValue) {
            JSONArray integerListValueJSONArray;
            JSONObject customPropertyValueJSONObject = null;
            int propertyNumber = multiListSpiraCustomPropertyValue.getPropertyNumber();
            for (int i = 0; i < customPropertyValuesJSONArray.length(); ++i) {
                JSONObject jsonObject = customPropertyValuesJSONArray.getJSONObject(i);
                if (propertyNumber != jsonObject.optInt("PropertyNumber")) continue;
                customPropertyValueJSONObject = jsonObject;
                break;
            }
            if (customPropertyValueJSONObject == null) {
                customPropertyValueJSONObject = new JSONObject();
                customPropertyValueJSONObject.put("PropertyNumber", propertyNumber);
                customPropertyValuesJSONArray.put((Object)customPropertyValueJSONObject);
            }
            if ((integerListValueJSONArray = customPropertyValueJSONObject.optJSONArray("IntegerListValue")) == null || integerListValueJSONArray == JSONObject.NULL) {
                integerListValueJSONArray = new JSONArray();
            }
            Iterator iterator = multiListSpiraCustomPropertyValue.getValue().iterator();
            while (iterator.hasNext()) {
                SpiraCustomListValue spiraCustomListValue = (SpiraCustomListValue)iterator.next();
                integerListValueJSONArray.put(spiraCustomListValue.getID());
            }
            customPropertyValueJSONObject.put("IntegerListValue", (Object)integerListValueJSONArray);
        }
    }
}

