/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.spira;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.spira.ListSpiraCustomPropertyValue;
import com.liferay.jenkins.results.parser.spira.SpiraArtifact;
import com.liferay.jenkins.results.parser.spira.SpiraCustomListValue;
import com.liferay.jenkins.results.parser.spira.SpiraCustomProperty;
import com.liferay.jenkins.results.parser.spira.SpiraProject;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class SpiraTestCaseProductVersion
extends ListSpiraCustomPropertyValue {
    protected static final String CUSTOM_PROPERTY_NAME = "Product Version";
    private static final Map<String, SpiraTestCaseProductVersion> _spiraTestCaseProductVersions = new HashMap<String, SpiraTestCaseProductVersion>();

    public static SpiraTestCaseProductVersion createSpiraTestCaseProductVersion(SpiraProject spiraProject, Class<? extends SpiraArtifact> spiraArtifactClass, String productVersion) {
        String key = JenkinsResultsParserUtil.combine(String.valueOf(spiraProject.getID()), "_", SpiraTestCaseProductVersion.getArtifactTypeName(spiraArtifactClass), "_", productVersion);
        SpiraTestCaseProductVersion spiraTestCaseProductVersion = _spiraTestCaseProductVersions.get(key);
        if (spiraTestCaseProductVersion != null) {
            return spiraTestCaseProductVersion;
        }
        spiraTestCaseProductVersion = new SpiraTestCaseProductVersion(spiraProject, spiraArtifactClass, productVersion);
        _spiraTestCaseProductVersions.put(key, spiraTestCaseProductVersion);
        return spiraTestCaseProductVersion;
    }

    public String getProductVersion() {
        return this.getValueString();
    }

    protected SpiraTestCaseProductVersion(JSONObject jsonObject, SpiraCustomProperty spiraCustomProperty) {
        super(jsonObject, spiraCustomProperty);
    }

    protected SpiraTestCaseProductVersion(SpiraCustomProperty spiraCustomProperty, String productVersion) {
        super(SpiraTestCaseProductVersion._getSpiraCustomListValue(spiraCustomProperty, productVersion), spiraCustomProperty);
    }

    protected SpiraTestCaseProductVersion(SpiraProject spiraProject, Class<? extends SpiraArtifact> spiraArtifactClass, String productVersion) {
        this(SpiraTestCaseProductVersion._getSpiraCustomProperty(spiraProject, spiraArtifactClass), productVersion);
    }

    private static SpiraCustomListValue _getSpiraCustomListValue(SpiraCustomProperty spiraCustomProperty, String productVersion) {
        return SpiraCustomListValue.createSpiraCustomListValue(spiraCustomProperty.getSpiraProject(), spiraCustomProperty.getSpiraCustomList(), productVersion);
    }

    private static SpiraCustomProperty _getSpiraCustomProperty(SpiraProject spiraProject, Class<? extends SpiraArtifact> spiraArtifactClass) {
        return SpiraCustomProperty.createSpiraCustomProperty(spiraProject, spiraArtifactClass, CUSTOM_PROPERTY_NAME, SpiraCustomProperty.Type.LIST);
    }
}

