/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.spira;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.spira.BaseSpiraArtifact;
import com.liferay.jenkins.results.parser.spira.SearchQuery;
import com.liferay.jenkins.results.parser.spira.SpiraProject;
import com.liferay.jenkins.results.parser.spira.SpiraRestAPIUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.json.JSONArray;
import org.json.JSONObject;

public class SpiraTestCasePriority
extends BaseSpiraArtifact {
    protected static final String ARTIFACT_TYPE_NAME = "priority";
    protected static final String KEY_ID = "PriorityId";

    public Integer getScore() {
        return this.jsonObject.getInt("Score");
    }

    @Override
    public String getURL() {
        SpiraProject spiraProject = this.getSpiraProject();
        return JenkinsResultsParserUtil.combine("https://liferay.spiraservice.net/", "/pt/", String.valueOf(spiraProject.getProjectTemplateID()), "/Administration/TestCasePriorities.aspx");
    }

    protected static List<SpiraTestCasePriority> getSpiraTestCasePriorities(final SpiraProject spiraProject, SearchQuery.SearchParameter ... searchParameters) {
        return SpiraTestCasePriority.getSpiraArtifacts(SpiraTestCasePriority.class, new Supplier<List<JSONObject>>(){

            @Override
            public List<JSONObject> get() {
                return SpiraTestCasePriority._requestSpiraTestCasePriorities(spiraProject);
            }
        }, new Function<JSONObject, SpiraTestCasePriority>(){

            @Override
            public SpiraTestCasePriority apply(JSONObject jsonObject) {
                return new SpiraTestCasePriority(spiraProject, jsonObject);
            }
        }, searchParameters);
    }

    private static List<JSONObject> _requestSpiraTestCasePriorities(SpiraProject spiraProject) {
        ArrayList<JSONObject> spiraTestCaseTypes = new ArrayList<JSONObject>();
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("project_template_id", String.valueOf(spiraProject.getProjectTemplateID()));
        try {
            JSONArray responseJSONArray = SpiraRestAPIUtil.requestJSONArray("project-templates/{project_template_id}/test-cases/priorities", null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.GET, null);
            for (int i = 0; i < responseJSONArray.length(); ++i) {
                JSONObject responseJSONObject = responseJSONArray.getJSONObject(i);
                responseJSONObject.put("ProjectId", spiraProject.getID());
                spiraTestCaseTypes.add(responseJSONObject);
            }
            return spiraTestCaseTypes;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private SpiraTestCasePriority(SpiraProject spiraProject, JSONObject jsonObject) {
        super(jsonObject);
        jsonObject.put("ProjectId", spiraProject.getID());
        SpiraTestCasePriority.cacheSpiraArtifact(SpiraTestCasePriority.class, this);
    }
}

