/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.spira;

import com.google.common.collect.Lists;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.spira.BaseSpiraArtifact;
import com.liferay.jenkins.results.parser.spira.PathSpiraArtifact;
import com.liferay.jenkins.results.parser.spira.SearchQuery;
import com.liferay.jenkins.results.parser.spira.SpiraCustomProperty;
import com.liferay.jenkins.results.parser.spira.SpiraCustomPropertyValue;
import com.liferay.jenkins.results.parser.spira.SpiraProject;
import com.liferay.jenkins.results.parser.spira.SpiraRestAPIUtil;
import com.liferay.jenkins.results.parser.spira.SpiraTestCaseComponent;
import com.liferay.jenkins.results.parser.spira.SpiraTestCaseFolder;
import com.liferay.jenkins.results.parser.spira.SpiraTestCasePriority;
import com.liferay.jenkins.results.parser.spira.SpiraTestCaseProductVersion;
import com.liferay.jenkins.results.parser.spira.SpiraTestCaseRun;
import com.liferay.jenkins.results.parser.spira.SpiraTestCaseType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class SpiraTestCaseObject
extends PathSpiraArtifact {
    protected static final Integer ARTIFACT_TYPE_ID = 2;
    protected static final String ARTIFACT_TYPE_NAME = "testcase";
    protected static final String KEY_ID = "TestCaseId";
    private static final String _CUSTOM_FIELD_EXECUTION_TYPE_KEY = "Execution Type";
    private static final String _CUSTOM_FIELD_FILE_PATH_KEY = "File Path";
    private SpiraTestCaseFolder _parentSpiraTestCaseFolder;
    private SpiraTestCaseProductVersion _spiraTestCaseProductVersion;

    public static void clearCachedSpiraTestCaseObjects() {
        SpiraTestCaseObject.clearCachedSpiraArtifacts(SpiraTestCaseObject.class);
    }

    public static SpiraTestCaseObject createSpiraTestCaseObjectByPath(SpiraProject spiraProject, String testCasePath, SpiraTestCaseType spiraTestCaseType, List<SpiraCustomPropertyValue> spiraCustomPropertyValues) {
        HashSet<SpiraCustomPropertyValue> spiraCustomPropertyValueSet = new HashSet<SpiraCustomPropertyValue>();
        if (spiraCustomPropertyValues != null) {
            spiraCustomPropertyValueSet.addAll(spiraCustomPropertyValues);
        }
        spiraCustomPropertyValueSet.add(SpiraTestCaseObject._getExecutionTypeSpiraCustomPropertyValue(spiraProject));
        List<SpiraTestCaseObject> spiraTestCaseObjects = SpiraTestCaseObject._getSpiraTestCaseObjects(spiraProject, testCasePath, spiraTestCaseType, new ArrayList<SpiraCustomPropertyValue>(spiraCustomPropertyValueSet));
        if (!spiraTestCaseObjects.isEmpty()) {
            SpiraTestCaseObject targetSpiraTestCaseObject = null;
            for (SpiraTestCaseObject spiraTestCaseObject : spiraTestCaseObjects) {
                if (targetSpiraTestCaseObject == null) {
                    targetSpiraTestCaseObject = spiraTestCaseObject;
                }
                if (targetSpiraTestCaseObject.getID() <= spiraTestCaseObject.getID()) continue;
                targetSpiraTestCaseObject = spiraTestCaseObject;
            }
            return targetSpiraTestCaseObject;
        }
        String urlPath = "projects/{project_id}/test-cases";
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
        JSONObject requestJSONObject = new JSONObject();
        requestJSONObject.put("Name", (Object)StringEscapeUtils.unescapeJava((String)SpiraTestCaseObject.getPathName(testCasePath)));
        requestJSONObject.put("TestCaseStatusId", (Object)Status.DRAFT.getID());
        BaseSpiraArtifact parentSpiraTestCaseFolder = null;
        String parentTestCaseFolderPath = SpiraTestCaseObject.getParentPath(testCasePath);
        if (parentTestCaseFolderPath != null && !parentTestCaseFolderPath.isEmpty()) {
            parentSpiraTestCaseFolder = SpiraTestCaseFolder.createSpiraTestCaseFolderByPath(spiraProject, parentTestCaseFolderPath);
        }
        if (parentSpiraTestCaseFolder != null) {
            requestJSONObject.put("TestCaseFolderId", parentSpiraTestCaseFolder.getID());
        }
        if (spiraTestCaseType != null) {
            requestJSONObject.put("TestCaseTypeId", spiraTestCaseType.getID());
        }
        JSONArray customPropertiesJSONArray = new JSONArray();
        for (SpiraCustomPropertyValue spiraCustomPropertyValue : spiraCustomPropertyValueSet) {
            customPropertiesJSONArray.put((Object)spiraCustomPropertyValue.getCustomPropertyJSONObject());
        }
        requestJSONObject.put("CustomProperties", (Object)customPropertiesJSONArray);
        try {
            JSONObject responseJSONObject = SpiraRestAPIUtil.requestJSONObject(urlPath, null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.POST, requestJSONObject.toString());
            return spiraProject.getSpiraTestCaseObjectByID(responseJSONObject.getInt(KEY_ID));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public static SpiraTestCaseObject createSpiraTestCaseObjectByPath(SpiraProject spiraProject, String testCasePath, String testCaseFilePath, SpiraTestCaseType spiraTestCaseType) {
        ArrayList<SpiraCustomPropertyValue> spiraCustomPropertyValues = new ArrayList<SpiraCustomPropertyValue>();
        if (testCaseFilePath != null && !testCaseFilePath.isEmpty()) {
            SpiraCustomProperty filePathSpiraCustomProperty = SpiraCustomProperty.createSpiraCustomProperty(spiraProject, SpiraTestCaseObject.class, _CUSTOM_FIELD_FILE_PATH_KEY, SpiraCustomProperty.Type.TEXT);
            spiraCustomPropertyValues.add(SpiraCustomPropertyValue.createSpiraCustomPropertyValue(filePathSpiraCustomProperty, testCaseFilePath));
        }
        return SpiraTestCaseObject.createSpiraTestCaseObjectByPath(spiraProject, testCasePath, spiraTestCaseType, spiraCustomPropertyValues);
    }

    public static void deleteSpiraTestCaseObjectByID(SpiraProject spiraProject, int testCaseID) {
        List<SpiraTestCaseObject> spiraTestCaseObjects = SpiraTestCaseObject.getSpiraTestCaseObjects(spiraProject, new SearchQuery.SearchParameter(KEY_ID, testCaseID));
        if (spiraTestCaseObjects.isEmpty()) {
            return;
        }
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
        urlPathReplacements.put("test_case_id", String.valueOf(testCaseID));
        try {
            SpiraRestAPIUtil.request("projects/{project_id}/test-cases/{test_case_id}", null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.DELETE, null);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        SpiraTestCaseObject.removeCachedSpiraArtifacts(SpiraTestCaseObject.class, spiraTestCaseObjects);
    }

    public static void deleteSpiraTestCaseObjectsByPath(SpiraProject spiraProject, String testCasePath) {
        List<SpiraTestCaseObject> spiraTestCaseObjects = SpiraTestCaseObject.getSpiraTestCaseObjects(spiraProject, new SearchQuery.SearchParameter("Path", testCasePath));
        for (SpiraTestCaseObject spiraTestCaseObject : spiraTestCaseObjects) {
            SpiraTestCaseObject.deleteSpiraTestCaseObjectByID(spiraProject, spiraTestCaseObject.getID());
        }
    }

    public String getFilePath() {
        SpiraCustomPropertyValue spiraCustomPropertyValue = this.getSpiraCustomPropertyValue(_CUSTOM_FIELD_FILE_PATH_KEY);
        if (spiraCustomPropertyValue != null) {
            return spiraCustomPropertyValue.getValueString();
        }
        return null;
    }

    public SpiraTestCaseFolder getParentSpiraTestCaseFolder() {
        if (this._parentSpiraTestCaseFolder != null) {
            return this._parentSpiraTestCaseFolder;
        }
        Object testCaseFolderID = this.jsonObject.get("TestCaseFolderId");
        if (testCaseFolderID == JSONObject.NULL) {
            return null;
        }
        if (!(testCaseFolderID instanceof Integer)) {
            return null;
        }
        SpiraProject spiraProject = this.getSpiraProject();
        this._parentSpiraTestCaseFolder = spiraProject.getSpiraTestCaseFolderByID((Integer)testCaseFolderID);
        return this._parentSpiraTestCaseFolder;
    }

    public List<SpiraTestCaseComponent> getSpiraTestCaseComponents() {
        JSONArray componentIDJSONArray = this.jsonObject.optJSONArray("ComponentIds");
        if (componentIDJSONArray == JSONObject.NULL) {
            return new ArrayList<SpiraTestCaseComponent>();
        }
        SpiraProject spiraProject = this.getSpiraProject();
        ArrayList<SpiraTestCaseComponent> spiraTestCaseComponents = new ArrayList<SpiraTestCaseComponent>();
        for (int i = 0; i < componentIDJSONArray.length(); ++i) {
            spiraTestCaseComponents.add(spiraProject.getSpiraTestCaseComponentByID(componentIDJSONArray.getInt(i)));
        }
        return spiraTestCaseComponents;
    }

    public SpiraTestCasePriority getSpiraTestCasePriority() {
        Integer testCasePriorityId = this.jsonObject.optInt("TestCasePriorityId");
        if (testCasePriorityId <= 0 || testCasePriorityId == JSONObject.NULL) {
            return null;
        }
        SpiraProject spiraProject = this.getSpiraProject();
        return spiraProject.getSpiraTestCasePriorityByID(testCasePriorityId);
    }

    public SpiraTestCaseProductVersion getSpiraTestCaseProductVersion() {
        if (this._spiraTestCaseProductVersion != null) {
            return this._spiraTestCaseProductVersion;
        }
        SpiraCustomPropertyValue spiraCustomPropertyValue = this.getSpiraCustomPropertyValue("Product Version");
        if (spiraCustomPropertyValue == null) {
            return null;
        }
        if (spiraCustomPropertyValue instanceof SpiraTestCaseProductVersion) {
            this._spiraTestCaseProductVersion = (SpiraTestCaseProductVersion)spiraCustomPropertyValue;
            return this._spiraTestCaseProductVersion;
        }
        return null;
    }

    public SpiraTestCaseRun getSpiraTestCaseRunByID(int testCaseRunID) {
        List<SpiraTestCaseRun> spiraTestCaseRuns = SpiraTestCaseRun.getSpiraTestCaseRuns(this.getSpiraProject(), this, new SearchQuery.SearchParameter("TestRunId", testCaseRunID));
        if (spiraTestCaseRuns.size() > 1) {
            throw new RuntimeException("Duplicate test case run ID " + testCaseRunID);
        }
        if (spiraTestCaseRuns.isEmpty()) {
            throw new RuntimeException("Missing test case run ID " + testCaseRunID);
        }
        return spiraTestCaseRuns.get(0);
    }

    public List<SpiraTestCaseRun> getSpiraTestCaseRuns() {
        return SpiraTestCaseRun.getSpiraTestCaseRuns(this.getSpiraProject(), this, new SearchQuery.SearchParameter[0]);
    }

    public SpiraTestCaseType getSpiraTestCaseType() {
        SpiraProject spiraProject = this.getSpiraProject();
        return spiraProject.getSpiraTestCaseTypeByID(this.jsonObject.getInt("TestCaseTypeId"));
    }

    @Override
    public String getURL() {
        SpiraProject spiraProject = this.getSpiraProject();
        return JenkinsResultsParserUtil.combine("https://liferay.spiraservice.net/", String.valueOf(spiraProject.getID()), "/TestCase/", String.valueOf(this.getID()), ".aspx");
    }

    public void mergeSpiraTestCaseObject(SpiraTestCaseObject spiraTestCaseObject) {
        SpiraProject spiraProject = this.getSpiraProject();
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
        for (List spiraTestCaseRuns : Lists.partition(spiraTestCaseObject.getSpiraTestCaseRuns(), (int)25)) {
            JSONArray requestJSONArray = new JSONArray();
            for (SpiraTestCaseRun spiraTestCaseRun : spiraTestCaseRuns) {
                JSONObject requestJSONObject = spiraTestCaseRun.getAutomatedJSONObject();
                requestJSONObject.put(KEY_ID, this.getID());
                requestJSONArray.put((Object)requestJSONObject);
            }
            try {
                SpiraRestAPIUtil.request("projects/{project_id}/test-runs/record-multiple", null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.POST, requestJSONArray.toString());
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            SpiraTestCaseRun.deleteSpiraTestCaseRuns(spiraTestCaseRuns);
        }
        SpiraTestCaseObject.deleteSpiraTestCaseObjectByID(spiraProject, spiraTestCaseObject.getID());
    }

    /*
     * WARNING - void declaration
     */
    public void updateSpiraCustomPropertyValues(List<SpiraCustomPropertyValue> spiraCustomPropertyValues) {
        ArrayList<Object> updatedSpiraCustomPropertyValues = new ArrayList<Object>();
        boolean updated = false;
        for (SpiraCustomPropertyValue spiraCustomPropertyValue : this.getSpiraCustomPropertyValues()) {
            void var6_8;
            Object var6_9 = null;
            String currentSpiraCustomPropertyName = spiraCustomPropertyValue.getName();
            for (SpiraCustomPropertyValue spiraCustomPropertyValue2 : spiraCustomPropertyValues) {
                if (!currentSpiraCustomPropertyName.equals(spiraCustomPropertyValue2.getName())) continue;
                if (spiraCustomPropertyValue.equals(spiraCustomPropertyValue2)) break;
                SpiraCustomPropertyValue spiraCustomPropertyValue3 = spiraCustomPropertyValue2;
                break;
            }
            if (var6_8 != null) {
                updated = true;
                updatedSpiraCustomPropertyValues.add(var6_8);
                continue;
            }
            updatedSpiraCustomPropertyValues.add(spiraCustomPropertyValue);
        }
        if (!updated) {
            return;
        }
        JSONArray customPropertiesJSONArray = new JSONArray();
        for (SpiraCustomPropertyValue spiraCustomPropertyValue : updatedSpiraCustomPropertyValues) {
            customPropertiesJSONArray.put((Object)spiraCustomPropertyValue.getCustomPropertyJSONObject());
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("CustomProperties", (Object)customPropertiesJSONArray);
        this._updateJSONObject(jSONObject);
    }

    public void updateSpiraTestCaseComponents(List<SpiraTestCaseComponent> spiraTestCaseComponents) {
        if (spiraTestCaseComponents != null) {
            this.updateSpiraTestCaseComponents(spiraTestCaseComponents.toArray(new SpiraTestCaseComponent[0]));
        }
    }

    public void updateSpiraTestCaseComponents(SpiraTestCaseComponent ... spiraTestCaseComponents) {
        if (spiraTestCaseComponents == null) {
            return;
        }
        boolean updated = false;
        List<SpiraTestCaseComponent> currentSpiraTestCaseComponents = this.getSpiraTestCaseComponents();
        if (spiraTestCaseComponents.length != currentSpiraTestCaseComponents.size()) {
            updated = true;
        }
        for (SpiraTestCaseComponent spiraTestCaseComponent : spiraTestCaseComponents) {
            if (updated) break;
            boolean found = false;
            for (SpiraTestCaseComponent currentSpiraTestCaseComponent : currentSpiraTestCaseComponents) {
                if (!currentSpiraTestCaseComponent.equals(spiraTestCaseComponent)) continue;
                found = true;
                break;
            }
            if (found) continue;
            updated = true;
            break;
        }
        if (!updated) {
            return;
        }
        JSONObject jsonObject = new JSONObject();
        JSONArray componentIDsJSONArray = new JSONArray();
        for (SpiraTestCaseComponent spiraTestCaseComponent : spiraTestCaseComponents) {
            componentIDsJSONArray.put(spiraTestCaseComponent.getID());
        }
        jsonObject.put("ComponentIds", (Object)componentIDsJSONArray);
        this._updateJSONObject(jsonObject);
    }

    public void updateSpiraTestCasePriority(SpiraTestCasePriority spiraTestCasePriority) {
        if (spiraTestCasePriority == null) {
            return;
        }
        SpiraTestCasePriority currentSpiraTestCasePriority = this.getSpiraTestCasePriority();
        if (currentSpiraTestCasePriority != null && currentSpiraTestCasePriority.equals(spiraTestCasePriority)) {
            return;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("TestCasePriorityId", spiraTestCasePriority.getID());
        this._updateJSONObject(jsonObject);
    }

    protected static List<SpiraTestCaseObject> getSpiraTestCaseObjects(final SpiraProject spiraProject, final long numberOfRows, boolean checkCache, final SearchQuery.SearchParameter ... searchParameters) {
        return SpiraTestCaseObject.getSpiraArtifacts(SpiraTestCaseObject.class, new Supplier<List<JSONObject>>(){

            @Override
            public List<JSONObject> get() {
                return SpiraTestCaseObject._requestSpiraTestCases(spiraProject, numberOfRows, searchParameters);
            }
        }, new Function<JSONObject, SpiraTestCaseObject>(){

            @Override
            public SpiraTestCaseObject apply(JSONObject jsonObject) {
                return new SpiraTestCaseObject(jsonObject);
            }
        }, checkCache, searchParameters);
    }

    protected static List<SpiraTestCaseObject> getSpiraTestCaseObjects(SpiraProject spiraProject, SearchQuery.SearchParameter ... searchParameters) {
        return SpiraTestCaseObject.getSpiraTestCaseObjects(spiraProject, 35000L, true, searchParameters);
    }

    @Override
    protected PathSpiraArtifact getParentSpiraArtifact() {
        return this.getParentSpiraTestCaseFolder();
    }

    private static SpiraCustomPropertyValue _getExecutionTypeSpiraCustomPropertyValue(SpiraProject spiraProject) {
        SpiraCustomProperty spiraCustomProperty = SpiraCustomProperty.createSpiraCustomProperty(spiraProject, SpiraTestCaseObject.class, _CUSTOM_FIELD_EXECUTION_TYPE_KEY, SpiraCustomProperty.Type.LIST);
        return SpiraCustomPropertyValue.createSpiraCustomPropertyValue(spiraCustomProperty, "Automatic");
    }

    private static List<SpiraTestCaseObject> _getSpiraTestCaseObjects(SpiraProject spiraProject, String testCasePath, SpiraTestCaseType spiraTestCaseType, List<SpiraCustomPropertyValue> spiraCustomPropertyValues) {
        ArrayList<SearchQuery.SearchParameter> searchParameters = new ArrayList<SearchQuery.SearchParameter>();
        searchParameters.add(new SearchQuery.SearchParameter("Path", testCasePath));
        String parentTestCaseFolderPath = SpiraTestCaseObject.getParentPath(testCasePath);
        if (parentTestCaseFolderPath != null && !parentTestCaseFolderPath.isEmpty()) {
            SpiraTestCaseFolder parentSpiraTestCaseFolder = SpiraTestCaseFolder.createSpiraTestCaseFolderByPath(spiraProject, parentTestCaseFolderPath);
            searchParameters.add(new SearchQuery.SearchParameter("TestCaseFolderId", parentSpiraTestCaseFolder.getID()));
        }
        if (spiraTestCaseType != null) {
            searchParameters.add(new SearchQuery.SearchParameter("TestCaseTypeId", spiraTestCaseType.getID()));
        }
        HashSet<SpiraCustomPropertyValue> spiraCustomPropertyValueSet = new HashSet<SpiraCustomPropertyValue>();
        if (spiraCustomPropertyValues != null) {
            spiraCustomPropertyValueSet.addAll(spiraCustomPropertyValues);
        }
        spiraCustomPropertyValueSet.add(SpiraTestCaseObject._getExecutionTypeSpiraCustomPropertyValue(spiraProject));
        for (SpiraCustomPropertyValue spiraCustomPropertyValue : spiraCustomPropertyValueSet) {
            searchParameters.add(new SearchQuery.SearchParameter(spiraCustomPropertyValue));
        }
        return SpiraTestCaseObject.getSpiraTestCaseObjects(spiraProject, searchParameters.toArray(new SearchQuery.SearchParameter[0]));
    }

    private static List<JSONObject> _requestSpiraTestCases(SpiraProject spiraProject, long numberOfRows, SearchQuery.SearchParameter ... searchParameters) {
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
        HashMap<String, String> urlParameters = new HashMap<String, String>();
        urlParameters.put("number_of_rows", String.valueOf(numberOfRows));
        urlParameters.put("starting_row", String.valueOf(1));
        JSONArray requestJSONArray = new JSONArray();
        ArrayList<String> searchParameterNames = new ArrayList<String>();
        for (SearchQuery.SearchParameter searchParameter : searchParameters) {
            String searchParameterName = searchParameter.getName();
            if (searchParameterNames.contains(searchParameterName)) continue;
            searchParameterNames.add(searchParameterName);
            requestJSONArray.put((Object)searchParameter.toFilterJSONObject());
        }
        try {
            JSONArray responseJSONArray = SpiraRestAPIUtil.requestJSONArray("projects/{project_id}/test-cases/search", urlParameters, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.POST, requestJSONArray.toString());
            ArrayList<JSONObject> spiraTestCases = new ArrayList<JSONObject>();
            for (int i = 0; i < responseJSONArray.length(); ++i) {
                spiraTestCases.add(responseJSONArray.getJSONObject(i));
            }
            return spiraTestCases;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private SpiraTestCaseObject(JSONObject jsonObject) {
        super(jsonObject);
        SpiraTestCaseObject.cacheSpiraArtifact(SpiraTestCaseObject.class, this);
    }

    private void _refreshJSONObject() {
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        SpiraProject spiraProject = this.getSpiraProject();
        urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
        urlPathReplacements.put("test_case_id", String.valueOf(this.getID()));
        try {
            this.jsonObject = SpiraRestAPIUtil.requestJSONObject("projects/{project_id}/test-cases/{test_case_id}", null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.GET, null);
            this.jsonObject.put("Path", (Object)this.getPath());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _updateJSONObject(JSONObject jsonObject) {
        SpiraProject spiraProject = this.getSpiraProject();
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
        int updateRetryCount = 0;
        while (true) {
            JSONObject requestJSONObject = this.toJSONObject();
            for (String key : jsonObject.keySet()) {
                if (requestJSONObject.has(key)) {
                    requestJSONObject.remove(key);
                }
                requestJSONObject.put(key, jsonObject.get(key));
            }
            try {
                SpiraRestAPIUtil.request("projects/{project_id}/test-cases", null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.PUT, requestJSONObject.toString());
                return;
            }
            catch (IOException ioException) {
                if (updateRetryCount >= 2) {
                    throw new RuntimeException(ioException);
                }
                ++updateRetryCount;
                continue;
            }
            finally {
                this._refreshJSONObject();
                continue;
            }
            break;
        }
    }

    public static enum Status {
        APPROVED(4),
        DRAFT(1),
        OBSOLETE(9),
        READY_FOR_REVIEW(2),
        READY_FOR_TEST(5),
        REJECTED(3),
        TESTED(7),
        VERIFIED(8);

        private final Integer _id;

        public Integer getID() {
            return this._id;
        }

        private Status(Integer id) {
            this._id = id;
        }
    }
}

