/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.spira;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.spira.PathSpiraArtifact;
import com.liferay.jenkins.results.parser.spira.SearchQuery;
import com.liferay.jenkins.results.parser.spira.SpiraProject;
import com.liferay.jenkins.results.parser.spira.SpiraRestAPIUtil;
import com.liferay.jenkins.results.parser.spira.SpiraTestCaseObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class SpiraTestCaseFolder
extends PathSpiraArtifact {
    protected static final String ARTIFACT_TYPE_NAME = "testcasefolder";
    protected static final String KEY_ID = "TestCaseFolderId";
    private List<SpiraTestCaseObject> _childSpiraTestCaseObjects;
    private SpiraTestCaseFolder _parentSpiraTestCaseFolder;

    public static SpiraTestCaseFolder createSpiraTestCaseFolder(SpiraProject spiraProject, String testCaseFolderName) {
        return SpiraTestCaseFolder.createSpiraTestCaseFolder(spiraProject, testCaseFolderName, null);
    }

    public static SpiraTestCaseFolder createSpiraTestCaseFolder(SpiraProject spiraProject, String testCaseFolderName, Integer parentTestCaseFolderID) {
        List<SpiraTestCaseFolder> spiraTestCaseFolders;
        SpiraTestCaseFolder parentSpiraTestCaseFolder;
        String testCaseFolderPath = "/" + testCaseFolderName;
        if (parentTestCaseFolderID != null && (parentSpiraTestCaseFolder = spiraProject.getSpiraTestCaseFolderByID(parentTestCaseFolderID)) != null) {
            testCaseFolderPath = parentSpiraTestCaseFolder.getPath() + "/" + testCaseFolderName;
        }
        if (!(spiraTestCaseFolders = spiraProject.getSpiraTestCaseFoldersByPath(testCaseFolderPath)).isEmpty()) {
            return spiraTestCaseFolders.get(0);
        }
        String urlPath = "projects/{project_id}/test-folders";
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
        JSONObject requestJSONObject = new JSONObject();
        requestJSONObject.put("Name", (Object)StringEscapeUtils.unescapeJava((String)testCaseFolderName));
        requestJSONObject.put("ParentTestCaseFolderId", (Object)parentTestCaseFolderID);
        try {
            JSONObject responseJSONObject = SpiraRestAPIUtil.requestJSONObject(urlPath, null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.POST, requestJSONObject.toString());
            return spiraProject.getSpiraTestCaseFolderByID(responseJSONObject.getInt(KEY_ID));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public static SpiraTestCaseFolder createSpiraTestCaseFolderByPath(SpiraProject spiraProject, String testCaseFolderPath) {
        List<SpiraTestCaseFolder> spiraTestCaseFolders = spiraProject.getSpiraTestCaseFoldersByPath(testCaseFolderPath);
        if (!spiraTestCaseFolders.isEmpty()) {
            return spiraTestCaseFolders.get(0);
        }
        String testCaseFolderName = SpiraTestCaseFolder.getPathName(testCaseFolderPath);
        String parentTestCaseFolderPath = SpiraTestCaseFolder.getParentPath(testCaseFolderPath);
        if (parentTestCaseFolderPath.isEmpty()) {
            return SpiraTestCaseFolder.createSpiraTestCaseFolder(spiraProject, testCaseFolderName);
        }
        SpiraTestCaseFolder parentSpiraTestCaseFolder = SpiraTestCaseFolder.createSpiraTestCaseFolderByPath(spiraProject, parentTestCaseFolderPath);
        return SpiraTestCaseFolder.createSpiraTestCaseFolder(spiraProject, testCaseFolderName, parentSpiraTestCaseFolder.getID());
    }

    public static void deleteSpiraTestCaseFolderByID(SpiraProject spiraProject, int testCaseFolderID) {
        List<SpiraTestCaseFolder> spiraTestCaseFolders = SpiraTestCaseFolder.getSpiraTestCaseFolders(spiraProject, new SearchQuery.SearchParameter(KEY_ID, testCaseFolderID));
        if (spiraTestCaseFolders.isEmpty()) {
            return;
        }
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
        urlPathReplacements.put("test_case_folder_id", String.valueOf(testCaseFolderID));
        try {
            SpiraRestAPIUtil.request("projects/{project_id}/test-folders/{test_case_folder_id}", null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.DELETE, null);
            SpiraTestCaseFolder.removeCachedSpiraArtifacts(SpiraTestCaseFolder.class, spiraTestCaseFolders);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public static void deleteSpiraTestCaseFoldersByPath(SpiraProject spiraProject, String testCaseFolderPath) {
        List<SpiraTestCaseFolder> spiraTestCaseFolders = spiraProject.getSpiraTestCaseFoldersByPath(testCaseFolderPath);
        for (SpiraTestCaseFolder spiraTestCaseFolder : spiraTestCaseFolders) {
            SpiraTestCaseFolder.deleteSpiraTestCaseFolderByID(spiraProject, spiraTestCaseFolder.getID());
        }
    }

    public List<SpiraTestCaseObject> getChildSpiraTestCaseObjects() {
        if (this._childSpiraTestCaseObjects != null) {
            return this._childSpiraTestCaseObjects;
        }
        this._childSpiraTestCaseObjects = new ArrayList<SpiraTestCaseObject>(SpiraTestCaseObject.getSpiraTestCaseObjects(this.getSpiraProject(), new SearchQuery.SearchParameter(KEY_ID, this.getID())));
        List<SpiraTestCaseFolder> spiraTestCaseFolders = SpiraTestCaseFolder.getSpiraTestCaseFolders(this.getSpiraProject(), new SearchQuery.SearchParameter("ParentTestCaseFolderId", this.getID()));
        for (SpiraTestCaseFolder spiraTestCaseFolder : spiraTestCaseFolders) {
            this._childSpiraTestCaseObjects.addAll(spiraTestCaseFolder.getChildSpiraTestCaseObjects());
        }
        return this._childSpiraTestCaseObjects;
    }

    public SpiraTestCaseFolder getParentSpiraTestCaseFolder() {
        if (this._parentSpiraTestCaseFolder != null) {
            return this._parentSpiraTestCaseFolder;
        }
        Object testCaseFolderID = this.jsonObject.get("ParentTestCaseFolderId");
        if (testCaseFolderID == JSONObject.NULL) {
            return null;
        }
        if (!(testCaseFolderID instanceof Integer)) {
            return null;
        }
        SpiraProject spiraProject = this.getSpiraProject();
        this._parentSpiraTestCaseFolder = spiraProject.getSpiraTestCaseFolderByID((Integer)testCaseFolderID);
        return this._parentSpiraTestCaseFolder;
    }

    @Override
    public String getURL() {
        SpiraProject spiraProject = this.getSpiraProject();
        return JenkinsResultsParserUtil.combine("https://liferay.spiraservice.net/", String.valueOf(spiraProject.getID()), "/TestCase/List/", String.valueOf(this.getID()), ".aspx");
    }

    protected static List<SpiraTestCaseFolder> getSpiraTestCaseFolders(final SpiraProject spiraProject, SearchQuery.SearchParameter ... searchParameters) {
        return SpiraTestCaseFolder.getSpiraArtifacts(SpiraTestCaseFolder.class, new Supplier<List<JSONObject>>(){

            @Override
            public List<JSONObject> get() {
                return SpiraTestCaseFolder._requestSpiraTestCaseFolders(spiraProject);
            }
        }, new Function<JSONObject, SpiraTestCaseFolder>(){

            @Override
            public SpiraTestCaseFolder apply(JSONObject jsonObject) {
                return new SpiraTestCaseFolder(jsonObject);
            }
        }, searchParameters);
    }

    @Override
    protected PathSpiraArtifact getParentSpiraArtifact() {
        return this.getParentSpiraTestCaseFolder();
    }

    private static List<JSONObject> _requestSpiraTestCaseFolders(SpiraProject spiraProject) {
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
        ArrayList<JSONObject> spiraTestCaseFolders = new ArrayList<JSONObject>();
        try {
            JSONArray responseJSONArray = SpiraRestAPIUtil.requestJSONArray("projects/{project_id}/test-folders", null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.GET, null);
            for (int i = 0; i < responseJSONArray.length(); ++i) {
                JSONObject responseJSONObject = responseJSONArray.getJSONObject(i);
                responseJSONObject.put("ProjectId", spiraProject.getID());
                spiraTestCaseFolders.add(responseJSONObject);
            }
            return spiraTestCaseFolders;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private SpiraTestCaseFolder(JSONObject jsonObject) {
        super(jsonObject);
        SpiraTestCaseFolder.cacheSpiraArtifact(SpiraTestCaseFolder.class, this);
    }
}

