/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.spira;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.spira.BaseSpiraArtifact;
import com.liferay.jenkins.results.parser.spira.SearchQuery;
import com.liferay.jenkins.results.parser.spira.SpiraProject;
import com.liferay.jenkins.results.parser.spira.SpiraRestAPIUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.json.JSONArray;
import org.json.JSONObject;

public class SpiraTestCaseComponent
extends BaseSpiraArtifact {
    protected static final String ARTIFACT_TYPE_NAME = "component";
    protected static final String KEY_ID = "ComponentId";

    public static SpiraTestCaseComponent createSpiraTestCaseComponent(SpiraProject spiraProject, String componentName) {
        List<SpiraTestCaseComponent> spiraTestCaseComponents = SpiraTestCaseComponent.getSpiraTestCaseComponents(spiraProject, new SearchQuery.SearchParameter("Name", componentName));
        if (!spiraTestCaseComponents.isEmpty()) {
            return spiraTestCaseComponents.get(0);
        }
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
        JSONObject requestJSONObject = new JSONObject();
        requestJSONObject.put("IsActive", true);
        requestJSONObject.put("IsDeleted", false);
        requestJSONObject.put("Name", (Object)componentName);
        requestJSONObject.put("ProjectId", spiraProject.getID());
        try {
            return new SpiraTestCaseComponent(SpiraRestAPIUtil.requestJSONObject("projects/{project_id}/components", null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.POST, requestJSONObject.toString()));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public String getURL() {
        SpiraProject spiraProject = this.getSpiraProject();
        return JenkinsResultsParserUtil.combine("https://liferay.spiraservice.net/", "/", String.valueOf(spiraProject.getID()), "/Administration/Components.aspx");
    }

    protected static List<SpiraTestCaseComponent> getSpiraTestCaseComponents(final SpiraProject spiraProject, SearchQuery.SearchParameter ... searchParameters) {
        return SpiraTestCaseComponent.getSpiraArtifacts(SpiraTestCaseComponent.class, new Supplier<List<JSONObject>>(){

            @Override
            public List<JSONObject> get() {
                return SpiraTestCaseComponent._requestSpiraTestCaseComponents(spiraProject);
            }
        }, new Function<JSONObject, SpiraTestCaseComponent>(){

            @Override
            public SpiraTestCaseComponent apply(JSONObject jsonObject) {
                return new SpiraTestCaseComponent(jsonObject);
            }
        }, searchParameters);
    }

    private static List<JSONObject> _requestSpiraTestCaseComponents(SpiraProject spiraProject) {
        ArrayList<JSONObject> spiraTestCaseTypes = new ArrayList<JSONObject>();
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
        HashMap<String, String> urlParameters = new HashMap<String, String>();
        urlParameters.put("active_only", "true");
        urlParameters.put("include_deleted", "false");
        try {
            JSONArray responseJSONArray = SpiraRestAPIUtil.requestJSONArray("projects/{project_id}/components", urlParameters, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.GET, null);
            for (int i = 0; i < responseJSONArray.length(); ++i) {
                JSONObject responseJSONObject = responseJSONArray.getJSONObject(i);
                responseJSONObject.put("ProjectId", spiraProject.getID());
                spiraTestCaseTypes.add(responseJSONObject);
            }
            return spiraTestCaseTypes;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private SpiraTestCaseComponent(JSONObject jsonObject) {
        super(jsonObject);
        SpiraTestCaseComponent.cacheSpiraArtifact(SpiraTestCaseComponent.class, this);
    }
}

