/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.spira;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class SpiraRestAPIUtil {
    private static final int _MILLIS_TIMEOUT_DEFAULT = 0;
    private static final int _RETRIES_SIZE_MAX_DEFAULT = 3;
    private static final int _SECONDS_RETRY_PERIOD_DEFAULT = 5;
    private static final Map<String, List<RequestDataEntry>> _groupedRequestDataEntriesMap = Collections.synchronizedMap(new LinkedHashMap());

    public static void summarizeRequests() {
        HashSet orderedRequestDataEntriesSet = new HashSet();
        for (Map.Entry<String, List<RequestDataEntry>> entry : _groupedRequestDataEntriesMap.entrySet()) {
            orderedRequestDataEntriesSet.addAll(entry.getValue());
        }
        ArrayList orderedRequestDataEntries = new ArrayList(orderedRequestDataEntriesSet);
        Collections.sort(orderedRequestDataEntries);
        long totalRequestCount = orderedRequestDataEntries.size();
        long totalDuration = 0L;
        long totalRequestByteCount = 0L;
        long totalResponseByteCount = 0L;
        long q1Index = totalRequestCount / 4L;
        long q2Index = totalRequestCount / 2L;
        long q3Index = q1Index + q2Index;
        RequestDataEntry q1RequestDataEntry = (RequestDataEntry)orderedRequestDataEntries.get(0);
        RequestDataEntry q2RequestDataEntry = (RequestDataEntry)orderedRequestDataEntries.get(0);
        RequestDataEntry q3RequestDataEntry = (RequestDataEntry)orderedRequestDataEntries.get(orderedRequestDataEntries.size() - 1);
        int i = 0;
        for (RequestDataEntry requestDataEntry : orderedRequestDataEntries) {
            if ((long)i == q1Index) {
                q1RequestDataEntry = requestDataEntry;
            }
            if ((long)i == q2Index) {
                q2RequestDataEntry = requestDataEntry;
            }
            if ((long)i == q3Index) {
                q3RequestDataEntry = requestDataEntry;
            }
            totalDuration += requestDataEntry.getDuration().longValue();
            totalRequestByteCount += requestDataEntry.getRequestByteCount().longValue();
            totalResponseByteCount += requestDataEntry.getResponseByteCount().longValue();
            ++i;
        }
        System.out.println();
        System.out.println("#");
        System.out.printf("# Total Requests (%,d)\n", totalRequestCount);
        System.out.println("#");
        System.out.println();
        System.out.println(new RequestDataEntry(totalDuration, totalRequestByteCount, totalResponseByteCount));
        System.out.println();
        System.out.println("#");
        System.out.println("# Average Request");
        System.out.println("#");
        System.out.println();
        System.out.println(new RequestDataEntry(totalDuration / totalRequestCount, totalRequestByteCount / totalRequestCount, totalResponseByteCount / totalRequestCount));
        System.out.println();
        System.out.println("#");
        System.out.println("# Fastest Request");
        System.out.println("#");
        System.out.println();
        System.out.println(orderedRequestDataEntries.get(0));
        System.out.println();
        System.out.println("#");
        System.out.println("# Q1 Request");
        System.out.println("#");
        System.out.println();
        System.out.println(q1RequestDataEntry);
        System.out.println();
        System.out.println("#");
        System.out.println("# Q2 Request (median)");
        System.out.println("#");
        System.out.println();
        System.out.println(q2RequestDataEntry);
        System.out.println();
        System.out.println("#");
        System.out.println("# Q3 Request");
        System.out.println("#");
        System.out.println();
        System.out.println(q3RequestDataEntry);
        System.out.println();
        System.out.println("#");
        System.out.println("# Slowest Request");
        System.out.println("#");
        System.out.println();
        System.out.println(orderedRequestDataEntries.get(orderedRequestDataEntries.size() - 1));
        for (Map.Entry entry : _groupedRequestDataEntriesMap.entrySet()) {
            List groupRequestDataEntries = (List)entry.getValue();
            long groupDuration = 0L;
            long groupRequestByteCount = 0L;
            long groupResponseByteCount = 0L;
            for (RequestDataEntry groupRequestDataEntry : groupRequestDataEntries) {
                groupDuration += groupRequestDataEntry.getDuration().longValue();
                groupRequestByteCount += groupRequestDataEntry.getRequestByteCount().longValue();
                groupResponseByteCount += groupRequestDataEntry.getResponseByteCount().longValue();
            }
            long groupRequestCount = groupRequestDataEntries.size();
            System.out.println();
            System.out.println("#");
            System.out.printf("# Requests - %s (%,d)\n", entry.getKey(), groupRequestCount);
            System.out.println("#");
            System.out.println();
            System.out.println(new RequestDataEntry(groupDuration, groupRequestByteCount, groupResponseByteCount));
            if (groupRequestCount <= 1L) continue;
            System.out.println();
            System.out.println("#");
            System.out.printf("# Requests (avg) - %s (%d)\n", entry.getKey(), groupRequestCount);
            System.out.println("#");
            System.out.println();
            System.out.println(new RequestDataEntry(groupDuration / groupRequestCount, groupRequestByteCount / groupRequestCount, groupResponseByteCount / groupRequestCount));
        }
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String request(String urlPath, Map<String, String> urlParameters, Map<String, String> urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod httpRequestMethod, String requestData) throws IOException {
        String spiraRestAPIURL = "https://liferay.spiraservice.net/services/v6_0/RestService.svc";
        if (urlPath.contains("/test-sets/search")) {
            spiraRestAPIURL = spiraRestAPIURL.replace("v6_0", "v5_0");
        }
        int requestCount = 0;
        while (true) {
            String string;
            long start = System.currentTimeMillis();
            String responseData = null;
            try {
                string = responseData = JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.combine(spiraRestAPIURL, SpiraRestAPIUtil._applyURLPathReplacements(urlPath, urlPathReplacements), SpiraRestAPIUtil._toURLParametersString(urlParameters)), false, 0, httpRequestMethod, requestData, 0, 0, null);
                ++requestCount;
            }
            catch (IOException ioException) {
                try {
                    if (requestCount >= 3) {
                        throw ioException;
                    }
                    System.out.println(JenkinsResultsParserUtil.combine("Retrying ", spiraRestAPIURL, "/", urlPath, " in ", String.valueOf(5), " seconds"));
                    JenkinsResultsParserUtil.sleep(5000L);
                    ++requestCount;
                }
                catch (Throwable throwable) {
                    ++requestCount;
                    long duration = System.currentTimeMillis() - start;
                    RequestDataEntry requestDataEntry = new RequestDataEntry("/" + urlPath, duration, requestData, responseData);
                    List<RequestDataEntry> requestDataEntries = _groupedRequestDataEntriesMap.get(requestDataEntry.getRequestURLPath());
                    if (requestDataEntries == null) {
                        requestDataEntries = Collections.synchronizedList(new ArrayList());
                    }
                    requestDataEntries.add(requestDataEntry);
                    _groupedRequestDataEntriesMap.put(requestDataEntry.getRequestURLPath(), requestDataEntries);
                    throw throwable;
                }
                long duration = System.currentTimeMillis() - start;
                RequestDataEntry requestDataEntry = new RequestDataEntry("/" + urlPath, duration, requestData, responseData);
                List<RequestDataEntry> requestDataEntries = _groupedRequestDataEntriesMap.get(requestDataEntry.getRequestURLPath());
                if (requestDataEntries == null) {
                    requestDataEntries = Collections.synchronizedList(new ArrayList());
                }
                requestDataEntries.add(requestDataEntry);
                _groupedRequestDataEntriesMap.put(requestDataEntry.getRequestURLPath(), requestDataEntries);
                continue;
            }
            long duration = System.currentTimeMillis() - start;
            RequestDataEntry requestDataEntry = new RequestDataEntry("/" + urlPath, duration, requestData, responseData);
            List<RequestDataEntry> requestDataEntries = _groupedRequestDataEntriesMap.get(requestDataEntry.getRequestURLPath());
            if (requestDataEntries == null) {
                requestDataEntries = Collections.synchronizedList(new ArrayList());
            }
            requestDataEntries.add(requestDataEntry);
            _groupedRequestDataEntriesMap.put(requestDataEntry.getRequestURLPath(), requestDataEntries);
            return string;
            break;
        }
    }

    protected static JSONArray requestJSONArray(String urlPath, Map<String, String> urlParameters, Map<String, String> urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod httpRequestMethod, String requestData) throws IOException {
        return JenkinsResultsParserUtil.createJSONArray(SpiraRestAPIUtil.request(urlPath, urlParameters, urlPathReplacements, httpRequestMethod, requestData));
    }

    protected static JSONObject requestJSONObject(String urlPath, Map<String, String> urlParameters, Map<String, String> urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod httpRequestMethod, String requestData) throws IOException {
        return JenkinsResultsParserUtil.createJSONObject(SpiraRestAPIUtil.request(urlPath, urlParameters, urlPathReplacements, httpRequestMethod, requestData));
    }

    protected static String toDateString(long timestamp) {
        return JenkinsResultsParserUtil.toDateString(new Date(timestamp), "yyyy-MM-dd'T'HH:mm:ss", "UTC");
    }

    private static String _applyURLPathReplacements(String urlPath, Map<String, String> urlPathReplacements) {
        if (urlPath == null) {
            return "";
        }
        if (urlPathReplacements != null) {
            for (Map.Entry<String, String> urlPathReplacement : urlPathReplacements.entrySet()) {
                urlPath = urlPath.replace("{" + urlPathReplacement.getKey() + "}", urlPathReplacement.getValue());
            }
        }
        if (urlPath.matches(".*\\{[^\\}]+\\}.*")) {
            throw new RuntimeException("Invalid url path " + urlPath);
        }
        if (urlPath.contains("?")) {
            throw new RuntimeException("Invalid url path " + urlPath);
        }
        if (!urlPath.startsWith("/")) {
            urlPath = "/" + urlPath;
        }
        return urlPath;
    }

    private static String _toURLParametersString(Map<String, String> urlParameters) {
        if (urlParameters == null || urlParameters.isEmpty()) {
            return "";
        }
        ArrayList<String> urlParameterStrings = new ArrayList<String>();
        for (Map.Entry<String, String> urlParameter : urlParameters.entrySet()) {
            urlParameterStrings.add(urlParameter.getKey() + "=" + urlParameter.getValue());
        }
        return "?" + JenkinsResultsParserUtil.join("&", urlParameterStrings);
    }

    protected static class RequestDataEntry
    implements Comparable<RequestDataEntry> {
        private final Long _duration;
        private final Long _requestByteCount;
        private final String _requestURLPath;
        private final Long _responseByteCount;

        @Override
        public int compareTo(RequestDataEntry requestDataEntry) {
            return this._duration.compareTo(requestDataEntry.getDuration());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this._requestURLPath != null) {
                sb.append("Request URL Path: ");
                sb.append(this._requestURLPath);
                sb.append("\n");
            }
            sb.append("Duration: ");
            sb.append(JenkinsResultsParserUtil.toDurationString(this._duration));
            sb.append("\n");
            sb.append("Request Byte Count: ");
            sb.append(JenkinsResultsParserUtil.toByteCountString(this._requestByteCount));
            sb.append("\n");
            sb.append("Response Byte Count: ");
            sb.append(JenkinsResultsParserUtil.toByteCountString(this._responseByteCount));
            return sb.toString();
        }

        protected RequestDataEntry(long duration, long requestByteCount, long responseByteCount) {
            this(null, duration, requestByteCount, responseByteCount);
        }

        protected RequestDataEntry(String requestURLPath, long duration, long requestByteCount, long responseByteCount) {
            this._requestURLPath = requestURLPath;
            this._duration = duration;
            this._requestByteCount = requestByteCount;
            this._responseByteCount = responseByteCount;
        }

        protected RequestDataEntry(String requestURL, long duration, String requestData, String responseData) {
            this(requestURL, duration, RequestDataEntry._getByteCount(requestData), RequestDataEntry._getByteCount(responseData));
        }

        protected Long getDuration() {
            return this._duration;
        }

        protected Long getRequestByteCount() {
            return this._requestByteCount;
        }

        protected String getRequestURLPath() {
            return this._requestURLPath;
        }

        protected Long getResponseByteCount() {
            return this._responseByteCount;
        }

        private static long _getByteCount(String data) {
            if (data == null) {
                return 0L;
            }
            byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
            return bytes.length;
        }
    }
}

