/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.spira;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.spira.BaseSpiraArtifact;
import com.liferay.jenkins.results.parser.spira.SearchQuery;
import com.liferay.jenkins.results.parser.spira.SpiraProject;
import com.liferay.jenkins.results.parser.spira.SpiraRelease;
import com.liferay.jenkins.results.parser.spira.SpiraRestAPIUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.json.JSONArray;
import org.json.JSONObject;

public class SpiraReleaseBuild
extends BaseSpiraArtifact {
    protected static final String ARTIFACT_TYPE_NAME = "build";
    protected static final String KEY_ID = "BuildId";

    public static SpiraReleaseBuild createSpiraReleaseBuild(SpiraProject spiraProject, SpiraRelease spiraRelease, String releaseBuildName, String releaseBuildDescription, Status releaseBuildStatus, long releaseBuildStartTime) {
        List<SpiraReleaseBuild> spiraReleaseBuilds = SpiraReleaseBuild.getSpiraReleaseBuilds(spiraProject, spiraRelease, new SearchQuery.SearchParameter("ProjectId", spiraProject.getID()), new SearchQuery.SearchParameter("ReleaseId", spiraRelease.getID()), new SearchQuery.SearchParameter("Name", releaseBuildName));
        if (!spiraReleaseBuilds.isEmpty()) {
            return spiraReleaseBuilds.get(0);
        }
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
        urlPathReplacements.put("release_id", String.valueOf(spiraRelease.getID()));
        JSONObject requestJSONObject = new JSONObject();
        requestJSONObject.put("ProjectId", spiraProject.getID());
        requestJSONObject.put("ReleaseId", spiraRelease.getID());
        requestJSONObject.put("BuildStatusId", (Object)releaseBuildStatus.getID());
        requestJSONObject.put("CreationDate", (Object)SpiraRestAPIUtil.toDateString(releaseBuildStartTime));
        requestJSONObject.put("Name", (Object)releaseBuildName);
        if (releaseBuildDescription != null) {
            requestJSONObject.put("Description", (Object)releaseBuildDescription);
        }
        try {
            JSONObject responseJSONObject = SpiraRestAPIUtil.requestJSONObject("projects/{project_id}/releases/{release_id}/builds", null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.POST, requestJSONObject.toString());
            return spiraRelease.getSpiraReleaseBuildByID(responseJSONObject.getInt(KEY_ID));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public static List<SpiraReleaseBuild> getSpiraReleaseBuilds(final SpiraProject spiraProject, final SpiraRelease spiraRelease, final SearchQuery.SearchParameter ... searchParameters) {
        return SpiraReleaseBuild.getSpiraArtifacts(SpiraReleaseBuild.class, new Supplier<List<JSONObject>>(){

            @Override
            public List<JSONObject> get() {
                return SpiraReleaseBuild._requestSpiraReleaseBuilds(spiraProject, spiraRelease, searchParameters);
            }
        }, new Function<JSONObject, SpiraReleaseBuild>(){

            @Override
            public SpiraReleaseBuild apply(JSONObject jsonObject) {
                return new SpiraReleaseBuild(jsonObject);
            }
        }, searchParameters);
    }

    public String getBuildStatusName() {
        return this.jsonObject.getString("BuildStatusName");
    }

    public String getCreationDate() {
        return this.jsonObject.getString("CreationDate");
    }

    @Override
    public String getURL() {
        SpiraProject spiraProject = this.getSpiraProject();
        return JenkinsResultsParserUtil.combine("https://liferay.spiraservice.net/", String.valueOf(spiraProject.getID()), "/Build/", String.valueOf(this.getID()), ".aspx");
    }

    private static List<JSONObject> _requestSpiraReleaseBuilds(SpiraProject spiraProject, SpiraRelease spiraRelease, SearchQuery.SearchParameter ... searchParameters) {
        HashMap<String, String> urlParameters = new HashMap<String, String>();
        urlParameters.put("number_of_rows", String.valueOf(15000));
        urlParameters.put("sort_by", "BuildId DESC");
        urlParameters.put("starting_row", String.valueOf(1));
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
        urlPathReplacements.put("release_id", String.valueOf(spiraRelease.getID()));
        JSONArray requestJSONArray = new JSONArray();
        for (SearchQuery.SearchParameter searchParameter : searchParameters) {
            requestJSONArray.put((Object)searchParameter.toFilterJSONObject());
        }
        ArrayList<JSONObject> spiraReleaseBuilds = new ArrayList<JSONObject>();
        try {
            JSONArray responseJSONArray = SpiraRestAPIUtil.requestJSONArray("projects/{project_id}/releases/{release_id}/builds", urlParameters, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.POST, requestJSONArray.toString());
            for (int i = 0; i < responseJSONArray.length(); ++i) {
                spiraReleaseBuilds.add(responseJSONArray.getJSONObject(i));
            }
            return spiraReleaseBuilds;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private SpiraReleaseBuild(JSONObject jsonObject) {
        super(jsonObject);
        SpiraReleaseBuild.cacheSpiraArtifact(SpiraReleaseBuild.class, this);
    }

    public static enum Status {
        ABORTED(4),
        FAILED(1),
        SUCCEEDED(2),
        UNSTABLE(3);

        private final Integer _id;

        public Integer getID() {
            return this._id;
        }

        private Status(Integer id) {
            this._id = id;
        }
    }
}

