/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.spira;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.spira.IndentLevelSpiraArtifact;
import com.liferay.jenkins.results.parser.spira.PathSpiraArtifact;
import com.liferay.jenkins.results.parser.spira.SearchQuery;
import com.liferay.jenkins.results.parser.spira.SpiraProject;
import com.liferay.jenkins.results.parser.spira.SpiraReleaseBuild;
import com.liferay.jenkins.results.parser.spira.SpiraRestAPIUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class SpiraRelease
extends IndentLevelSpiraArtifact {
    protected static final Integer ARTIFACT_TYPE_ID = 2;
    protected static final String ARTIFACT_TYPE_NAME = "release";
    protected static final String KEY_ID = "ReleaseId";
    private static Pattern _propertyPattern = Pattern.compile(".*\\[(?<jobName>.*?)\\]\\[(?<testSuiteName>.*?)\\]");
    private SpiraRelease _parentSpiraRelease;

    public static SpiraRelease createSpiraRelease(SpiraProject spiraProject, String releaseName) {
        return SpiraRelease.createSpiraRelease(spiraProject, releaseName, null);
    }

    public static SpiraRelease createSpiraRelease(SpiraProject spiraProject, String releaseName, Integer parentReleaseID) {
        String urlPath = "projects/{project_id}/releases{parent_release_id}";
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        if (parentReleaseID == null || parentReleaseID == 0) {
            urlPathReplacements.put("parent_release_id", "");
        } else {
            urlPathReplacements.put("parent_release_id", "/" + parentReleaseID);
        }
        urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
        JSONObject requestJSONObject = new JSONObject();
        requestJSONObject.put("Name", (Object)StringEscapeUtils.unescapeJava((String)releaseName));
        requestJSONObject.put("ReleaseStatusId", (Object)Status.PLANNED.getID());
        requestJSONObject.put("ReleaseTypeId", (Object)Type.MAJOR_RELEASE.getID());
        Calendar calendar = Calendar.getInstance();
        requestJSONObject.put("StartDate", (Object)SpiraRelease.toDateString(calendar));
        calendar.add(2, 1);
        requestJSONObject.put("EndDate", (Object)SpiraRelease.toDateString(calendar));
        try {
            JSONObject responseJSONObject = SpiraRestAPIUtil.requestJSONObject(urlPath, null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.POST, requestJSONObject.toString());
            return spiraProject.getSpiraReleaseByID(responseJSONObject.getInt(KEY_ID));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public static SpiraRelease createSpiraReleaseByPath(SpiraProject spiraProject, String releasePath) {
        List<SpiraRelease> spiraReleases = spiraProject.getSpiraReleasesByPath(releasePath);
        if (!spiraReleases.isEmpty()) {
            return spiraReleases.get(0);
        }
        String releaseName = SpiraRelease.getPathName(releasePath);
        String parentReleasePath = SpiraRelease.getParentPath(releasePath);
        if (parentReleasePath.isEmpty()) {
            return SpiraRelease.createSpiraRelease(spiraProject, releaseName);
        }
        SpiraRelease parentSpiraRelease = SpiraRelease.createSpiraReleaseByPath(spiraProject, parentReleasePath);
        return SpiraRelease.createSpiraRelease(spiraProject, releaseName, parentSpiraRelease.getID());
    }

    public static void deleteSpiraReleaseByID(SpiraProject spiraProject, int releaseID) {
        List<SpiraRelease> spiraReleases = SpiraRelease.getSpiraReleases(spiraProject, new SearchQuery.SearchParameter(KEY_ID, releaseID));
        if (spiraReleases.isEmpty()) {
            return;
        }
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
        urlPathReplacements.put("release_id", String.valueOf(releaseID));
        try {
            SpiraRestAPIUtil.request("projects/{project_id}/releases/{release_id}", null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.DELETE, null);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        SpiraRelease.removeCachedSpiraArtifacts(SpiraRelease.class, spiraReleases);
    }

    public static void deleteSpiraReleasesByPath(SpiraProject spiraProject, String releasePath) {
        List<SpiraRelease> spiraReleases = spiraProject.getSpiraReleasesByPath(releasePath);
        for (SpiraRelease spiraRelease : spiraReleases) {
            SpiraRelease.deleteSpiraReleaseByID(spiraProject, spiraRelease.getID());
        }
    }

    public static int getID(String jobName, String testSuiteName) {
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
            return Integer.parseInt(buildProperties.getProperty("spira.release.id[" + jobName + "][" + testSuiteName + "]"));
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build.properties", ioException);
        }
    }

    public static String getJobNameByID(int id) {
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build.properties", ioException);
        }
        for (Object propertyNameObject : buildProperties.keySet()) {
            String propertyValue;
            String propertyName = propertyNameObject.toString();
            if (!propertyName.startsWith("spira.release.id") || id != Integer.parseInt(propertyValue = buildProperties.getProperty(propertyName))) continue;
            Matcher matcher = _propertyPattern.matcher(propertyName);
            matcher.find();
            return matcher.group("jobName");
        }
        throw new IllegalArgumentException("Invalid Spira release ID");
    }

    public SpiraRelease getParentSpiraRelease() {
        if (this._parentSpiraRelease != null) {
            return this._parentSpiraRelease;
        }
        String indentLevel = this.getIndentLevel();
        if (indentLevel.length() <= 3) {
            return null;
        }
        String parentIndentLevel = indentLevel.substring(0, indentLevel.length() - 3);
        this._parentSpiraRelease = this._getSpiraReleaseByIndentLevel(parentIndentLevel);
        return this._parentSpiraRelease;
    }

    public SpiraReleaseBuild getSpiraReleaseBuildByID(int releaseBuildID) {
        List<SpiraReleaseBuild> spiraReleaseBuilds = SpiraReleaseBuild.getSpiraReleaseBuilds(this.getSpiraProject(), this, new SearchQuery.SearchParameter("BuildId", releaseBuildID));
        if (spiraReleaseBuilds.size() > 1) {
            throw new RuntimeException("Duplicate release build id " + releaseBuildID);
        }
        if (spiraReleaseBuilds.isEmpty()) {
            throw new RuntimeException("Missing release build id " + releaseBuildID);
        }
        return spiraReleaseBuilds.get(0);
    }

    @Override
    public String getURL() {
        SpiraProject spiraProject = this.getSpiraProject();
        return JenkinsResultsParserUtil.combine("https://liferay.spiraservice.net/", String.valueOf(spiraProject.getID()), "/Release/", String.valueOf(this.getID()), ".aspx");
    }

    protected static List<SpiraRelease> getSpiraReleases(final SpiraProject spiraProject, final SearchQuery.SearchParameter ... searchParameters) {
        return SpiraRelease.getSpiraArtifacts(SpiraRelease.class, new Supplier<List<JSONObject>>(){

            @Override
            public List<JSONObject> get() {
                return SpiraRelease._requestSpiraReleases(spiraProject.getID(), searchParameters);
            }
        }, new Function<JSONObject, SpiraRelease>(){

            @Override
            public SpiraRelease apply(JSONObject jsonObject) {
                return new SpiraRelease(jsonObject);
            }
        }, searchParameters);
    }

    @Override
    protected PathSpiraArtifact getParentSpiraArtifact() {
        return this.getParentSpiraRelease();
    }

    private static List<JSONObject> _requestSpiraReleases(int spiraProjectID, SearchQuery.SearchParameter ... searchParameters) {
        HashMap<String, String> urlParameters = new HashMap<String, String>();
        urlParameters.put("number_rows", String.valueOf(15000));
        urlParameters.put("start_row", String.valueOf(1));
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("project_id", String.valueOf(spiraProjectID));
        JSONArray requestJSONArray = new JSONArray();
        for (SearchQuery.SearchParameter searchParameter : searchParameters) {
            requestJSONArray.put((Object)searchParameter.toFilterJSONObject());
        }
        try {
            JSONArray responseJSONArray = SpiraRestAPIUtil.requestJSONArray("projects/{project_id}/releases/search", urlParameters, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.POST, requestJSONArray.toString());
            ArrayList<JSONObject> spiraReleases = new ArrayList<JSONObject>();
            for (int i = 0; i < responseJSONArray.length(); ++i) {
                spiraReleases.add(responseJSONArray.getJSONObject(i));
            }
            return spiraReleases;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private SpiraRelease(JSONObject jsonObject) {
        super(jsonObject);
        SpiraRelease.cacheSpiraArtifact(SpiraRelease.class, this);
    }

    private SpiraRelease _getSpiraReleaseByIndentLevel(String indentLevel) {
        List<SpiraRelease> spiraReleases = SpiraRelease.getSpiraReleases(this.getSpiraProject(), new SearchQuery.SearchParameter("IndentLevel", indentLevel));
        if (spiraReleases.size() > 1) {
            throw new RuntimeException("Duplicate indent level " + indentLevel);
        }
        if (spiraReleases.isEmpty()) {
            throw new RuntimeException("Missing indent level " + indentLevel);
        }
        return spiraReleases.get(0);
    }

    public static enum Type {
        MAJOR_RELEASE(1),
        MINOR_RELEASE(2),
        PHASE(4),
        SPRINT(3);

        private final Integer _id;

        public Integer getID() {
            return this._id;
        }

        private Type(Integer id) {
            this._id = id;
        }
    }

    public static enum Status {
        CANCELED(5),
        CLOSED(3),
        DEFERRED(4),
        IN_PROGRESS(2),
        PLANNED(1);

        private final Integer _id;

        public Integer getID() {
            return this._id;
        }

        private Status(Integer id) {
            this._id = id;
        }
    }
}

