/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.spira;

import com.liferay.jenkins.results.parser.spira.BaseSpiraArtifact;
import com.liferay.jenkins.results.parser.spira.IntegerSpiraCustomPropertyValue;
import com.liferay.jenkins.results.parser.spira.ListSpiraCustomPropertyValue;
import com.liferay.jenkins.results.parser.spira.MultiListSpiraCustomPropertyValue;
import com.liferay.jenkins.results.parser.spira.SpiraCustomListValue;
import com.liferay.jenkins.results.parser.spira.SpiraCustomProperty;
import com.liferay.jenkins.results.parser.spira.SpiraProject;
import com.liferay.jenkins.results.parser.spira.SpiraTestCaseProductVersion;
import com.liferay.jenkins.results.parser.spira.TextSpiraCustomPropertyValue;
import org.json.JSONObject;

public abstract class SpiraCustomPropertyValue<T>
extends BaseSpiraArtifact {
    protected static final String KEY_ID = "CustomPropertyValueId";
    private final SpiraCustomProperty _spiraCustomProperty;

    public static SpiraCustomPropertyValue<?> createSpiraCustomPropertyValue(SpiraCustomProperty spiraCustomProperty, String value) {
        if (value == null) {
            throw new RuntimeException("Invalid value " + value);
        }
        String spiraCustomPropertyName = spiraCustomProperty.getName();
        if (spiraCustomPropertyName.equals("Product Version")) {
            return new SpiraTestCaseProductVersion(spiraCustomProperty, value);
        }
        SpiraCustomProperty.Type spiraCustomPropertyType = spiraCustomProperty.getType();
        if (spiraCustomPropertyType == SpiraCustomProperty.Type.INTEGER) {
            if (!value.matches("\\d+")) {
                throw new RuntimeException("Invalid integer value " + value);
            }
            return new IntegerSpiraCustomPropertyValue(Integer.valueOf(value), spiraCustomProperty);
        }
        if (spiraCustomPropertyType == SpiraCustomProperty.Type.LIST) {
            return new ListSpiraCustomPropertyValue(SpiraCustomListValue.createSpiraCustomListValue(spiraCustomProperty.getSpiraProject(), spiraCustomProperty.getSpiraCustomList(), value), spiraCustomProperty);
        }
        if (spiraCustomPropertyType == SpiraCustomProperty.Type.MULTILIST) {
            return new MultiListSpiraCustomPropertyValue(SpiraCustomListValue.createSpiraCustomListValue(spiraCustomProperty.getSpiraProject(), spiraCustomProperty.getSpiraCustomList(), value), spiraCustomProperty);
        }
        if (spiraCustomPropertyType == SpiraCustomProperty.Type.TEXT) {
            return new TextSpiraCustomPropertyValue(value, spiraCustomProperty);
        }
        throw new RuntimeException("Unsupported custom property type " + (Object)((Object)spiraCustomPropertyType));
    }

    public static SpiraCustomPropertyValue<?> getSpiraCustomPropertyValue(SpiraCustomProperty spiraCustomProperty, JSONObject valueJSONObject) {
        String spiraCustomPropertyName = spiraCustomProperty.getName();
        if (spiraCustomPropertyName.equals("Product Version")) {
            return new SpiraTestCaseProductVersion(valueJSONObject, spiraCustomProperty);
        }
        SpiraCustomProperty.Type spiraCustomPropertyType = spiraCustomProperty.getType();
        if (spiraCustomPropertyType == SpiraCustomProperty.Type.INTEGER) {
            return new IntegerSpiraCustomPropertyValue(valueJSONObject, spiraCustomProperty);
        }
        if (spiraCustomPropertyType == SpiraCustomProperty.Type.LIST) {
            return new ListSpiraCustomPropertyValue(valueJSONObject, spiraCustomProperty);
        }
        if (spiraCustomPropertyType == SpiraCustomProperty.Type.MULTILIST) {
            return new MultiListSpiraCustomPropertyValue(valueJSONObject, spiraCustomProperty);
        }
        if (spiraCustomPropertyType == SpiraCustomProperty.Type.TEXT) {
            return new TextSpiraCustomPropertyValue(valueJSONObject, spiraCustomProperty);
        }
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SpiraCustomPropertyValue)) {
            return false;
        }
        SpiraCustomPropertyValue spiraCustomPropertyValue = (SpiraCustomPropertyValue)object;
        SpiraCustomProperty spiraCustomProperty = spiraCustomPropertyValue.getSpiraCustomProperty();
        if (!spiraCustomProperty.equals(this.getSpiraCustomProperty())) {
            return false;
        }
        String valueString = spiraCustomPropertyValue.getValueString();
        return valueString.equals(this.getValueString());
    }

    @Override
    public String getName() {
        SpiraCustomProperty spiraCustomProperty = this.getSpiraCustomProperty();
        return spiraCustomProperty.getName();
    }

    public int getPropertyNumber() {
        SpiraCustomProperty spiraCustomProperty = this.getSpiraCustomProperty();
        return spiraCustomProperty.getPropertyNumber();
    }

    public SpiraCustomProperty getSpiraCustomProperty() {
        return this._spiraCustomProperty;
    }

    public SpiraCustomProperty.Type getSpiraCustomPropertyType() {
        return this._spiraCustomProperty.getType();
    }

    @Override
    public SpiraProject getSpiraProject() {
        SpiraCustomProperty spiraCustomProperty = this.getSpiraCustomProperty();
        return spiraCustomProperty.getSpiraProject();
    }

    @Override
    public String getURL() {
        SpiraCustomProperty spiraCustomProperty = this.getSpiraCustomProperty();
        return spiraCustomProperty.getURL();
    }

    public abstract T getValue();

    public String getValueString() {
        return String.valueOf(this.getValue());
    }

    @Override
    public int hashCode() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getSpiraCustomProperty());
        sb.append("_");
        sb.append(this.getValueString());
        return sb.hashCode();
    }

    protected SpiraCustomPropertyValue(JSONObject jsonObject, SpiraCustomProperty spiraCustomProperty) {
        super(jsonObject);
        this._spiraCustomProperty = spiraCustomProperty;
    }

    protected JSONObject getCustomPropertyJSONObject() {
        JSONObject customPropertyJSONObject = new JSONObject();
        customPropertyJSONObject.put("PropertyNumber", this.getPropertyNumber());
        return customPropertyJSONObject;
    }

    protected JSONObject getDefinitionJSONObject() {
        SpiraProject spiraProject = this.getSpiraProject();
        SpiraCustomProperty spiraCustomProperty = this.getSpiraCustomProperty();
        SpiraCustomProperty.Type spiraCustomPropertyType = spiraCustomProperty.getType();
        JSONObject definitionJSONObject = new JSONObject();
        definitionJSONObject.put("ArtifactTypeId", spiraCustomProperty.getArtifactTypeId());
        definitionJSONObject.put("CustomPropertyFieldName", (Object)spiraCustomProperty.getFieldName());
        definitionJSONObject.put("CustomPropertyId", spiraCustomProperty.getID());
        definitionJSONObject.put("CustomPropertyTypeId", (Object)spiraCustomPropertyType.getID());
        definitionJSONObject.put("CustomPropertyTypeName", (Object)spiraCustomPropertyType.getName());
        definitionJSONObject.put("Name", (Object)spiraCustomProperty.getName());
        definitionJSONObject.put("ProjectTemplateId", (Object)spiraProject.getProjectTemplateID());
        definitionJSONObject.put("PropertyNumber", spiraCustomProperty.getPropertyNumber());
        return definitionJSONObject;
    }

    protected JSONObject getFilterJSONObject() {
        JSONObject filterJSONObject = new JSONObject();
        SpiraCustomProperty spiraCustomProperty = this.getSpiraCustomProperty();
        filterJSONObject.put("PropertyName", (Object)spiraCustomProperty.getFieldName());
        return filterJSONObject;
    }

    protected abstract boolean matchesJSONObject(JSONObject var1);
}

