/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.spira;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.spira.BaseSpiraArtifact;
import com.liferay.jenkins.results.parser.spira.SearchQuery;
import com.liferay.jenkins.results.parser.spira.SpiraArtifact;
import com.liferay.jenkins.results.parser.spira.SpiraCustomList;
import com.liferay.jenkins.results.parser.spira.SpiraProject;
import com.liferay.jenkins.results.parser.spira.SpiraRestAPIUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.json.JSONArray;
import org.json.JSONObject;

public class SpiraCustomProperty
extends BaseSpiraArtifact {
    protected static final String ARTIFACT_TYPE_NAME = "customproperty";
    protected static final String KEY_ID = "CustomPropertyId";
    private final Class<? extends SpiraArtifact> _spiraArtifactClass;

    public static SpiraCustomProperty createSpiraCustomProperty(SpiraProject spiraProject, Class<? extends SpiraArtifact> spiraArtifactClass, String customPropertyName, Type type) {
        return SpiraCustomProperty.createSpiraCustomProperty(spiraProject, spiraArtifactClass, customPropertyName, type, false);
    }

    public static SpiraCustomProperty createSpiraCustomProperty(SpiraProject spiraProject, Class<? extends SpiraArtifact> spiraArtifactClass, String customPropertyName, Type type, boolean enableRichText) {
        List<SpiraCustomProperty> spiraCustomProperties = SpiraCustomProperty.getSpiraCustomProperties(spiraProject, spiraArtifactClass, new SearchQuery.SearchParameter("Name", customPropertyName));
        if (!spiraCustomProperties.isEmpty()) {
            return spiraCustomProperties.get(0);
        }
        SpiraCustomList spiraCustomList = SpiraCustomList.createSpiraCustomListByName(spiraProject, spiraArtifactClass, customPropertyName);
        HashMap<String, String> urlParameters = new HashMap<String, String>();
        urlParameters.put("custom_list_id", String.valueOf(spiraCustomList.getID()));
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        Integer projectTemplateID = spiraProject.getProjectTemplateID();
        urlPathReplacements.put("project_template_id", String.valueOf(projectTemplateID));
        JSONObject requestJSONObject = new JSONObject();
        requestJSONObject.put("ArtifactTypeId", SpiraCustomProperty.getArtifactTypeID(spiraArtifactClass));
        requestJSONObject.put("CustomPropertyTypeId", (Object)type.getID());
        requestJSONObject.put("Name", (Object)customPropertyName);
        if (enableRichText) {
            JSONArray optionsJSONArray = new JSONArray();
            JSONObject enableRichTextJSONObject = new JSONObject();
            enableRichTextJSONObject.put("CustomPropertyOptionId", 4);
            enableRichTextJSONObject.put("Value", (Object)"Y");
            optionsJSONArray.put((Object)enableRichTextJSONObject);
            requestJSONObject.put("Options", (Object)optionsJSONArray);
        }
        requestJSONObject.put("ProjectTemplateId", (Object)projectTemplateID);
        spiraCustomProperties = SpiraCustomProperty.getSpiraCustomProperties(spiraProject, spiraArtifactClass, new SearchQuery.SearchParameter[0]);
        Integer positionNumber = SpiraCustomProperty._getNextPositionNumber(spiraCustomProperties);
        if (positionNumber == null) {
            throw new RuntimeException("Could not find valid position number");
        }
        requestJSONObject.put("PropertyNumber", (Object)positionNumber);
        try {
            SpiraRestAPIUtil.requestJSONObject("project-templates/{project_template_id}/custom-properties", urlParameters, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.POST, requestJSONObject.toString());
            SpiraCustomProperty spiraCustomProperty = spiraProject.getSpiraCustomPropertyByName(spiraArtifactClass, customPropertyName);
            SearchQuery.clearSearchQueries(SpiraCustomProperty.class);
            return spiraCustomProperty;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public static void deleteSpiraCustomPropertyByName(SpiraProject spiraProject, Class<? extends SpiraArtifact> spiraArtifactClass, String customPropertyName) {
        List<SpiraCustomProperty> spiraCustomProperties = SpiraCustomProperty.getSpiraCustomProperties(spiraProject, spiraArtifactClass, new SearchQuery.SearchParameter("Name", customPropertyName));
        if (spiraCustomProperties.isEmpty()) {
            return;
        }
        for (SpiraCustomProperty spiraCustomProperty : spiraCustomProperties) {
            HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
            urlPathReplacements.put("custom_property_id", String.valueOf(spiraCustomProperty.getID()));
            urlPathReplacements.put("project_template_id", String.valueOf(spiraProject.getProjectTemplateID()));
            try {
                SpiraRestAPIUtil.request("project-templates/{project_template_id}/custom-properties/{custom_property_id}", null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.DELETE, null);
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }
    }

    public int getArtifactTypeId() {
        return this.jsonObject.getInt("ArtifactTypeId");
    }

    public String getFieldName() {
        return this.jsonObject.getString("CustomPropertyFieldName");
    }

    public int getPropertyNumber() {
        return this.jsonObject.getInt("PropertyNumber");
    }

    public Class<? extends SpiraArtifact> getSpiraArtifactClass() {
        return this._spiraArtifactClass;
    }

    public SpiraCustomList getSpiraCustomList() {
        if (this.getType() != Type.LIST && this.getType() != Type.MULTILIST) {
            return null;
        }
        JSONObject customListJSONObject = this.jsonObject.optJSONObject("CustomList");
        if (customListJSONObject == null || customListJSONObject == JSONObject.NULL) {
            return null;
        }
        return SpiraCustomList.createSpiraCustomListByName(this.getSpiraProject(), this._spiraArtifactClass, customListJSONObject.getString("Name"));
    }

    public Type getType() {
        return Type.get(this.jsonObject.getInt("CustomPropertyTypeId"));
    }

    @Override
    public String getURL() {
        SpiraProject spiraProject = this.getSpiraProject();
        return JenkinsResultsParserUtil.combine("https://liferay.spiraservice.net/", "/pt/", String.valueOf(spiraProject.getProjectTemplateID()), "/Administration/CustomProperties.aspx?artifactTypeId=", String.valueOf(this.getArtifactTypeId()));
    }

    protected static List<SpiraCustomProperty> getSpiraCustomProperties(final SpiraProject spiraProject, final Class<? extends SpiraArtifact> spiraArtifactClass, SearchQuery.SearchParameter ... searchParameters) {
        SearchQuery.SearchParameter[] customSearchParameters = new SearchQuery.SearchParameter[searchParameters.length + 2];
        customSearchParameters[0] = new SearchQuery.SearchParameter("ProjectId", spiraProject.getID());
        customSearchParameters[1] = new SearchQuery.SearchParameter("ArtifactTypeName", SpiraCustomProperty.getArtifactTypeName(spiraArtifactClass));
        for (int i = 0; i < searchParameters.length; ++i) {
            customSearchParameters[i + 2] = searchParameters[i];
        }
        return SpiraCustomProperty.getSpiraArtifacts(SpiraCustomProperty.class, new Supplier<List<JSONObject>>(){

            @Override
            public List<JSONObject> get() {
                return SpiraCustomProperty._requestSpiraCustomProperties(spiraProject, spiraArtifactClass);
            }
        }, new Function<JSONObject, SpiraCustomProperty>(){

            @Override
            public SpiraCustomProperty apply(JSONObject jsonObject) {
                return new SpiraCustomProperty(jsonObject, spiraProject, spiraArtifactClass);
            }
        }, customSearchParameters);
    }

    private static Integer _getNextPositionNumber(List<SpiraCustomProperty> spiraCustomProperties) {
        for (int i = 1; i <= spiraCustomProperties.size(); ++i) {
            SpiraCustomProperty positionedSpiraCustomProperty = null;
            for (SpiraCustomProperty spiraCustomProperty : spiraCustomProperties) {
                if (spiraCustomProperty.getPropertyNumber() != i) continue;
                positionedSpiraCustomProperty = spiraCustomProperty;
                break;
            }
            if (positionedSpiraCustomProperty != null) continue;
            return i;
        }
        return spiraCustomProperties.size() + 1;
    }

    private static List<JSONObject> _requestSpiraCustomProperties(SpiraProject spiraProject, Class<? extends SpiraArtifact> spiraArtifactClass) {
        ArrayList<JSONObject> spiraCustomProperties = new ArrayList<JSONObject>();
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("artifact_type_name", SpiraCustomProperty.getArtifactTypeName(spiraArtifactClass));
        urlPathReplacements.put("project_template_id", String.valueOf(spiraProject.getProjectTemplateID()));
        try {
            JSONArray responseJSONArray = SpiraRestAPIUtil.requestJSONArray("project-templates/{project_template_id}/custom-properties/{artifact_type_name}", null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.GET, null);
            for (int i = 0; i < responseJSONArray.length(); ++i) {
                JSONObject responseJSONObject = responseJSONArray.getJSONObject(i);
                responseJSONObject.put("ProjectId", spiraProject.getID());
                spiraCustomProperties.add(responseJSONObject);
            }
            return spiraCustomProperties;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private SpiraCustomProperty(JSONObject jsonObject, SpiraProject spiraProject, Class<? extends SpiraArtifact> spiraArtifactClass) {
        super(jsonObject);
        this._spiraArtifactClass = spiraArtifactClass;
        jsonObject.put("ArtifactTypeName", (Object)SpiraCustomProperty.getArtifactTypeName(spiraArtifactClass));
        jsonObject.put("ProjectId", spiraProject.getID());
        SpiraCustomProperty.cacheSpiraArtifact(SpiraCustomProperty.class, this);
    }

    public static enum Type {
        BOOLEAN(4, "Boolean"),
        DATE(5, "Date"),
        DECIMAL(3, "Decimal"),
        INTEGER(2, "Integer"),
        LIST(6, "List"),
        MULTILIST(7, "MultiList"),
        TEXT(1, "Text"),
        USER(8, "User");

        private static Map<Integer, Type> _types;
        private final Integer _id;
        private final String _name;

        public static Type get(Integer id) {
            return _types.get(id);
        }

        public Integer getID() {
            return this._id;
        }

        public String getName() {
            return this._name;
        }

        private Type(Integer id, String name) {
            this._id = id;
            this._name = name;
        }

        static {
            _types = new HashMap<Integer, Type>();
            for (Type type : Type.values()) {
                _types.put(type.getID(), type);
            }
        }
    }
}

