/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.spira;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.spira.BaseSpiraArtifact;
import com.liferay.jenkins.results.parser.spira.SpiraCustomList;
import com.liferay.jenkins.results.parser.spira.SpiraProject;
import com.liferay.jenkins.results.parser.spira.SpiraRestAPIUtil;
import java.io.IOException;
import java.util.HashMap;
import org.json.JSONObject;

public class SpiraCustomListValue
extends BaseSpiraArtifact {
    protected static final String KEY_ID = "CustomPropertyValueId";
    private final SpiraCustomList _spiraCustomList;

    public static SpiraCustomListValue createSpiraCustomListValue(SpiraProject spiraProject, SpiraCustomList spiraCustomList, String value) {
        SpiraCustomListValue spiraCustomListValue = spiraCustomList.getSpiraCustomListValueByName(value);
        if (spiraCustomListValue != null) {
            return spiraCustomListValue;
        }
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("custom_list_id", String.valueOf(spiraCustomList.getID()));
        urlPathReplacements.put("project_template_id", String.valueOf(spiraProject.getProjectTemplateID()));
        JSONObject requestJSONObject = new JSONObject();
        requestJSONObject.put("Active", true);
        requestJSONObject.put("CustomPropertyListId", spiraCustomList.getID());
        requestJSONObject.put("Name", (Object)value);
        requestJSONObject.put("ProjectId", spiraProject.getID());
        try {
            spiraCustomListValue = new SpiraCustomListValue(SpiraRestAPIUtil.requestJSONObject("project-templates/{project_template_id}/custom-lists/{custom_list_id}/values", null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.POST, requestJSONObject.toString()), spiraProject, spiraCustomList);
            spiraCustomList.addSpiraCustomListValue(spiraCustomListValue);
            return spiraCustomListValue;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public SpiraCustomList getSpiraCustomList() {
        return this._spiraCustomList;
    }

    @Override
    public String getURL() {
        SpiraCustomList spiraCustomList = this.getSpiraCustomList();
        return spiraCustomList.getURL();
    }

    protected SpiraCustomListValue(JSONObject jsonObject, SpiraProject spiraProject, SpiraCustomList spiraCustomList) {
        super(jsonObject);
        jsonObject.put("ProjectId", spiraProject.getID());
        this._spiraCustomList = spiraCustomList;
    }
}

