/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.spira;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.spira.BaseSpiraArtifact;
import com.liferay.jenkins.results.parser.spira.SearchQuery;
import com.liferay.jenkins.results.parser.spira.SpiraArtifact;
import com.liferay.jenkins.results.parser.spira.SpiraCustomListValue;
import com.liferay.jenkins.results.parser.spira.SpiraCustomProperty;
import com.liferay.jenkins.results.parser.spira.SpiraProject;
import com.liferay.jenkins.results.parser.spira.SpiraRestAPIUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.json.JSONArray;
import org.json.JSONObject;

public class SpiraCustomList
extends BaseSpiraArtifact {
    protected static final String ARTIFACT_TYPE_NAME = "custompropertylist";
    protected static final String KEY_ID = "CustomPropertyListId";
    private final Class<? extends SpiraArtifact> _spiraArtifactClass;

    public static SpiraCustomList createSpiraCustomListByName(SpiraProject spiraProject, Class<? extends SpiraArtifact> spiraArtifactClass, String customListName) {
        List<SpiraCustomList> spiraCustomLists = SpiraCustomList.getSpiraCustomLists(spiraProject, spiraArtifactClass, new SearchQuery.SearchParameter("Name", customListName));
        if (!spiraCustomLists.isEmpty()) {
            return spiraCustomLists.get(0);
        }
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        Integer projectTemplateID = spiraProject.getProjectTemplateID();
        urlPathReplacements.put("project_template_id", String.valueOf(projectTemplateID));
        JSONObject requestJSONObject = new JSONObject();
        requestJSONObject.put("Active", true);
        requestJSONObject.put("Name", (Object)customListName);
        requestJSONObject.put("ProjectTemplateId", (Object)projectTemplateID);
        requestJSONObject.put("SortedOnValue", true);
        try {
            return new SpiraCustomList(SpiraRestAPIUtil.requestJSONObject("project-templates/{project_template_id}/custom-lists", null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.POST, requestJSONObject.toString()), spiraProject, spiraArtifactClass);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public SpiraCustomListValue getSpiraCustomListValueByID(int id) {
        for (SpiraCustomListValue spiraCustomListValue : this.getSpiraCustomListValues()) {
            if (id != spiraCustomListValue.getID()) continue;
            return spiraCustomListValue;
        }
        return null;
    }

    public SpiraCustomListValue getSpiraCustomListValueByName(String name) {
        for (SpiraCustomListValue spiraCustomListValue : this.getSpiraCustomListValues()) {
            if (!name.equals(spiraCustomListValue.getName())) continue;
            return spiraCustomListValue;
        }
        return null;
    }

    public List<SpiraCustomListValue> getSpiraCustomListValues() {
        SpiraProject spiraProject = this.getSpiraProject();
        List<SpiraCustomProperty> spiraCustomProperties = SpiraCustomProperty.getSpiraCustomProperties(spiraProject, this._spiraArtifactClass, new SearchQuery.SearchParameter("Name", this.getName()));
        if (spiraCustomProperties.isEmpty()) {
            return new ArrayList<SpiraCustomListValue>();
        }
        ArrayList<SpiraCustomListValue> spiraCustomListValues = new ArrayList<SpiraCustomListValue>();
        SpiraCustomProperty spiraCustomProperty = spiraCustomProperties.get(0);
        JSONObject spiraCustomPropertyJSONObject = spiraCustomProperty.toJSONObject();
        JSONObject customListJSONObject = spiraCustomPropertyJSONObject.optJSONObject("CustomList");
        if (customListJSONObject != JSONObject.NULL) {
            JSONArray valuesJSONArray = customListJSONObject.getJSONArray("Values");
            for (int i = 0; i < valuesJSONArray.length(); ++i) {
                JSONObject valueJSONObject = valuesJSONArray.getJSONObject(i);
                spiraCustomListValues.add(new SpiraCustomListValue(valueJSONObject, spiraProject, this));
            }
        }
        return spiraCustomListValues;
    }

    @Override
    public String getURL() {
        SpiraProject spiraProject = this.getSpiraProject();
        return JenkinsResultsParserUtil.combine("https://liferay.spiraservice.net/", "/pt/", String.valueOf(spiraProject.getProjectTemplateID()), "/Administration/CustomListDetails.aspx?customPropertyListId=", String.valueOf(this.getID()));
    }

    protected static List<SpiraCustomList> getSpiraCustomLists(final SpiraProject spiraProject, final Class<? extends SpiraArtifact> spiraArtifactClass, SearchQuery.SearchParameter ... searchParameters) {
        SearchQuery.SearchParameter[] customSearchParameters = new SearchQuery.SearchParameter[searchParameters.length + 1];
        customSearchParameters[0] = new SearchQuery.SearchParameter("ProjectId", spiraProject.getID());
        for (int i = 0; i < searchParameters.length; ++i) {
            customSearchParameters[i + 1] = searchParameters[i];
        }
        return SpiraCustomList.getSpiraArtifacts(SpiraCustomList.class, new Supplier<List<JSONObject>>(){

            @Override
            public List<JSONObject> get() {
                return SpiraCustomList._requestSpiraCustomLists(spiraProject);
            }
        }, new Function<JSONObject, SpiraCustomList>(){

            @Override
            public SpiraCustomList apply(JSONObject jsonObject) {
                return new SpiraCustomList(jsonObject, spiraProject, spiraArtifactClass);
            }
        }, customSearchParameters);
    }

    protected void addSpiraCustomListValue(SpiraCustomListValue spiraCustomListValue) {
        List<SpiraCustomListValue> spiraCustomListValues = this.getSpiraCustomListValues();
        spiraCustomListValues.add(spiraCustomListValue);
    }

    private static List<JSONObject> _requestSpiraCustomLists(SpiraProject spiraProject) {
        ArrayList<JSONObject> spiraCustomLists = new ArrayList<JSONObject>();
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("project_template_id", String.valueOf(spiraProject.getProjectTemplateID()));
        try {
            JSONArray responseJSONArray = SpiraRestAPIUtil.requestJSONArray("project-templates/{project_template_id}/custom-lists", null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.GET, null);
            for (int i = 0; i < responseJSONArray.length(); ++i) {
                JSONObject responseJSONObject = responseJSONArray.getJSONObject(i);
                responseJSONObject.put("ProjectId", spiraProject.getID());
                spiraCustomLists.add(responseJSONObject);
            }
            return spiraCustomLists;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private SpiraCustomList(JSONObject jsonObject, SpiraProject spiraProject, Class<? extends SpiraArtifact> spiraArtifactClass) {
        super(jsonObject);
        jsonObject.put("ProjectId", spiraProject.getID());
        this._spiraArtifactClass = spiraArtifactClass;
        SpiraCustomList.cacheSpiraArtifact(SpiraCustomList.class, this);
    }
}

