/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.spira;

import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsNode;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.spira.BaseSpiraArtifact;
import com.liferay.jenkins.results.parser.spira.SearchQuery;
import com.liferay.jenkins.results.parser.spira.SpiraCustomProperty;
import com.liferay.jenkins.results.parser.spira.SpiraCustomPropertyValue;
import com.liferay.jenkins.results.parser.spira.SpiraProject;
import com.liferay.jenkins.results.parser.spira.SpiraRestAPIUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class SpiraAutomationHost
extends BaseSpiraArtifact {
    protected static final Integer ARTIFACT_TYPE_ID = 9;
    protected static final String ARTIFACT_TYPE_NAME = "automationhost";
    protected static final String KEY_ID = "AutomationHostId";

    public static SpiraAutomationHost createSpiraAutomationHost(SpiraProject spiraProject, JenkinsNode jenkinsNode) {
        String automationHostName = jenkinsNode.getName();
        List<SpiraAutomationHost> spiraAutomationHosts = SpiraAutomationHost.getSpiraAutomationHosts(spiraProject, new SearchQuery.SearchParameter("Name", automationHostName));
        if (!spiraAutomationHosts.isEmpty()) {
            return spiraAutomationHosts.get(0);
        }
        String urlPath = "projects/{project_id}/automation-hosts";
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
        JSONObject requestJSONObject = new JSONObject();
        requestJSONObject.put("Active", true);
        requestJSONObject.put("Name", (Object)StringEscapeUtils.unescapeJava((String)automationHostName));
        requestJSONObject.put("Token", (Object)JenkinsResultsParserUtil.getDistinctTimeStamp());
        JSONArray customPropertiesJSONArray = new JSONArray();
        JenkinsMaster jenkinsMaster = jenkinsNode.getJenkinsMaster();
        SpiraCustomProperty jenkinsMasterSpiraCustomProperty = SpiraCustomProperty.createSpiraCustomProperty(spiraProject, SpiraAutomationHost.class, "Jenkins Master", SpiraCustomProperty.Type.LIST);
        SpiraCustomPropertyValue<?> jenkinsMasterSpiraCustomPropertyValue = SpiraCustomPropertyValue.createSpiraCustomPropertyValue(jenkinsMasterSpiraCustomProperty, jenkinsMaster.getName());
        customPropertiesJSONArray.put((Object)jenkinsMasterSpiraCustomPropertyValue.getCustomPropertyJSONObject());
        requestJSONObject.put("CustomProperties", (Object)customPropertiesJSONArray);
        try {
            SpiraRestAPIUtil.requestJSONObject(urlPath, null, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.POST, requestJSONObject.toString());
            return spiraProject.getSpiraAutomationHostByName(automationHostName);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public String getURL() {
        SpiraProject spiraProject = this.getSpiraProject();
        return JenkinsResultsParserUtil.combine("https://liferay.spiraservice.net/", String.valueOf(spiraProject.getID()), "/AutomationHost/", String.valueOf(this.getID()), ".aspx");
    }

    protected static List<SpiraAutomationHost> getSpiraAutomationHosts(final SpiraProject spiraProject, SearchQuery.SearchParameter ... searchParameters) {
        return SpiraAutomationHost.getSpiraArtifacts(SpiraAutomationHost.class, new Supplier<List<JSONObject>>(){

            @Override
            public List<JSONObject> get() {
                return SpiraAutomationHost._requestSpiraAutomationHosts(spiraProject);
            }
        }, new Function<JSONObject, SpiraAutomationHost>(){

            @Override
            public SpiraAutomationHost apply(JSONObject jsonObject) {
                return new SpiraAutomationHost(jsonObject);
            }
        }, searchParameters);
    }

    private static List<JSONObject> _requestSpiraAutomationHosts(SpiraProject spiraProject) {
        ArrayList<JSONObject> spiraTestCaseTypes = new ArrayList<JSONObject>();
        HashMap<String, String> urlPathReplacements = new HashMap<String, String>();
        urlPathReplacements.put("project_id", String.valueOf(spiraProject.getID()));
        HashMap<String, String> urlParameters = new HashMap<String, String>();
        urlParameters.put("number_of_rows", "2000");
        urlParameters.put("sort_direction", "ASC");
        urlParameters.put("sort_field", "Name");
        urlParameters.put("starting_row", "0");
        JSONArray requestJSONArray = new JSONArray();
        try {
            JSONArray responseJSONArray = SpiraRestAPIUtil.requestJSONArray("projects/{project_id}/automation-hosts/search", urlParameters, urlPathReplacements, JenkinsResultsParserUtil.HttpRequestMethod.POST, requestJSONArray.toString());
            for (int i = 0; i < responseJSONArray.length(); ++i) {
                JSONObject responseJSONObject = responseJSONArray.getJSONObject(i);
                responseJSONObject.put("ProjectId", spiraProject.getID());
                spiraTestCaseTypes.add(responseJSONObject);
            }
            return spiraTestCaseTypes;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private SpiraAutomationHost(JSONObject jsonObject) {
        super(jsonObject);
        SpiraAutomationHost.cacheSpiraArtifact(SpiraAutomationHost.class, this);
    }
}

