/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.spira;

import com.liferay.jenkins.results.parser.spira.SpiraArtifact;
import com.liferay.jenkins.results.parser.spira.SpiraCustomProperty;
import com.liferay.jenkins.results.parser.spira.SpiraCustomPropertyValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONObject;

public class SearchQuery<T extends SpiraArtifact> {
    private static final Map<Class<?>, List<SearchQuery<?>>> _searchQueriesMap = Collections.synchronizedMap(new HashMap());
    private final SearchParameter[] _searchParameters;
    private final Class<T> _spiraArtifactClass;
    private final List<T> _spiraArtifacts = new ArrayList<T>();

    public boolean equals(Object object) {
        if (!(object instanceof SearchQuery)) {
            return false;
        }
        SearchQuery searchQuery = (SearchQuery)object;
        return this.matches(searchQuery.getSearchParameters());
    }

    public SearchParameter[] getSearchParameters() {
        return this._searchParameters;
    }

    public boolean matches(SearchParameter[] searchParameters) {
        JSONArray jsonArray = new JSONArray();
        for (SearchParameter searchParameter : searchParameters) {
            jsonArray.put((Object)searchParameter.toJSONObject());
        }
        return jsonArray.similar((Object)this.toJSONArray());
    }

    protected static void cacheSearchQuery(SearchQuery<?> searchQuery) {
        List cachedSearchQueries = SearchQuery._getCachedSearchQueries(searchQuery._spiraArtifactClass);
        cachedSearchQueries.add(searchQuery);
    }

    protected static void clearSearchQueries(Class<? extends SpiraArtifact> spiraArtifactClass) {
        List<SearchQuery<? extends SpiraArtifact>> cachedSearchQueries = SearchQuery._getCachedSearchQueries(spiraArtifactClass);
        cachedSearchQueries.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static SearchQuery<?> getCachedSearchQuery(Class<?> spiraArtifactClass, SearchParameter ... searchParameters) {
        List<SearchQuery<?>> cachedSearchQueries;
        List<SearchQuery<?>> list = cachedSearchQueries = SearchQuery._getCachedSearchQueries(spiraArtifactClass);
        synchronized (list) {
            for (SearchQuery<?> cachedSearchQuery : cachedSearchQueries) {
                if (!cachedSearchQuery.matches(searchParameters)) continue;
                return cachedSearchQuery;
            }
        }
        return null;
    }

    protected SearchQuery(Class<T> spiraArtifactClass, SearchParameter ... searchParameters) {
        this._spiraArtifactClass = spiraArtifactClass;
        this._searchParameters = searchParameters;
    }

    protected void addSpiraArtifact(T spiraArtifact) {
        this._spiraArtifacts.add(spiraArtifact);
    }

    protected SearchParameter getSearchParameter(String searchParameterName) {
        for (SearchParameter searchParameter : this._searchParameters) {
            if (!searchParameterName.equals(searchParameter.getName())) continue;
            return searchParameter;
        }
        return null;
    }

    protected List<T> getSpiraArtifacts() {
        return this._spiraArtifacts;
    }

    protected boolean hasSearchParameter(String searchParameterName) {
        for (SearchParameter searchParameter : this._searchParameters) {
            if (!searchParameterName.equals(searchParameter.getName())) continue;
            return true;
        }
        return false;
    }

    protected boolean isEmpty() {
        List<T> spiraArtifacts = this.getSpiraArtifacts();
        return spiraArtifacts.isEmpty();
    }

    protected boolean matches(Class<? extends SpiraArtifact> spiraArtifactClass, JSONObject jsonObject) {
        if (spiraArtifactClass != this._spiraArtifactClass) {
            return false;
        }
        for (SearchParameter searchParameter : this._searchParameters) {
            if (searchParameter.matches(jsonObject)) continue;
            return false;
        }
        return true;
    }

    protected boolean matches(SpiraArtifact spiraArtifact) {
        return this.matches(spiraArtifact.getClass(), spiraArtifact.toJSONObject());
    }

    protected JSONArray toFilterJSONArray() {
        JSONArray filterJSONArray = new JSONArray();
        for (SearchParameter searchParameter : this._searchParameters) {
            filterJSONArray.put((Object)searchParameter.toFilterJSONObject());
        }
        return filterJSONArray;
    }

    protected JSONArray toJSONArray() {
        JSONArray jsonArray = new JSONArray();
        for (SearchParameter searchParameter : this._searchParameters) {
            jsonArray.put((Object)searchParameter.toJSONObject());
        }
        return jsonArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<SearchQuery<?>> _getCachedSearchQueries(Class<?> spiraArtifactClass) {
        Map<Class<?>, List<SearchQuery<?>>> map = _searchQueriesMap;
        synchronized (map) {
            List<SearchQuery<Object>> cachedSearchQueries = _searchQueriesMap.get(spiraArtifactClass);
            if (cachedSearchQueries == null) {
                cachedSearchQueries = Collections.synchronizedList(new ArrayList());
                _searchQueriesMap.put(spiraArtifactClass, cachedSearchQueries);
            }
            return cachedSearchQueries;
        }
    }

    public static class SearchParameter {
        private final String _name;
        private final Object _value;

        public SearchParameter(SpiraCustomPropertyValue spiraCustomPropertyValue) {
            SpiraCustomProperty spiraCustomProperty = spiraCustomPropertyValue.getSpiraCustomProperty();
            this._name = spiraCustomProperty.getName();
            this._value = spiraCustomPropertyValue;
        }

        public SearchParameter(String name, Object value) {
            this._name = name;
            this._value = value;
        }

        public boolean equals(Object object) {
            if (!(object instanceof SearchParameter)) {
                return false;
            }
            SearchParameter searchParameter = (SearchParameter)object;
            JSONObject jsonObject = searchParameter.toJSONObject();
            return jsonObject.similar((Object)this.toJSONObject());
        }

        public String getName() {
            return this._name;
        }

        public Object getValue() {
            return this._value;
        }

        public int hashCode() {
            JSONObject filterJSONObject = this.toFilterJSONObject();
            return filterJSONObject.hashCode();
        }

        public boolean matches(JSONObject jsonObject) {
            if (this._value instanceof SpiraCustomPropertyValue) {
                SpiraCustomPropertyValue spiraCustomPropertyValue = (SpiraCustomPropertyValue)this._value;
                int propertyNumber = spiraCustomPropertyValue.getPropertyNumber();
                JSONArray customPropertiesJSONArray = jsonObject.getJSONArray("CustomProperties");
                for (int i = 0; i < customPropertiesJSONArray.length(); ++i) {
                    JSONObject customPropertyJSONObject = customPropertiesJSONArray.getJSONObject(i);
                    if (propertyNumber != customPropertyJSONObject.getInt("PropertyNumber") || !spiraCustomPropertyValue.matchesJSONObject(customPropertyJSONObject)) continue;
                    return true;
                }
                return false;
            }
            return Objects.equals(this.getValue(), jsonObject.get(this.getName()));
        }

        public JSONObject toFilterJSONObject() {
            if (this._value instanceof String && this._name.equals("Path")) {
                String stringValue = (String)this._value;
                stringValue = stringValue.replaceAll("\\[", "[[]");
                stringValue = stringValue.replaceAll(".*/([^/]+)", "$1");
                JSONObject filterJSONObject = new JSONObject();
                filterJSONObject.put("PropertyName", (Object)"Name");
                filterJSONObject.put("StringValue", (Object)stringValue);
                return filterJSONObject;
            }
            return this.toJSONObject();
        }

        public JSONObject toJSONObject() {
            if (this._value instanceof Integer) {
                Integer intValue = (Integer)this._value;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("IntValue", (Object)intValue);
                jsonObject.put("PropertyName", (Object)this._name);
                return jsonObject;
            }
            if (this._value instanceof SpiraCustomPropertyValue) {
                SpiraCustomPropertyValue spiraCustomPropertyValue = (SpiraCustomPropertyValue)this._value;
                return spiraCustomPropertyValue.getFilterJSONObject();
            }
            if (this._value instanceof String) {
                JSONObject jsonObject = new JSONObject();
                String stringValue = (String)this._value;
                stringValue = stringValue.replaceAll("\\[", "[[]");
                jsonObject.put("PropertyName", (Object)this._name);
                jsonObject.put("StringValue", (Object)stringValue);
                return jsonObject;
            }
            throw new RuntimeException("Invalid value type");
        }
    }
}

